/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.device.DeviceState;
import org.web3d.vrml.device.InputDevice;
import org.web3d.vrml.device.WheelDevice;
import org.web3d.vrml.device.WheelState;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.extensions.BaseHIDSensor;

public class BaseWheelSensor
extends BaseHIDSensor {
    private static final int FIELD_EQUILIBRIUM_POINT = 19;
    private static final int FIELD_BUTTON_1 = 20;
    private static final int FIELD_BUTTON_2 = 21;
    private static final int FIELD_BUTTON_3 = 22;
    private static final int FIELD_BUTTON_4 = 23;
    private static final int FIELD_WHEEL_X = 24;
    private static final int FIELD_THROTTLE_SLIDER = 25;
    private static final int FIELD_FEATURES_AVAILABLE = 26;
    private static final int LAST_WHEEL_SENSOR_INDEX = 26;
    private static final int NUM_FIELDS = 27;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private String[] vfFeaturesAvailable;
    private float vfEquilibriumPoint;
    private float vfWheelX;
    private boolean vfButton1;
    private boolean vfButton2;
    private boolean vfButton3;
    private boolean vfButton4;
    private float vfThrottleSlider;
    private WheelDevice realdevice;

    public BaseWheelSensor() {
        super("WheelSensor");
        this.hasChanged = new boolean[27];
        this.vfFeaturesAvailable = FieldConstants.EMPTY_MFSTRING;
        this.vfEquilibriumPoint = 0.0f;
        this.vfWheelX = 0.0f;
        this.vfButton1 = false;
        this.vfButton1 = false;
        this.vfButton1 = false;
        this.vfButton1 = false;
        this.vfThrottleSlider = 0.0f;
    }

    public BaseWheelSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy(vRMLNodeType);
    }

    public void setDevice(InputDevice inputDevice) {
        this.realdevice = (WheelDevice)inputDevice;
    }

    public void update(DeviceState deviceState) {
        WheelState wheelState = (WheelState)deviceState;
        if (wheelState.wheelX_changed) {
            this.vfWheelX = wheelState.wheelX;
            this.hasChanged[24] = true;
            this.fireFieldChanged(24);
        }
        if (wheelState.button1_changed) {
            this.vfButton1 = wheelState.button1;
            this.hasChanged[20] = true;
            this.fireFieldChanged(20);
        }
        if (wheelState.button2_changed) {
            this.vfButton2 = wheelState.button2;
            this.hasChanged[21] = true;
            this.fireFieldChanged(21);
        }
        if (wheelState.button3_changed) {
            this.vfButton3 = wheelState.button3;
            this.hasChanged[22] = true;
            this.fireFieldChanged(22);
        }
        if (wheelState.button4_changed) {
            this.vfButton1 = wheelState.button4;
            this.hasChanged[23] = true;
            this.fireFieldChanged(23);
        }
        if (wheelState.throttleSlider_changed) {
            this.vfThrottleSlider = wheelState.throttleSlider;
            this.hasChanged[25] = true;
            this.fireFieldChanged(25);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 26) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 26: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfFeaturesAvailable;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfFeaturesAvailable.length;
                break;
            }
            case 24: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfWheelX;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 25: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfThrottleSlider;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 20: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfButton1;
                this.fieldData.dataType = 1;
                break;
            }
            case 21: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfButton2;
                this.fieldData.dataType = 1;
                break;
            }
            case 22: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfButton3;
                this.fieldData.dataType = 1;
                break;
            }
            case 23: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfButton4;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfWheelX);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfThrottleSlider);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfButton1);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfButton2);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfButton3);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfButton4);
                    break;
                }
                case 26: {
                    vRMLNodeType.setValue(n2, this.vfFeaturesAvailable, this.vfFeaturesAvailable.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 19: {
                this.setEquilibriumPoint(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    protected void setEquilibriumPoint(float f) {
        if (this.realdevice != null) {
            this.realdevice.setEquilibriumPoint(f);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[27];
        fieldMap = new HashMap(27);
        BaseWheelSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseWheelSensor.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseWheelSensor.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFString", "name");
        BaseWheelSensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseWheelSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "MFFloat", "axisValue");
        BaseWheelSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFFloat", "axisMinValue");
        BaseWheelSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFFloat", "axisMaxValue");
        BaseWheelSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "MFString", "axisName");
        BaseWheelSensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "MFFloat", "axisResolution");
        BaseWheelSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "MFBool", "axisWrap");
        BaseWheelSensor.fieldDecl[14] = new VRMLFieldDeclaration(4, "MFFloat", "outputMinValue");
        BaseWheelSensor.fieldDecl[15] = new VRMLFieldDeclaration(4, "MFFloat", "outputMaxValue");
        BaseWheelSensor.fieldDecl[13] = new VRMLFieldDeclaration(4, "MFString", "outputName");
        BaseWheelSensor.fieldDecl[16] = new VRMLFieldDeclaration(4, "MFFloat", "outputResolution");
        BaseWheelSensor.fieldDecl[17] = new VRMLFieldDeclaration(4, "MFBool", "outputWrap");
        BaseWheelSensor.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFInt32", "numAxes");
        BaseWheelSensor.fieldDecl[12] = new VRMLFieldDeclaration(4, "SFInt32", "numOutputs");
        BaseWheelSensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFString", "manufacturerName");
        BaseWheelSensor.fieldDecl[19] = new VRMLFieldDeclaration(1, "SFFloat", "equilibriumPoint");
        BaseWheelSensor.fieldDecl[26] = new VRMLFieldDeclaration(4, "MFString", "featuresAvailable");
        BaseWheelSensor.fieldDecl[24] = new VRMLFieldDeclaration(4, "SFFloat", "wheelX");
        BaseWheelSensor.fieldDecl[20] = new VRMLFieldDeclaration(4, "SFBool", "button1");
        BaseWheelSensor.fieldDecl[21] = new VRMLFieldDeclaration(4, "SFBool", "button2");
        BaseWheelSensor.fieldDecl[22] = new VRMLFieldDeclaration(4, "SFBool", "button3");
        BaseWheelSensor.fieldDecl[23] = new VRMLFieldDeclaration(4, "SFBool", "button4");
        BaseWheelSensor.fieldDecl[25] = new VRMLFieldDeclaration(4, "SFFloat", "throttleSlider");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        n = new Integer(18);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("isActive", n);
        fieldMap.put("isActive_changed", n);
        n = new Integer(2);
        fieldMap.put("outputValue", n);
        fieldMap.put("outputValue_changed", n);
        n = new Integer(4);
        fieldMap.put("axisValue", n);
        fieldMap.put("axisValue_changed", n);
        n = new Integer(5);
        fieldMap.put("axisMinValue", n);
        fieldMap.put("axisMinValue_changed", n);
        n = new Integer(6);
        fieldMap.put("axisMaxValue", n);
        fieldMap.put("axisMaxValue_changed", n);
        n = new Integer(7);
        fieldMap.put("axisName", n);
        fieldMap.put("axisName_changed", n);
        n = new Integer(8);
        fieldMap.put("axisResolution", n);
        fieldMap.put("axisResolution_changed", n);
        n = new Integer(9);
        fieldMap.put("axisWrap", n);
        fieldMap.put("axisWrap_changed", n);
        n = new Integer(14);
        fieldMap.put("outputMinValue", n);
        fieldMap.put("outputMinValue_changed", n);
        n = new Integer(15);
        fieldMap.put("outputMaxValue", n);
        fieldMap.put("outputMaxValue_changed", n);
        n = new Integer(13);
        fieldMap.put("outputName", n);
        fieldMap.put("outputName_changed", n);
        n = new Integer(16);
        fieldMap.put("outputResolution", n);
        fieldMap.put("outputResolution_changed", n);
        n = new Integer(17);
        fieldMap.put("outputWrap", n);
        fieldMap.put("outputWrap_changed", n);
        n = new Integer(11);
        fieldMap.put("numAxes", n);
        fieldMap.put("numAxes_changed", n);
        n = new Integer(12);
        fieldMap.put("numOutputs", n);
        fieldMap.put("numOutputs_changed", n);
        n = new Integer(26);
        fieldMap.put("featuresAvailable", n);
        fieldMap.put("featuresAvailable_changed", n);
        n = new Integer(10);
        fieldMap.put("manufacturerName", n);
        fieldMap.put("manufacturerName_changed", n);
        n = new Integer(24);
        fieldMap.put("wheelX", n);
        fieldMap.put("wheelX_changed", n);
        n = new Integer(19);
        fieldMap.put("equilibriumPoint", n);
        fieldMap.put("equilibriumPoint_changed", n);
        n = new Integer(20);
        fieldMap.put("button1", n);
        fieldMap.put("button1_changed", n);
        n = new Integer(21);
        fieldMap.put("button2", n);
        fieldMap.put("button2_changed", n);
        n = new Integer(21);
        fieldMap.put("button2", n);
        fieldMap.put("button2_changed", n);
        n = new Integer(22);
        fieldMap.put("button3", n);
        fieldMap.put("button3_changed", n);
        n = new Integer(23);
        fieldMap.put("button4", n);
        fieldMap.put("button4_changed", n);
        n = new Integer(25);
        fieldMap.put("throttleSlider", n);
        fieldMap.put("throttleSlider_changed", n);
    }
}

