/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom3d;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseCylinder
extends AbstractNode
implements VRMLGeometryNodeType {
    protected static final int FIELD_SOLID = 1;
    protected static final int FIELD_RADIUS = 2;
    protected static final int FIELD_HEIGHT = 3;
    protected static final int FIELD_BOTTOM = 4;
    protected static final int FIELD_SIDE = 5;
    protected static final int FIELD_TOP = 6;
    protected static final int LAST_CYLINDER_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float vfRadius;
    protected float vfHeight;
    protected boolean vfBottom;
    protected boolean vfSide;
    protected boolean vfTop;
    protected boolean vfSolid;

    protected BaseCylinder() {
        super("Cylinder");
        this.hasChanged = new boolean[7];
        this.vfRadius = 1.0f;
        this.vfHeight = 2.0f;
        this.vfBottom = true;
        this.vfSide = true;
        this.vfTop = true;
        this.vfSolid = true;
    }

    protected BaseCylinder(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.vfSolid = ((VRMLGeometryNodeType)vRMLNodeType).isSolid();
        try {
            int n = vRMLNodeType.getFieldIndex("bottom");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBottom = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("radius");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRadius = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("height");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHeight = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("side");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSide = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("top");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTop = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                this.fieldData.booleanValue = this.vfSolid;
                this.fieldData.dataType = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRadius;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfHeight;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfTop;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfBottom;
                this.fieldData.dataType = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfSide;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (this.inSetup) {
            switch (n) {
                case 2: {
                    this.vfRadius = f;
                    return;
                }
                case 3: {
                    this.vfHeight = f;
                    return;
                }
            }
            super.setValue(n, f);
        } else {
            super.setValue(n, f);
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  bottom");
                }
                this.vfBottom = bl;
                break;
            }
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  side");
                }
                this.vfSide = bl;
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  top");
                }
                this.vfTop = bl;
                break;
            }
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  solid");
                }
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(7);
        BaseCylinder.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCylinder.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFFloat", "radius");
        BaseCylinder.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFFloat", "height");
        BaseCylinder.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFBool", "bottom");
        BaseCylinder.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "side");
        BaseCylinder.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "top");
        BaseCylinder.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("radius", new Integer(2));
        fieldMap.put("height", new Integer(3));
        fieldMap.put("bottom", new Integer(4));
        fieldMap.put("side", new Integer(5));
        fieldMap.put("top", new Integer(6));
        fieldMap.put("solid", new Integer(1));
    }
}

