/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geom3d;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseSphere
extends AbstractNode
implements VRMLGeometryNodeType {
    protected static final int FIELD_SOLID = 1;
    protected static final int FIELD_RADIUS = 2;
    protected static final int LAST_SPHERE_INDEX = 2;
    protected static final int NUM_FIELDS = 3;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float vfRadius;
    protected boolean vfSolid;

    protected BaseSphere() {
        super("Sphere");
        this.hasChanged = new boolean[3];
        this.vfRadius = 1.0f;
        this.vfSolid = true;
    }

    public BaseSphere(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.vfSolid = ((VRMLGeometryNodeType)vRMLNodeType).isSolid();
        try {
            int n = vRMLNodeType.getFieldIndex("radius");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRadius = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 2) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 21;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                this.fieldData.booleanValue = this.vfSolid;
                this.fieldData.dataType = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRadius;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                if (this.inSetup) {
                    if (f <= 0.0f) {
                        throw new InvalidFieldValueException("Sphere radius <= 0");
                    }
                } else {
                    throw new InvalidFieldAccessException("Cannot set initializeOnly field radius after startup");
                }
                this.vfRadius = f;
                return;
            }
        }
        super.setValue(n, f);
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (this.vrmlMajorVersion < 3) {
                    throw new InvalidFieldException("Field solid not defined for VRML97");
                }
                if (!this.inSetup) {
                    throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field:  solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[3];
        fieldMap = new HashMap(3);
        BaseSphere.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSphere.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFFloat", "radius");
        BaseSphere.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("radius", new Integer(2));
        fieldMap.put("solid", new Integer(1));
    }
}

