/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;

public abstract class BaseGeoCoordinate
extends BaseGeometricPropertyNode
implements VRMLCoordinateNodeType {
    protected static final int FIELD_POINT = 1;
    protected static final int FIELD_GEO_ORIGIN = 2;
    protected static final int FIELD_GEO_SYSTEM = 3;
    protected static final int LAST_COORDINATE_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected double[] vfPoint = FieldConstants.EMPTY_MFDOUBLE;
    protected int numPoint;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    private float[] renderPoints;
    protected double[] localCoords = FieldConstants.EMPTY_MFDOUBLE;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;

    public BaseGeoCoordinate() {
        super("GeoCoordinate");
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.hasChanged = new boolean[4];
    }

    public BaseGeoCoordinate(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("point");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfPoint = new double[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfPoint, 0, vRMLFieldData.numElements * 3);
                this.numPoint = vRMLFieldData.numElements * 3;
            }
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setPoint(float[] fArray, int n) {
        int n2;
        if (n > this.vfPoint.length) {
            this.vfPoint = new double[n];
        }
        this.numPoint = n;
        for (n2 = 0; n2 < n; ++n2) {
            this.vfPoint[n2] = fArray[n2];
        }
        if (this.inSetup) {
            return;
        }
        if (this.geoTransform != null) {
            if (this.renderPoints == null || this.renderPoints.length < n) {
                this.renderPoints = new float[n];
            }
            try {
                if (this.geoCoordSwap) {
                    float f;
                    for (n2 = 0; n2 < n; n2 += 3) {
                        f = fArray[n2];
                        fArray[n2] = fArray[n2 + 1];
                        fArray[n2 + 1] = f;
                    }
                    this.geoTransform.transform(fArray, 0, this.renderPoints, 0, n / 3);
                    for (n2 = 0; n2 < n; n2 += 3) {
                        f = fArray[n2 + 1];
                        fArray[n2 + 1] = fArray[n2];
                        fArray[n2] = f;
                    }
                } else {
                    this.geoTransform.transform(fArray, 0, this.renderPoints, 0, n / 3);
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
        this.fireComponentChanged(1);
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public int getNumPoints() {
        return this.numPoint;
    }

    public void getPoint(float[] fArray) {
        for (int i = 0; i < this.numPoint; ++i) {
            fArray[i] = (float)this.vfPoint[i];
        }
    }

    public float[] getPointRef() {
        return this.renderPoints;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            int n;
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            if (this.geoCoordSwap) {
                double d;
                for (n = 0; n < this.numPoint; n += 3) {
                    d = this.vfPoint[n];
                    this.vfPoint[n] = this.vfPoint[n + 1];
                    this.vfPoint[n + 1] = d;
                }
                this.geoTransform.transform(this.vfPoint, 0, this.localCoords, 0, this.numPoint / 3);
                for (n = 0; n < this.numPoint; n += 3) {
                    d = this.vfPoint[n + 1];
                    this.vfPoint[n + 1] = this.vfPoint[n];
                    this.vfPoint[n] = d;
                }
            } else {
                this.geoTransform.transform(this.vfPoint, 0, this.localCoords, 0, this.numPoint / 3);
            }
            if (this.renderPoints == null || this.renderPoints.length < this.numPoint) {
                this.renderPoints = new float[this.numPoint];
            }
            if (this.vfGeoOrigin == null) {
                for (n = 0; n < this.numPoint / 3; ++n) {
                    this.renderPoints[n * 3] = (float)this.localCoords[n * 3];
                    this.renderPoints[n * 3 + 1] = (float)this.localCoords[n * 3 + 1];
                    this.renderPoints[n * 3 + 2] = (float)this.localCoords[n * 3 + 2];
                }
            } else {
                double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                for (int i = 0; i < this.numPoint / 3; ++i) {
                    this.renderPoints[i * 3] = (float)(this.localCoords[i * 3] - dArray[0]);
                    this.renderPoints[i * 3 + 1] = (float)(this.localCoords[i * 3 + 1] - dArray[1]);
                    this.renderPoints[i * 3 + 2] = (float)(this.localCoords[i * 3 + 2] - dArray[2]);
                }
            }
            if (this.isStatic) {
                this.localCoords = null;
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 11;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfPoint;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.numPoint / 3;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfPoint, this.numPoint);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setPoint(dArray, n2);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 2: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setPoint(double[] dArray, int n) {
        if (n > this.vfPoint.length) {
            this.vfPoint = new double[n];
            this.localCoords = new double[n];
        }
        this.numPoint = n;
        System.arraycopy(dArray, 0, this.vfPoint, 0, this.numPoint);
        if (this.inSetup) {
            return;
        }
        if (this.geoTransform != null) {
            try {
                int n2;
                if (this.geoCoordSwap) {
                    double d;
                    for (n2 = 0; n2 < this.numPoint; n2 += 3) {
                        d = this.vfPoint[n2];
                        this.vfPoint[n2] = this.vfPoint[n2 + 1];
                        this.vfPoint[n2 + 1] = d;
                    }
                    this.geoTransform.transform(this.vfPoint, 0, this.localCoords, 0, this.numPoint / 3);
                    for (n2 = 0; n2 < this.numPoint; n2 += 3) {
                        d = this.vfPoint[n2 + 1];
                        this.vfPoint[n2 + 1] = this.vfPoint[n2];
                        this.vfPoint[n2] = d;
                    }
                } else {
                    this.geoTransform.transform(this.vfPoint, 0, this.localCoords, 0, this.numPoint / 3);
                }
                if (this.renderPoints == null || this.renderPoints.length < n) {
                    this.renderPoints = new float[n];
                }
                if (this.vfGeoOrigin == null) {
                    for (n2 = 0; n2 < this.numPoint / 3; ++n2) {
                        this.renderPoints[n2 * 3] = (float)this.localCoords[n2 * 3];
                        this.renderPoints[n2 * 3 + 1] = (float)this.localCoords[n2 * 3 + 1];
                        this.renderPoints[n2 * 3 + 2] = (float)this.localCoords[n2 * 3 + 2];
                    }
                } else {
                    double[] dArray2 = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                    for (int i = 0; i < this.numPoint / 3; ++i) {
                        this.renderPoints[i * 3] = (float)(this.localCoords[i * 3] - dArray2[0]);
                        this.renderPoints[i * 3 + 1] = (float)(this.localCoords[i * 3 + 1] - dArray2[1]);
                        this.renderPoints[i * 3 + 2] = (float)(this.localCoords[i * 3 + 2] - dArray2[2]);
                    }
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
        this.fireComponentChanged(1);
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    static {
        nodeFields = new int[]{0, 2};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseGeoCoordinate.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoCoordinate.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3d", "point");
        BaseGeoCoordinate.fieldDecl[3] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoCoordinate.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("point", n);
        fieldMap.put("set_point", n);
        fieldMap.put("point_changed", n);
        fieldMap.put("geoSystem", new Integer(3));
        fieldMap.put("geoOrigin", new Integer(2));
    }
}

