/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.util.FieldValidator;

public class BaseGeoElevationGrid
extends AbstractNode
implements VRMLComponentGeometryNodeType {
    protected static final int FIELD_SET_HEIGHT = 1;
    protected static final int FIELD_COLOR = 2;
    protected static final int FIELD_NORMAL = 3;
    protected static final int FIELD_TEXCOORD = 4;
    protected static final int FIELD_CCW = 5;
    protected static final int FIELD_COLORPERVERTEX = 6;
    protected static final int FIELD_CREASEANGLE = 7;
    protected static final int FIELD_GEO_GRID_ORIGIN = 8;
    protected static final int FIELD_GEO_ORIGIN = 9;
    protected static final int FIELD_GEO_SYSTEM = 10;
    protected static final int FIELD_HEIGHT = 11;
    protected static final int FIELD_NORMALPERVERTEX = 12;
    protected static final int FIELD_SOLID = 13;
    protected static final int FIELD_XDIMENSION = 14;
    protected static final int FIELD_XSPACING = 15;
    protected static final int FIELD_ZDIMENSION = 16;
    protected static final int FIELD_ZSPACING = 17;
    protected static final int FIELD_YSCALE = 18;
    protected static final int LAST_ELEVATIONGRID_INDEX = 18;
    private static final int NUM_FIELDS = 19;
    private static final String COLOR_PROTO_MSG = "Proto does not describe a Color object";
    private static final String COLOR_NODE_MSG = "Node does not describe a Color object";
    private static final String NORMAL_PROTO_MSG = "Proto does not describe a Normal object";
    private static final String NORMAL_NODE_MSG = "Node does not describe a Normal object";
    private static final String TEXCOORD_PROTO_MSG = "Proto does not describe a TexCoord object";
    private static final String TEXCOORD_NODE_MSG = "Node does not describe a TexCoord object";
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    protected static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected VRMLProtoInstance pColor;
    protected VRMLColorNodeType vfColor;
    protected VRMLProtoInstance pNormal;
    protected VRMLNormalNodeType vfNormal;
    protected VRMLProtoInstance pTexCoord;
    protected VRMLTextureCoordinateNodeType vfTexCoord;
    protected boolean vfCcw;
    protected double[] vfHeight;
    protected int heightLen;
    protected double vfCreaseAngle;
    protected boolean vfColorPerVertex;
    protected boolean vfNormalPerVertex;
    protected boolean vfSolid;
    protected int vfXDimension;
    protected double vfXSpacing;
    protected int vfZDimension;
    protected double vfZSpacing;
    protected float vfYScale;
    protected double[] vfGeoGridOrigin;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    private float[] renderPoints;
    protected double[] localCoords;
    protected MathTransform geoTransform;
    protected boolean geoCoordSwap;
    protected boolean localColors;
    protected ArrayList localColorsListeners;

    public BaseGeoElevationGrid() {
        super("GeoElevationGrid");
        this.hasChanged = new boolean[19];
        this.vfColorPerVertex = true;
        this.vfNormalPerVertex = true;
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfGeoGridOrigin = new double[3];
        this.vfHeight = FieldConstants.EMPTY_MFDOUBLE;
        this.heightLen = 0;
        this.vfCreaseAngle = 0.0;
        this.vfXDimension = 0;
        this.vfXSpacing = 0.0;
        this.vfZDimension = 0;
        this.vfZSpacing = 0.0;
        this.vfYScale = 1.0f;
        this.vfSolid = true;
        this.vfColorPerVertex = true;
        this.vfNormalPerVertex = true;
        this.vfCcw = true;
        this.localColors = false;
        this.localColorsListeners = new ArrayList(1);
        this.localCoords = FieldConstants.EMPTY_MFDOUBLE;
    }

    public BaseGeoElevationGrid(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("ccw");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCcw = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("creaseAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCreaseAngle = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("normalPerVertex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfNormalPerVertex = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("colorPerVertex");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfColorPerVertex = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("xDimension");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfXDimension = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("zDimension");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfZDimension = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("xSpacing");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfXSpacing = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("zSpacing");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfZSpacing = vRMLFieldData.doubleValue;
            n = vRMLNodeType.getFieldIndex("yScale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfYScale = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("height");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHeight = vRMLFieldData.doubleArrayValue;
            this.heightLen = vRMLFieldData.numElements;
            n = vRMLNodeType.getFieldIndex("solid");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSolid = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("geoGridOrigin");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGeoGridOrigin[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfGeoGridOrigin[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfGeoGridOrigin[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return this.localColors;
    }

    public boolean hasLocalColorAlpha() {
        return this.vfColor != null && this.vfColor.getNumColorComponents() == 4;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
        if (localColorsListener != null) {
            this.localColorsListeners.add(localColorsListener);
        }
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
        this.localColorsListeners.remove(localColorsListener);
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
        System.out.println("GeoEV TexCoordGenMode changes not implemented");
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        if (this.vfTexCoord == null) {
            return null;
        }
        return this.vfTexCoord.getTexCoordGenMode(n);
    }

    public int getNumSets() {
        if (this.vfTexCoord == null) {
            return 0;
        }
        return this.vfTexCoord.getNumSets();
    }

    public boolean isSolid() {
        return this.vfSolid;
    }

    public boolean isCCW() {
        return this.vfCcw;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public boolean hasColorPerVertex() {
        return this.vfColorPerVertex;
    }

    public boolean hasNormalPerVertex() {
        return this.vfNormalPerVertex;
    }

    public boolean requiresUnlitColor() {
        return false;
    }

    public void setUnlitColor(float[] fArray) {
    }

    public VRMLNodeType[] getComponents() {
        int n = 3;
        if (this.vfNormal == null) {
            --n;
        }
        if (this.vfTexCoord == null) {
            --n;
        }
        if (this.vfColor == null) {
            --n;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        n = 0;
        if (this.pNormal != null) {
            vRMLNodeTypeArray[n++] = this.pNormal;
        } else if (this.vfNormal != null) {
            vRMLNodeTypeArray[n++] = this.vfNormal;
        }
        if (this.pTexCoord != null) {
            vRMLNodeTypeArray[n++] = this.pTexCoord;
        } else if (this.pTexCoord != null) {
            vRMLNodeTypeArray[n++] = this.vfTexCoord;
        }
        if (this.pColor != null) {
            vRMLNodeTypeArray[n++] = this.pColor;
        } else if (this.vfColor != null) {
            vRMLNodeTypeArray[n++] = this.vfColor;
        }
        return vRMLNodeTypeArray;
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        block5: for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            VRMLProtoInstance vRMLProtoInstance;
            VRMLNodeType vRMLNodeType = vRMLNodeTypeArray[i];
            if (vRMLNodeType instanceof VRMLProtoInstance) {
                vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                vRMLNodeType = vRMLProtoInstance.getImplementationNode();
            } else {
                vRMLProtoInstance = null;
            }
            switch (vRMLNodeType.getPrimaryType()) {
                case 34: {
                    this.pNormal = vRMLProtoInstance;
                    this.vfNormal = (VRMLNormalNodeType)vRMLNodeType;
                    continue block5;
                }
                case 48: {
                    this.pTexCoord = vRMLProtoInstance;
                    this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType;
                    continue block5;
                }
                case 9: {
                    this.pColor = vRMLProtoInstance;
                    this.vfColor = (VRMLColorNodeType)vRMLNodeType;
                    if (this.vfColor != null) {
                        if (!this.localColors) {
                            this.fireLocalColorsChanged(true);
                        }
                        this.localColors = true;
                        continue block5;
                    }
                    if (this.localColors) {
                        this.fireLocalColorsChanged(false);
                    }
                    this.localColors = false;
                    continue block5;
                }
                default: {
                    throw new InvalidFieldValueException("Unknown component type");
                }
            }
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLProtoInstance vRMLProtoInstance;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        if (vRMLNodeType2 instanceof VRMLProtoInstance) {
            vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
            vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
        } else {
            vRMLProtoInstance = null;
        }
        switch (vRMLNodeType2.getPrimaryType()) {
            case 34: {
                this.pNormal = vRMLProtoInstance;
                this.vfNormal = (VRMLNormalNodeType)vRMLNodeType2;
                break;
            }
            case 48: {
                this.pTexCoord = vRMLProtoInstance;
                this.vfTexCoord = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
                break;
            }
            case 9: {
                this.pColor = vRMLProtoInstance;
                this.vfColor = (VRMLColorNodeType)vRMLNodeType2;
                if (this.vfColor != null) {
                    if (!this.localColors) {
                        this.fireLocalColorsChanged(true);
                    }
                    this.localColors = true;
                    break;
                }
                if (this.localColors) {
                    this.fireLocalColorsChanged(false);
                }
                this.localColors = false;
                break;
            }
            default: {
                throw new InvalidFieldValueException("Unknown component type");
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pColor != null) {
            this.pColor.setupFinished();
        } else if (this.vfColor != null) {
            this.vfColor.setupFinished();
        }
        if (this.pNormal != null) {
            this.pNormal.setupFinished();
        } else if (this.vfNormal != null) {
            this.vfNormal.setupFinished();
        }
        if (this.pTexCoord != null) {
            this.pTexCoord.setupFinished();
        } else if (this.vfTexCoord != null) {
            this.vfTexCoord.setupFinished();
        }
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 18) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 58;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pColor != null ? this.pColor : this.vfColor;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pNormal != null ? this.pNormal : this.vfNormal;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pTexCoord != null ? this.pTexCoord : this.vfTexCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfGeoGridOrigin;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = 1;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfHeight;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.heightLen;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfCcw;
                this.fieldData.dataType = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfCreaseAngle;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfColorPerVertex;
                this.fieldData.dataType = 1;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfNormalPerVertex;
                this.fieldData.dataType = 1;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfSolid;
                this.fieldData.dataType = 1;
                break;
            }
            case 14: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfXDimension;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 16: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfZDimension;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfXSpacing;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 17: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfZSpacing;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 18: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfYScale;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    if (this.pColor != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pColor);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfColor);
                    break;
                }
                case 3: {
                    if (this.pNormal != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pNormal);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfNormal);
                    break;
                }
                case 4: {
                    if (this.pTexCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pTexCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfTexCoord);
                    break;
                }
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfYScale);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: ccw");
                }
                this.vfCcw = bl;
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: colorPerVertex");
                }
                this.vfColorPerVertex = bl;
                break;
            }
            case 12: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: normalPerVertex");
                }
                this.vfNormalPerVertex = bl;
                break;
            }
            case 13: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 14: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: xDimension");
                }
                FieldValidator.checkDoublePosInfinity((String)"ElevationGrid.xDimension", (double)n2);
                this.vfXDimension = n2;
                break;
            }
            case 16: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: yDimension");
                }
                FieldValidator.checkDoublePosInfinity((String)"ElevationGrid.zDimension", (double)n2);
                this.vfZDimension = n2;
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: creaseAngle");
                }
                FieldValidator.checkDoublePosInfinity((String)"ElevationGrid.creaseAngle", (double)d);
                this.vfCreaseAngle = d;
                break;
            }
            case 15: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: xSpacing");
                }
                FieldValidator.checkDoublePosInfinity((String)"ElevationGrid.xSpacing", (double)d);
                this.vfXSpacing = d;
                break;
            }
            case 17: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: zSpacing");
                }
                FieldValidator.checkDoublePosInfinity((String)"ElevationGrid.zSpacing", (double)d);
                this.vfZSpacing = d;
                break;
            }
            default: {
                super.setValue(n, d);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 18: {
                FieldValidator.checkDoublePosInfinity((String)"GeoElevationGrid.yScale", (double)f);
                this.vfYScale = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: height");
                }
                this.vfHeight = dArray;
                this.heightLen = n2;
                break;
            }
            case 1: {
                if (this.inSetup) {
                    throw new InvalidFieldAccessException("set_height is an inputOnly field");
                }
                if (this.vfHeight.length < n2) {
                    this.vfHeight = new double[n2];
                }
                System.arraycopy(this.vfHeight, 0, dArray, 0, n2);
                this.heightLen = n2;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            case 8: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoGridOrigin");
                }
                this.vfGeoGridOrigin[0] = dArray[0];
                this.vfGeoGridOrigin[1] = dArray[1];
                this.vfGeoGridOrigin[2] = dArray[2];
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setNormal(vRMLNodeType);
                break;
            }
            case 2: {
                this.setColor(vRMLNodeType);
                break;
            }
            case 4: {
                this.setTexCoord(vRMLNodeType);
                break;
            }
            case 9: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void fireLocalColorsChanged(boolean bl) {
        int n = this.localColorsListeners.size();
        boolean bl2 = this.vfColor != null && this.vfColor.getNumColorComponents() == 4;
        for (int i = 0; i < n; ++i) {
            try {
                LocalColorsListener localColorsListener = (LocalColorsListener)this.localColorsListeners.get(i);
                localColorsListener.localColorsChanged(bl, bl2);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending localColorsChanged message: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    private void setNormal(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNormalNodeType vRMLNormalNodeType;
        Object object = this.pNormal != null ? this.pNormal : this.vfNormal;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLNormalNodeType)) {
                throw new InvalidFieldValueException(NORMAL_PROTO_MSG);
            }
            vRMLNormalNodeType = (VRMLNormalNodeType)vRMLNodeType2;
            this.pNormal = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLNormalNodeType)) {
                throw new InvalidFieldValueException(NORMAL_NODE_MSG);
            }
            this.pNormal = null;
            vRMLNormalNodeType = (VRMLNormalNodeType)vRMLNodeType;
        }
        this.vfNormal = vRMLNormalNodeType;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setColor(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLColorNodeType vRMLColorNodeType;
        Object object = this.pColor != null ? this.pColor : this.vfColor;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLColorNodeType)) {
                throw new InvalidFieldValueException(COLOR_PROTO_MSG);
            }
            vRMLColorNodeType = (VRMLColorNodeType)vRMLNodeType2;
            this.pColor = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLColorNodeType)) {
                throw new InvalidFieldValueException(COLOR_NODE_MSG);
            }
            this.pColor = null;
            vRMLColorNodeType = (VRMLColorNodeType)vRMLNodeType;
        }
        this.vfColor = vRMLColorNodeType;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
        if (this.vfColor != null) {
            if (!this.localColors) {
                this.fireLocalColorsChanged(true);
            }
            this.localColors = true;
        } else {
            if (this.localColors) {
                this.fireLocalColorsChanged(false);
            }
            this.localColors = false;
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setTexCoord(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType;
        Object object = this.pTexCoord != null ? this.pTexCoord : this.vfTexCoord;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXCOORD_PROTO_MSG);
            }
            vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)vRMLNodeType2;
            this.pTexCoord = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXCOORD_NODE_MSG);
            }
            this.pTexCoord = null;
            vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)vRMLNodeType;
        }
        this.vfTexCoord = vRMLTextureCoordinateNodeType;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    static {
        nodeFields = new int[]{0, 2, 3, 4};
        fieldDecl = new VRMLFieldDeclaration[19];
        fieldMap = new HashMap(57);
        BaseGeoElevationGrid.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoElevationGrid.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFDouble", "height");
        BaseGeoElevationGrid.fieldDecl[1] = new VRMLFieldDeclaration(1, "MFDouble", "set_height");
        BaseGeoElevationGrid.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseGeoElevationGrid.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseGeoElevationGrid.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseGeoElevationGrid.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFFloat", "yScale");
        BaseGeoElevationGrid.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseGeoElevationGrid.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseGeoElevationGrid.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFDouble", "creaseAngle");
        BaseGeoElevationGrid.fieldDecl[12] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseGeoElevationGrid.fieldDecl[13] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseGeoElevationGrid.fieldDecl[14] = new VRMLFieldDeclaration(2, "SFInt32", "xDimension");
        BaseGeoElevationGrid.fieldDecl[16] = new VRMLFieldDeclaration(2, "SFInt32", "zDimension");
        BaseGeoElevationGrid.fieldDecl[15] = new VRMLFieldDeclaration(2, "SFDouble", "xSpacing");
        BaseGeoElevationGrid.fieldDecl[17] = new VRMLFieldDeclaration(2, "SFDouble", "zSpacing");
        BaseGeoElevationGrid.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFVec3d", "geoGridOrigin");
        BaseGeoElevationGrid.fieldDecl[10] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoElevationGrid.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("height", new Integer(11));
        fieldMap.put("set_height", new Integer(1));
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(18);
        fieldMap.put("yScale", n);
        fieldMap.put("set_yScale", n);
        fieldMap.put("yScale_changed", n);
        fieldMap.put("colorPerVertex", new Integer(6));
        fieldMap.put("ccw", new Integer(5));
        fieldMap.put("creaseAngle", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(12));
        fieldMap.put("solid", new Integer(13));
        fieldMap.put("xDimension", new Integer(14));
        fieldMap.put("xSpacing", new Integer(15));
        fieldMap.put("zDimension", new Integer(16));
        fieldMap.put("zSpacing", new Integer(17));
        fieldMap.put("geoGridOrigin", new Integer(8));
        fieldMap.put("geoSystem", new Integer(10));
        fieldMap.put("geoOrigin", new Integer(9));
    }
}

