/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.nodes.VRMLViewDependentNodeType;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.renderer.common.nodes.geospatial.SceneWrapper;
import org.web3d.vrml.util.URLChecker;

public abstract class BaseGeoLOD
extends BaseGroupingNode
implements VRMLViewDependentNodeType,
VRMLMultiExternalNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{30, 88};
    protected static final int FIELD_ROOT_NODE = 6;
    protected static final int FIELD_ROOT_URL = 7;
    protected static final int FIELD_CHILD1_URL = 8;
    protected static final int FIELD_CHILD2_URL = 9;
    protected static final int FIELD_CHILD3_URL = 10;
    protected static final int FIELD_CHILD4_URL = 11;
    protected static final int FIELD_GEO_ORIGIN = 12;
    protected static final int FIELD_GEO_SYSTEM = 13;
    protected static final int FIELD_CENTER = 14;
    protected static final int FIELD_RANGE = 15;
    protected static final int LAST_LOD_INDEX = 15;
    protected static final int NUM_FIELDS = 16;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final String NEG_RANGE_MSG = "GeoLOD range value provided is negative. Must be [0,oo): ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private static final int[] urlFieldIndexList;
    private static final int[] urlFieldChildrenIndexList;
    private static final int[] urlFieldRootIndexList;
    private static final HashSet validX3DTypes;
    protected double[] vfCenter;
    protected float vfRange;
    protected String[] vfChild1Url;
    protected String[] vfChild2Url;
    protected String[] vfChild3Url;
    protected String[] vfChild4Url;
    protected String[] vfRootUrl;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    protected ArrayList vfRootNode;
    protected VRMLNodeType[] nodeTmp;
    protected double[] localCenter;
    protected String worldURL;
    protected boolean urlRelativeCheck;
    protected int[] loadState;
    protected boolean childrenShown;
    protected String[] loadedUri;
    private ArrayList urlListeners;
    private ArrayList contentListeners;
    protected VRMLScene[] childScenes;
    protected SceneWrapper[] loadedScenes;

    protected BaseGeoLOD() {
        super("GeoLOD");
        this.hasChanged = new boolean[16];
        this.vfCenter = new double[3];
        this.vfRange = 10.0f;
        this.vfChild1Url = FieldConstants.EMPTY_MFSTRING;
        this.vfChild2Url = FieldConstants.EMPTY_MFSTRING;
        this.vfChild3Url = FieldConstants.EMPTY_MFSTRING;
        this.vfChild4Url = FieldConstants.EMPTY_MFSTRING;
        this.vfRootUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfRootNode = new ArrayList();
        this.localCenter = new double[3];
        this.urlRelativeCheck = false;
        this.loadState = new int[16];
        this.loadedUri = new String[16];
        this.urlListeners = new ArrayList(1);
        this.contentListeners = new ArrayList(1);
    }

    protected BaseGeoLOD(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("range");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRange = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("child1Url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfChild1Url = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfChild1Url, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("child2Url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfChild2Url = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfChild2Url, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("child1Url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfChild1Url = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfChild3Url, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("child4Url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfChild4Url = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfChild4Url, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("rootUrl");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfRootUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfRootUrl, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int[] getUrlFieldIndexes() {
        if (this.childrenShown) {
            return urlFieldChildrenIndexList;
        }
        return urlFieldRootIndexList;
    }

    public String[] getUrl(int n) throws InvalidFieldException {
        String[] stringArray = null;
        switch (n) {
            case 7: {
                stringArray = this.vfRootUrl;
                break;
            }
            case 8: {
                stringArray = this.vfChild1Url;
                break;
            }
            case 9: {
                stringArray = this.vfChild2Url;
                break;
            }
            case 10: {
                stringArray = this.vfChild3Url;
                break;
            }
            case 11: {
                stringArray = this.vfChild4Url;
                break;
            }
            default: {
                throw new InvalidFieldException("getURL invalid index");
            }
        }
        return stringArray;
    }

    public int getLoadState(int n) {
        return this.loadState[n];
    }

    public void setLoadState(int n, int n2) {
        this.loadState[n] = n2;
        this.fireContentStateChanged(n);
    }

    public boolean checkValidContentType(int n, String string) {
        return validX3DTypes.contains((Object)string);
    }

    public Class[] getPreferredClassTypes(int n) throws InvalidFieldException {
        return null;
    }

    public void setLoadedURI(int n, String string) {
        this.loadedUri[n] = string;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        this.checkURLs();
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setupFinished() {
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        this.checkURLs();
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            object = new boolean[1];
            MathTransform mathTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, (boolean[])object);
            if (object[0]) {
                double d = this.vfCenter[0];
                this.vfCenter[0] = this.vfCenter[1];
                this.vfCenter[1] = d;
                mathTransform.transform(this.vfCenter, 0, this.localCenter, 0, 1);
                d = this.vfCenter[0];
                this.vfCenter[0] = this.vfCenter[1];
                this.vfCenter[1] = d;
            } else {
                mathTransform.transform(this.vfCenter, 0, this.localCenter, 0, 1);
            }
            if (this.vfGeoOrigin != null) {
                double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localCenter[0] = this.localCenter[0] - dArray[0];
                this.localCenter[1] = this.localCenter[1] - dArray[1];
                this.localCenter[2] = this.localCenter[2] - dArray[2];
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
        int n = this.vfRootNode.size();
        for (int i = 0; i < n; ++i) {
            object = (VRMLNodeType)this.vfRootNode.get(i);
            object.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 15) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 14: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfCenter;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = 1;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRange;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfRootUrl;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfRootUrl.length;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfChild1Url;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfChild1Url.length;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfChild2Url;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfChild2Url.length;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfChild3Url;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfChild3Url.length;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfChild4Url;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfChild4Url.length;
                break;
            }
            case 6: {
                int n2 = this.vfRootNode.size();
                if (this.nodeTmp == null || this.nodeTmp.length < n2) {
                    this.nodeTmp = new VRMLNodeType[n2];
                }
                this.vfRootNode.toArray(this.nodeTmp);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.nodeTmp;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = n2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 15: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: range");
                }
                if (f < 0.0f) {
                    throw new InvalidFieldValueException(NEG_RANGE_MSG + f);
                }
                this.vfRange = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 14: {
                this.setCenter(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 13: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: rootUrl");
                }
                if (this.vfRootUrl.length != n2) {
                    this.vfRootUrl = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfRootUrl[i] = stringArray[i];
                }
                break;
            }
            case 8: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: child1Url");
                }
                if (this.vfChild1Url.length != n2) {
                    this.vfChild1Url = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfChild1Url[i] = stringArray[i];
                }
                break;
            }
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: child2Url");
                }
                if (this.vfChild2Url.length != n2) {
                    this.vfChild2Url = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfChild2Url[i] = stringArray[i];
                }
                break;
            }
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: child3Url");
                }
                if (this.vfChild3Url.length != n2) {
                    this.vfChild3Url = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfChild3Url[i] = stringArray[i];
                }
                break;
            }
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: child4Url");
                }
                if (this.vfChild4Url.length != n2) {
                    this.vfChild4Url = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfChild4Url[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 12: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: rootNode");
                }
                if (vRMLNodeType == null) break;
                this.addRootNode(vRMLNodeType);
                vRMLNodeType.updateRefCount(true);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: rootNode");
                }
                if (!this.inSetup) {
                    this.clearChildren();
                }
                for (int i = 0; i < n2; ++i) {
                    this.addRootNode(vRMLNodeTypeArray[i]);
                    vRMLNodeTypeArray[i].updateRefCount(true);
                }
                break;
            }
        }
        super.setValue(n, vRMLNodeTypeArray, n2);
    }

    protected void clearRootNodes() {
        int n = this.vfRootNode.size();
        if (this.nodeTmp == null || this.nodeTmp.length < n) {
            this.nodeTmp = new VRMLNodeType[n];
        }
        this.vfRootNode.toArray(this.nodeTmp);
        for (int i = 0; i < n; ++i) {
            if (this.nodeTmp[i] instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)this.nodeTmp[i]).setShared(false);
            }
            this.nodeTmp[i].updateRefCount(false);
        }
        if (n > 0) {
            this.stateManager.registerRemovedNodes((VRMLNode[])this.nodeTmp);
        }
        this.vfRootNode.clear();
        this.hasBindables = false;
    }

    private void setCenter(double[] dArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldValueException("You have attempted to write to an initializeOnly field: center");
        }
        this.vfCenter[0] = dArray[0];
        this.vfCenter[1] = dArray[1];
        this.vfCenter[2] = dArray[2];
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    protected void addRootNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        boolean bl;
        boolean bl2 = bl = vRMLNodeType instanceof VRMLBindableNodeType || vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes();
        if (this.shareCount > 1 && bl) {
            throw new InvalidFieldValueException("New node contains bindables when this grouping node is already USEd. Ignoring the request");
        }
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(true);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 instanceof VRMLGroupingNodeType) {
                ((VRMLGroupingNodeType)vRMLNodeType2).setShared(true);
            }
        }
        if (bl) {
            this.hasBindables = true;
        }
        this.vfRootNode.add(vRMLNodeType);
    }

    private void checkURLs() {
        this.vfRootUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfRootUrl, (boolean)false);
        this.vfChild1Url = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfChild1Url, (boolean)false);
        this.vfChild2Url = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfChild2Url, (boolean)false);
        this.vfChild3Url = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfChild3Url, (boolean)false);
        this.vfChild4Url = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfChild4Url, (boolean)false);
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, n);
        }
    }

    protected void fireContentStateChanged(int n) {
        int n2 = this.contentListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, n, this.loadState[n]);
        }
    }

    protected void loadScene(boolean bl) throws IllegalArgumentException {
        if (bl) {
            this.fireUrlChanged(8);
            this.fireUrlChanged(9);
            this.fireUrlChanged(10);
            this.fireUrlChanged(11);
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.loadedScenes[i] == null) continue;
                this.stateManager.registerRemovedScene((VRMLExecutionSpace)this.loadedScenes[i]);
                this.loadedScenes[i] = null;
                this.childScenes[i] = null;
            }
        }
    }

    static {
        nodeFields = new int[]{1, 0, 12, 6};
        fieldDecl = new VRMLFieldDeclaration[16];
        fieldMap = new HashMap(16);
        BaseGeoLOD.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoLOD.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseGeoLOD.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseGeoLOD.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseGeoLOD.fieldDecl[14] = new VRMLFieldDeclaration(2, "SFVec3d", "center");
        BaseGeoLOD.fieldDecl[15] = new VRMLFieldDeclaration(2, "SFFloat", "range");
        BaseGeoLOD.fieldDecl[13] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoLOD.fieldDecl[12] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        BaseGeoLOD.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFString", "rootUrl");
        BaseGeoLOD.fieldDecl[8] = new VRMLFieldDeclaration(2, "MFString", "child1Url");
        BaseGeoLOD.fieldDecl[9] = new VRMLFieldDeclaration(2, "MFString", "child2Url");
        BaseGeoLOD.fieldDecl[10] = new VRMLFieldDeclaration(2, "MFString", "child3Url");
        BaseGeoLOD.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFString", "child4Url");
        BaseGeoLOD.fieldDecl[6] = new VRMLFieldDeclaration(2, "MFNode", "rootNode");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        fieldMap.put("level", n);
        fieldMap.put("set_level", n);
        fieldMap.put("level_changed", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        fieldMap.put("center", new Integer(14));
        fieldMap.put("range", new Integer(15));
        fieldMap.put("geoSystem", new Integer(13));
        fieldMap.put("geoOrigin", new Integer(12));
        fieldMap.put("rootNode", new Integer(6));
        fieldMap.put("rootUrl", new Integer(7));
        fieldMap.put("child1Url", new Integer(8));
        fieldMap.put("child2Url", new Integer(9));
        fieldMap.put("child3Url", new Integer(10));
        fieldMap.put("child4Url", new Integer(11));
        urlFieldIndexList = new int[5];
        BaseGeoLOD.urlFieldIndexList[0] = 7;
        BaseGeoLOD.urlFieldIndexList[1] = 8;
        BaseGeoLOD.urlFieldIndexList[2] = 9;
        BaseGeoLOD.urlFieldIndexList[3] = 10;
        BaseGeoLOD.urlFieldIndexList[4] = 11;
        urlFieldChildrenIndexList = new int[4];
        BaseGeoLOD.urlFieldChildrenIndexList[0] = 8;
        BaseGeoLOD.urlFieldChildrenIndexList[1] = 9;
        BaseGeoLOD.urlFieldChildrenIndexList[2] = 10;
        BaseGeoLOD.urlFieldChildrenIndexList[3] = 11;
        urlFieldRootIndexList = new int[1];
        BaseGeoLOD.urlFieldRootIndexList[0] = 7;
        validX3DTypes = new HashSet();
        validX3DTypes.add((Object)"model/x3d+vrml");
        validX3DTypes.add((Object)"model/x3d+xml");
        validX3DTypes.add((Object)"model/x3d+binary");
    }
}

