/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;

public class BaseGeoLocation
extends BaseGroupingNode {
    protected static final int FIELD_GEO_ORIGIN = 6;
    protected static final int FIELD_GEO_SYSTEM = 7;
    protected static final int FIELD_GEO_COORDS = 8;
    protected static final int LAST_GEOLOCATION_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the geoCoord value for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected String[] vfGeoSystem;
    protected double[] vfGeoCoords;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    protected double[] localCoords;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;

    public BaseGeoLocation() {
        super("GeoLocation");
        this.hasChanged = new boolean[9];
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfGeoCoords = new double[3];
        this.localCoords = new double[3];
    }

    public BaseGeoLocation(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("geoCoords");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGeoCoords[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfGeoCoords[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfGeoCoords[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            if (this.geoCoordSwap) {
                double d = this.vfGeoCoords[0];
                this.vfGeoCoords[0] = this.vfGeoCoords[1];
                this.vfGeoCoords[1] = d;
                this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                d = this.vfGeoCoords[0];
                this.vfGeoCoords[0] = this.vfGeoCoords[1];
                this.vfGeoCoords[1] = d;
            } else {
                this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
            }
            if (this.vfGeoOrigin != null) {
                double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localCoords[0] = this.localCoords[0] - dArray[0];
                this.localCoords[1] = this.localCoords[1] - dArray[1];
                this.localCoords[2] = this.localCoords[2] - dArray[2];
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 8 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 22;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.fieldData.clear();
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)12;
                this.fieldData.doubleArrayValue = this.vfGeoCoords;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfGeoCoords, this.vfGeoCoords.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseGeoLocation.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid fieldValue: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setGeoCoords(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 6: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    protected void setGeoCoords(double[] dArray) {
        this.vfGeoCoords[0] = dArray[0];
        this.vfGeoCoords[1] = dArray[1];
        this.vfGeoCoords[2] = dArray[2];
        if (this.inSetup) {
            return;
        }
        if (this.geoTransform != null) {
            try {
                if (this.geoCoordSwap) {
                    double d = this.vfGeoCoords[0];
                    this.vfGeoCoords[0] = this.vfGeoCoords[1];
                    this.vfGeoCoords[1] = d;
                    this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                    d = this.vfGeoCoords[0];
                    this.vfGeoCoords[0] = this.vfGeoCoords[1];
                    this.vfGeoCoords[1] = d;
                } else {
                    this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                }
                if (this.vfGeoOrigin != null) {
                    double[] dArray2 = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                    this.localCoords[0] = this.localCoords[0] - dArray2[0];
                    this.localCoords[1] = this.localCoords[1] - dArray2[1];
                    this.localCoords[2] = this.localCoords[2] - dArray2[2];
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
        this.hasChanged[8] = true;
        this.fireFieldChanged(8);
    }

    static {
        nodeFields = new int[]{1, 0, 6};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(9);
        BaseGeoLocation.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoLocation.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseGeoLocation.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseGeoLocation.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseGeoLocation.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseGeoLocation.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseGeoLocation.fieldDecl[7] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoLocation.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        BaseGeoLocation.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3d", "geoCoords");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(8);
        fieldMap.put("geoCoords", n);
        fieldMap.put("set_geoCoords", n);
        fieldMap.put("geoCoords_changed", n);
        fieldMap.put("geoSystem", new Integer(7));
        fieldMap.put("geoOrigin", new Integer(6));
    }
}

