/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseGeoMetadata
extends AbstractNode
implements VRMLChildNodeType {
    protected static final int FIELD_DATA = 1;
    protected static final int FIELD_SUMMARY = 2;
    protected static final int FIELD_URL = 3;
    protected static final int LAST_GEOMETADATA_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected ArrayList vfData;
    protected String[] vfSummary;
    protected String[] vfUrl;

    public BaseGeoMetadata() {
        super("GeoMetadata");
        this.hasChanged = new boolean[4];
        this.vfData = new ArrayList();
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfSummary = FieldConstants.EMPTY_MFSTRING;
    }

    public BaseGeoMetadata(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("summary");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSummary = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfSummary, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfData.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfData.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 3 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfSummary;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfSummary.length;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfUrl.length;
                break;
            }
            case 1: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfData.size()];
                this.vfData.toArray(vRMLNodeTypeArray);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = vRMLNodeTypeArray;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfData.size()];
                    this.vfData.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfSummary, this.vfSummary.length);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.vfSummary = stringArray;
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            case 3: {
                this.vfUrl = stringArray;
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfData.clear();
                }
                this.vfData.add(vRMLNodeType);
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfData.clear();
                }
                for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                    this.vfData.add(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BaseGeoMetadata.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoMetadata.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "data");
        BaseGeoMetadata.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFString", "summary");
        BaseGeoMetadata.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFString", "url");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("data", n);
        fieldMap.put("set_data", n);
        fieldMap.put("data_changed", n);
        n = new Integer(2);
        fieldMap.put("summary", n);
        fieldMap.put("set_summary", n);
        fieldMap.put("summary_changed", n);
        n = new Integer(3);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
    }
}

