/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLocalOriginNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseGeoOrigin
extends AbstractNode
implements VRMLLocalOriginNodeType {
    protected static final int FIELD_GEO_ORIGIN = 1;
    protected static final int FIELD_GEO_SYSTEM = 2;
    protected static final int FIELD_GEO_COORDS = 3;
    protected static final int FIELD_ROTATE_Y_UP = 4;
    protected static final int LAST_GEOORIGIN_INDEX = 4;
    private static final int NUM_FIELDS = 5;
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the geoCoord value for some reason.";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected boolean vfRotateYUp;
    protected double[] vfGeoCoords;
    protected String[] vfGeoSystem;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;
    protected double[] localCoords;

    public BaseGeoOrigin() {
        super("GeoOrigin");
        this.hasChanged = new boolean[5];
        this.vfGeoCoords = new double[3];
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfRotateYUp = false;
        this.localCoords = new double[3];
    }

    public BaseGeoOrigin(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("rotateYUp");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRotateYUp = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("geoCoords");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGeoCoords[0] = vRMLFieldData.doubleArrayValue[0];
            this.vfGeoCoords[1] = vRMLFieldData.doubleArrayValue[1];
            this.vfGeoCoords[2] = vRMLFieldData.doubleArrayValue[2];
            n = vRMLNodeType.getFieldIndex("geoSystem");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfGeoSystem = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfGeoSystem, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            this.geoTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            if (this.geoCoordSwap) {
                double d = this.vfGeoCoords[0];
                this.vfGeoCoords[0] = this.vfGeoCoords[1];
                this.vfGeoCoords[1] = d;
                this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                d = this.vfGeoCoords[0];
                this.vfGeoCoords[0] = this.vfGeoCoords[1];
                this.vfGeoCoords[1] = d;
            } else {
                this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return n < 0 || n > 4 ? null : fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfRotateYUp;
                this.fieldData.dataType = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfGeoCoords;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfGeoCoords.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfGeoCoords, this.vfGeoCoords.length);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfGeoSystem, this.vfGeoSystem.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfRotateYUp);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("rotateYUp is an initializeOnly field");
                }
                this.vfRotateYUp = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setGeoCoords(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    protected void setGeoCoords(double[] dArray) {
        this.vfGeoCoords[0] = dArray[0];
        this.vfGeoCoords[1] = dArray[1];
        this.vfGeoCoords[2] = dArray[2];
        if (this.inSetup) {
            return;
        }
        if (this.geoTransform != null) {
            try {
                if (this.geoCoordSwap) {
                    double d = this.vfGeoCoords[0];
                    this.vfGeoCoords[0] = this.vfGeoCoords[1];
                    this.vfGeoCoords[1] = d;
                    this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                    d = this.vfGeoCoords[0];
                    this.vfGeoCoords[0] = this.vfGeoCoords[1];
                    this.vfGeoCoords[1] = d;
                } else {
                    this.geoTransform.transform(this.vfGeoCoords, 0, this.localCoords, 0, 1);
                }
            }
            catch (TransformException transformException) {
                this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
            }
        }
        this.hasChanged[3] = true;
        this.fireFieldChanged(3);
    }

    public double[] getConvertedCoordRef() {
        return this.localCoords;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseGeoOrigin.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoOrigin.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFVec3d", "geoCoords");
        BaseGeoOrigin.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFString", "geoSystem");
        BaseGeoOrigin.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFBool", "rotateYUp");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("geoCoords", n);
        fieldMap.put("set_geoCoords", n);
        fieldMap.put("geoCoords_changed", n);
        fieldMap.put("rotateYUp", new Integer(4));
        n = new Integer(2);
        fieldMap.put("geoSystem", n);
        fieldMap.put("set_geoSystem", n);
        fieldMap.put("geoSystem_changed", n);
    }
}

