/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.geospatial;

import java.util.HashMap;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTouchSensorNodeType;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;

public class BaseGeoTouchSensor
extends BaseSensorNode
implements VRMLTouchSensorNodeType {
    protected static final int FIELD_HITNORMAL_CHANGED = 3;
    protected static final int FIELD_HITPOINT_CHANGED = 4;
    protected static final int FIELD_HITTEXCOORD_CHANGED = 5;
    protected static final int FIELD_HITGEOCOORD_CHANGED = 6;
    protected static final int FIELD_IS_OVER = 7;
    protected static final int FIELD_TOUCH_TIME = 8;
    protected static final int FIELD_DESCRIPTION = 9;
    protected static final int FIELD_GEO_ORIGIN = 10;
    protected static final int FIELD_GEO_SYSTEM = 11;
    protected static final int LAST_TOUCHSENSOR_INDEX = 11;
    protected static final int NUM_FIELDS = 12;
    private static final String GEO_ORIGIN_PROTO_MSG = "Proto does not describe a GeoOrigin object";
    private static final String GEO_ORIGIN_NODE_MSG = "Node does not describe a GeoOrigin object";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the coordinate values for some reason.";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfHitNormalChanged;
    protected float[] vfHitPointChanged;
    protected float[] vfHitTexCoordChanged;
    protected double[] vfHitGeoCoordChanged;
    protected boolean vfIsOver;
    protected double vfTouchTime;
    protected String vfDescription;
    protected String[] vfGeoSystem;
    protected VRMLProtoInstance pGeoOrigin;
    protected VRMLNodeType vfGeoOrigin;
    private double[] localCoords;
    private MathTransform geoTransform;
    private boolean geoCoordSwap;

    public BaseGeoTouchSensor() {
        super("GeoTouchSensor");
        this.hasChanged = new boolean[12];
        this.vfGeoSystem = new String[]{"GD", "WE"};
        this.vfHitNormalChanged = new float[3];
        this.vfHitPointChanged = new float[3];
        this.vfHitTexCoordChanged = new float[2];
        this.vfHitGeoCoordChanged = new double[3];
        this.localCoords = new double[3];
    }

    public BaseGeoTouchSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
    }

    public boolean requiresPointOnly() {
        return false;
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public void setIsOver(boolean bl) {
        this.vfIsOver = bl;
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
    }

    public boolean getIsOver() {
        return this.vfIsOver;
    }

    public void notifyPressed(int n, double d, float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = true;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public void notifyReleased(int n, double d, float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = false;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
        if (this.vfIsOver) {
            this.vfTouchTime = d;
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public void notifyHitChanged(float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfHitPointChanged[0] = fArray[0];
        this.vfHitPointChanged[1] = fArray[1];
        this.vfHitPointChanged[2] = fArray[2];
        this.vfHitNormalChanged[0] = fArray2[0];
        this.vfHitNormalChanged[1] = fArray2[1];
        this.vfHitNormalChanged[2] = fArray2[2];
        this.vfHitTexCoordChanged[0] = fArray3[0];
        this.vfHitTexCoordChanged[1] = fArray3[1];
        try {
            this.localCoords[0] = fArray[0];
            this.localCoords[1] = fArray[1];
            this.localCoords[2] = fArray[2];
            if (this.vfGeoOrigin != null) {
                double[] dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localCoords[0] = this.localCoords[0] + dArray[0];
                this.localCoords[1] = this.localCoords[1] + dArray[1];
                this.localCoords[2] = this.localCoords[2] + dArray[2];
            }
            this.geoTransform.transform(this.localCoords, 0, this.vfHitGeoCoordChanged, 0, 1);
            if (this.geoCoordSwap) {
                double d = this.vfHitGeoCoordChanged[0];
                this.vfHitGeoCoordChanged[0] = this.vfHitGeoCoordChanged[1];
                this.vfHitGeoCoordChanged[1] = d;
            }
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
        this.hasChanged[3] = true;
        this.fireFieldChanged(3);
        this.hasChanged[5] = true;
        this.fireFieldChanged(5);
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pGeoOrigin != null) {
            this.pGeoOrigin.setupFinished();
        } else if (this.vfGeoOrigin != null) {
            this.vfGeoOrigin.setupFinished();
        }
        try {
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            boolean[] blArray = new boolean[1];
            MathTransform mathTransform = gTTransformUtils.createSystemTransform(this.vfGeoSystem, blArray);
            this.geoCoordSwap = blArray[0];
            this.geoTransform = mathTransform.inverse();
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport(TRANSFORM_ERR_MSG, (Exception)((Object)transformException));
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 36;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfHitNormalChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfHitPointChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfHitTexCoordChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfHitGeoCoordChanged;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfGeoSystem;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfGeoSystem.length;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfIsOver;
                this.fieldData.dataType = 1;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfTouchTime;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfHitNormalChanged, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfHitPointChanged, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfHitGeoCoordChanged, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfHitTexCoordChanged, 2);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfIsOver);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfTouchTime);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTouchSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseTouchSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 9: {
                this.setDescription(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoSystem");
                }
                if (this.vfGeoSystem.length != n2) {
                    this.vfGeoSystem = new String[n2];
                }
                for (int i = 0; i < n2; ++i) {
                    this.vfGeoSystem[i] = stringArray[i];
                }
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 10: {
                this.setGeoOrigin(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setGeoOrigin(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        BaseGeoOrigin baseGeoOrigin;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field: geoOrigin");
        }
        Object object = this.pGeoOrigin != null ? this.pGeoOrigin : this.vfGeoOrigin;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_PROTO_MSG);
            }
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType2;
            this.pGeoOrigin = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseGeoOrigin)) {
                throw new InvalidFieldValueException(GEO_ORIGIN_NODE_MSG);
            }
            this.pGeoOrigin = null;
            baseGeoOrigin = (BaseGeoOrigin)vRMLNodeType;
        }
        this.vfGeoOrigin = baseGeoOrigin;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    static {
        nodeFields = new int[]{0, 10};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseGeoTouchSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGeoTouchSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseGeoTouchSensor.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFString", "description");
        BaseGeoTouchSensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFVec3f", "hitNormal_changed");
        BaseGeoTouchSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "hitPoint_changed");
        BaseGeoTouchSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec2f", "hitTexCoord_changed");
        BaseGeoTouchSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFVec3d", "hitGeoCoord_changed");
        BaseGeoTouchSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseGeoTouchSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BaseGeoTouchSensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFTime", "touchTime");
        BaseGeoTouchSensor.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFString", "geoSystem");
        BaseGeoTouchSensor.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFNode", "geoOrigin");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(9);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("hitNormal_changed", new Integer(3));
        fieldMap.put("hitPoint_changed", new Integer(4));
        fieldMap.put("hitTexCoord_changed", new Integer(5));
        fieldMap.put("hitGeoCoord_changed", new Integer(6));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("isOver", new Integer(7));
        fieldMap.put("touchTime", new Integer(8));
        fieldMap.put("geoSystem", new Integer(11));
        fieldMap.put("geoOrigin", new Integer(10));
    }
}

