/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.group;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLBoundedNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseStaticGroup
extends AbstractNode
implements VRMLBoundedNodeType {
    private static final String DISPOSE_STATE_PROP = "org.web3d.vrml.nodes.staticgroup.dispose";
    private static final String COMPACT_STATE_PROP = "org.web3d.vrml.nodes.staticgroup.compact";
    private static final boolean DEFAULT_DISPOSE_STATE = false;
    private static final boolean DEFAULT_COMPACT_STATE = false;
    protected static final int FIELD_CHILDREN = 1;
    protected static final int FIELD_BBOX_CENTER = 2;
    protected static final int FIELD_BBOX_SIZE = 3;
    protected static final int LAST_STATICGROUP_INDEX = 3;
    protected static final int NUM_FIELDS = 4;
    private static final String NO_CHANGE_MSG = "You cannot add or remove nodes from a StaticGroup at runtime";
    private static final String USE_BIND_MSG = "New node contains bindables when this grouping node is already USEd. Ignoring the request";
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected static final boolean disposeChildren;
    protected static final boolean compactChildren;
    protected ArrayList vfChildren;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
    protected int shareCount;

    protected BaseStaticGroup() {
        super("StaticGroup");
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfChildren = new ArrayList();
        this.hasChanged = new boolean[4];
    }

    protected BaseStaticGroup(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        VRMLBoundedNodeType vRMLBoundedNodeType = (VRMLBoundedNodeType)vRMLNodeType;
        float[] fArray = vRMLBoundedNodeType.getBboxCenter();
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
        fArray = vRMLBoundedNodeType.getBboxSize();
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public void setupFinished() {
        super.setupFinished();
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfChildren.get(i);
            vRMLNodeType.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfChildren.size()];
                this.vfChildren.toArray(vRMLNodeTypeArray);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = vRMLNodeTypeArray;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxSize;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public int getPrimaryType() {
        return 59;
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldFormatException, InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 2: {
                this.setBboxCenter(fArray);
                break;
            }
            case 3: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException(NO_CHANGE_MSG);
                }
                this.addChildNode(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException(NO_CHANGE_MSG);
                }
                for (int i = 0; i < n2; ++i) {
                    this.addChildNode(vRMLNodeTypeArray[i]);
                }
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    private void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Cannot set bboxCenter after initialization");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) throws InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Cannot set bboxSize after initialization");
        }
        FieldValidator.checkBBoxSize((String)this.getVRMLNodeName(), (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        boolean bl;
        boolean bl2 = bl = vRMLNodeType instanceof VRMLBindableNodeType || vRMLNodeType instanceof VRMLGroupingNodeType && ((VRMLGroupingNodeType)vRMLNodeType).containsBindableNodes();
        if (bl) {
            throw new InvalidFieldValueException(USE_BIND_MSG);
        }
        if (vRMLNodeType instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType).setShared(true);
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLGroupingNodeType) {
            ((VRMLGroupingNodeType)vRMLNodeType2).setShared(true);
        }
        this.vfChildren.add(vRMLNodeType);
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(4);
        BaseStaticGroup.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseStaticGroup.fieldDecl[1] = new VRMLFieldDeclaration(2, "MFNode", "children");
        BaseStaticGroup.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseStaticGroup.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("children", new Integer(1));
        fieldMap.put("bboxCenter", new Integer(2));
        fieldMap.put("bboxSize", new Integer(3));
        boolean[] blArray = (boolean[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new boolean[]{Boolean.getBoolean(BaseStaticGroup.DISPOSE_STATE_PROP), Boolean.getBoolean(BaseStaticGroup.COMPACT_STATE_PROP)};
            }
        });
        disposeChildren = blArray[0];
        compactChildren = blArray[1];
    }
}

