/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.interpolator;

import java.util.HashMap;
import org.j3d.util.interpolator.Coordinate2DInterpolator;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseInterpolatorNode;

public abstract class BaseCoordinateInterpolator2D
extends BaseInterpolatorNode {
    private static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfKeyValue;
    private int numKeyValue;
    private float[] vfValue;
    private Coordinate2DInterpolator interpolator;
    private float[] coordKeySetup;
    private int coordValuesPerKey;

    protected BaseCoordinateInterpolator2D() {
        super("CoordinateInterpolator2D");
        this.hasChanged = new boolean[5];
        this.numKeyValue = 0;
        this.coordValuesPerKey = 0;
        this.vfKeyValue = FieldConstants.EMPTY_MFVEC2F;
    }

    protected BaseCoordinateInterpolator2D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLInterpolatorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("keyValue");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKeyValue = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfKeyValue, 0, vRMLFieldData.numElements * 2);
                this.numKeyValue = vRMLFieldData.numElements * 2;
                this.coordValuesPerKey = this.numKeyValue / this.vfKey.length;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setFraction(float f) {
        this.vfFraction = f;
        if (this.vfKey != null && this.vfKey.length > 0 && this.interpolator != null && this.vfKeyValue.length > 0) {
            float[] fArray = this.interpolator.floatValue(this.vfFraction);
            this.setValue(fArray, fArray.length);
        }
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setKey(float[] fArray, int n) {
        super.setKey(fArray, n);
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.rebuildInterpolator();
        this.inSetup = true;
        this.setFraction(this.vfFraction);
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfKeyValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.coordValuesPerKey == 0 ? 0 : this.numKeyValue / this.coordValuesPerKey;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.coordValuesPerKey / 3;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfKeyValue, this.numKeyValue);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfValue, this.coordValuesPerKey);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 3) {
            super.setValue(n, f);
            return;
        }
        this.setFraction(f);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 2) {
            super.setValue(n, fArray, n2);
            return;
        }
        this.setKeyValue(fArray, n2);
    }

    private void setKeyValue(float[] fArray, int n) {
        if (n == 0) {
            this.numKeyValue = 0;
        } else {
            if (n > this.vfKeyValue.length) {
                this.vfKeyValue = new float[n];
            }
            this.numKeyValue = n;
            this.coordValuesPerKey = this.numKeyValue / this.numKey;
            System.arraycopy(fArray, 0, this.vfKeyValue, 0, this.numKeyValue);
        }
        if (!this.inSetup) {
            this.rebuildInterpolator();
            this.setFraction(this.vfFraction);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setValue(float[] fArray, int n) {
        if (n == 0) {
            return;
        }
        if (this.vfValue == null || n > this.vfValue.length) {
            this.vfValue = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfValue, 0, this.coordValuesPerKey);
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void rebuildInterpolator() {
        if (this.numKey == 0 || this.numKeyValue == 0) {
            this.interpolator = null;
            return;
        }
        int n = this.numKey < this.numKeyValue / 2 ? this.numKey : this.numKeyValue / 2;
        this.interpolator = new Coordinate2DInterpolator(n);
        int n2 = 0;
        if (this.coordKeySetup == null || this.coordKeySetup.length != this.coordValuesPerKey) {
            this.coordKeySetup = new float[this.coordValuesPerKey];
        }
        for (int i = 0; i < n; ++i) {
            System.arraycopy(this.vfKeyValue, n2, this.coordKeySetup, 0, this.coordValuesPerKey);
            this.interpolator.addKeyFrame(this.vfKey[i], this.coordKeySetup);
            n2 += this.coordValuesPerKey;
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseCoordinateInterpolator2D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCoordinateInterpolator2D.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFFloat", "set_fraction");
        BaseCoordinateInterpolator2D.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFFloat", "key");
        BaseCoordinateInterpolator2D.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFVec2f", "keyValue");
        BaseCoordinateInterpolator2D.fieldDecl[4] = new VRMLFieldDeclaration(4, "MFVec2f", "value_changed");
        fieldMap.put("set_fraction", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("key", n);
        fieldMap.put("set_key", n);
        fieldMap.put("key_changed", n);
        n = new Integer(2);
        fieldMap.put("keyValue", n);
        fieldMap.put("set_keyValue", n);
        fieldMap.put("keyValue_changed", n);
        fieldMap.put("value_changed", new Integer(4));
    }
}

