/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.lighting;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseLightNode;

public abstract class BasePointLight
extends BaseLightNode {
    protected static final int FIELD_ATTENUATION = 5;
    protected static final int FIELD_LOCATION = 6;
    protected static final int FIELD_RADIUS = 7;
    public static final int LAST_POINTLIGHT_INDEX = 7;
    private static final int NUM_FIELDS = 8;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfAttenuation;
    protected float[] vfLocation;
    protected float vfRadius = 100.0f;
    private float[] flScratch = new float[3];

    protected BasePointLight() {
        super("PointLight");
        this.vfAttenuation = new float[]{1.0f, 0.0f, 0.0f};
        this.vfLocation = new float[]{0.0f, 0.0f, 0.0f};
        this.hasChanged = new boolean[8];
    }

    protected BasePointLight(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLLightNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("location");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfLocation[0] = vRMLFieldData.floatArrayValue[0];
                this.vfLocation[1] = vRMLFieldData.floatArrayValue[1];
                this.vfLocation[2] = vRMLFieldData.floatArrayValue[2];
            }
            n = vRMLNodeType.getFieldIndex("radius");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRadius = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("attenuation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfAttenuation[0] = vRMLFieldData.floatArrayValue[0];
                this.vfAttenuation[1] = vRMLFieldData.floatArrayValue[1];
                this.vfAttenuation[2] = vRMLFieldData.floatArrayValue[2];
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAttenuation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfLocation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRadius;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfLocation, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfRadius);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfAttenuation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("PointLight sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("PointLight sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setRadius(f);
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setAttenuation(fArray);
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            case 6: {
                this.setLocation(fArray);
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setLocation(float[] fArray) {
        this.vfLocation[0] = fArray[0];
        this.vfLocation[1] = fArray[1];
        this.vfLocation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setRadius(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("Radius must be [0,inf)");
        }
        this.vfRadius = f;
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void setAttenuation(float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[1] < 0.0f || fArray[2] < 0.0f || fArray[0] > 1.0f || fArray[1] > 1.0f || fArray[2] > 1.0f) {
            throw new InvalidFieldValueException("attenuation value out of range [0,1]");
        }
        this.vfAttenuation[0] = fArray[0];
        this.vfAttenuation[1] = fArray[1];
        this.vfAttenuation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        BasePointLight.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePointLight.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        BasePointLight.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BasePointLight.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        BasePointLight.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "on");
        BasePointLight.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "location");
        BasePointLight.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "radius");
        BasePointLight.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "attenuation");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(5);
        fieldMap.put("attenuation", n);
        fieldMap.put("set_attenuation", n);
        fieldMap.put("attenuation_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(7);
        fieldMap.put("radius", n);
        fieldMap.put("set_radius", n);
        fieldMap.put("radius_changed", n);
        n = new Integer(3);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(4);
        fieldMap.put("on", n);
        fieldMap.put("set_on", n);
        fieldMap.put("on_changed", n);
        n = new Integer(6);
        fieldMap.put("location", n);
        fieldMap.put("set_location", n);
        fieldMap.put("location_changed", n);
    }
}

