/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.lighting;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLLightNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseLightNode;

public abstract class BaseSpotLight
extends BaseLightNode {
    protected static final int FIELD_ATTENUATION = 5;
    protected static final int FIELD_BEAMWIDTH = 6;
    protected static final int FIELD_CUTOFFANGLE = 7;
    protected static final int FIELD_DIRECTION = 8;
    protected static final int FIELD_LOCATION = 9;
    protected static final int FIELD_RADIUS = 10;
    public static final int LAST_SPOTLIGHT_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfAttenuation = new float[]{1.0f, 0.0f, 0.0f};
    protected float vfBeamWidth = 1.570796f;
    protected float vfCutOffAngle = 0.785398f;
    protected float[] vfDirection = new float[]{0.0f, 0.0f, -1.0f};
    protected float[] vfLocation = new float[]{0.0f, 0.0f, 0.0f};
    protected float vfRadius = 100.0f;

    protected BaseSpotLight() {
        super("SpotLight");
        this.hasChanged = new boolean[11];
    }

    protected BaseSpotLight(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLLightNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("attenuation");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfAttenuation[0] = vRMLFieldData.floatArrayValue[0];
                this.vfAttenuation[1] = vRMLFieldData.floatArrayValue[1];
                this.vfAttenuation[2] = vRMLFieldData.floatArrayValue[2];
            }
            n = vRMLNodeType.getFieldIndex("radius");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfRadius = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("beamWidth");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBeamWidth = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("cuttOffAngle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCutOffAngle = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAttenuation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfBeamWidth;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfCutOffAngle;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfDirection;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfLocation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfRadius;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfDirection, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfLocation, 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfRadius);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfAttenuation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("DirLight sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("DirLight sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setBeamWidth(f);
                break;
            }
            case 7: {
                this.setCutOffAngle(f);
            }
            case 10: {
                this.setRadius(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setDirection(fArray);
                break;
            }
            case 9: {
                this.setLocation(fArray);
                break;
            }
            case 5: {
                this.setAttenuation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setDirection(float[] fArray) {
        this.vfDirection[0] = fArray[0];
        this.vfDirection[1] = fArray[1];
        this.vfDirection[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    protected void setLocation(float[] fArray) {
        this.vfLocation[0] = fArray[0];
        this.vfLocation[1] = fArray[1];
        this.vfLocation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    protected void setRadius(float f) throws InvalidFieldValueException {
        if (f <= 0.0f) {
            throw new InvalidFieldValueException("Radius is not (0, PI/2) range: " + f);
        }
        this.vfRadius = f;
        if (!this.inSetup) {
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    protected void setAttenuation(float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[1] < 0.0f || fArray[2] < 0.0f || fArray[0] > 1.0f || fArray[1] > 1.0f || fArray[2] > 1.0f) {
            throw new InvalidFieldValueException("attenuation value out of range [0,1]");
        }
        this.vfAttenuation[0] = fArray[0];
        this.vfAttenuation[1] = fArray[1];
        this.vfAttenuation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    protected void setBeamWidth(float f) throws InvalidFieldValueException {
        if (f <= 0.0f || (double)f > 1.5707963267948966) {
            throw new InvalidFieldValueException("beamWidth size out of range: " + f);
        }
        this.vfBeamWidth = f;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setCutOffAngle(float f) throws InvalidFieldValueException {
        if (f <= 0.0f || (double)f > 1.5707963267948966) {
            throw new InvalidFieldValueException("cutOffAngle size out of range: " + f);
        }
        this.vfCutOffAngle = f;
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseSpotLight.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSpotLight.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        BaseSpotLight.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BaseSpotLight.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        BaseSpotLight.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "on");
        BaseSpotLight.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "attenuation");
        BaseSpotLight.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "beamWidth");
        BaseSpotLight.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "cutOffAngle");
        BaseSpotLight.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        BaseSpotLight.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFVec3f", "location");
        BaseSpotLight.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "radius");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(5);
        fieldMap.put("attenuation", n);
        fieldMap.put("set_attenuation", n);
        fieldMap.put("attenuation_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(10);
        fieldMap.put("radius", n);
        fieldMap.put("set_radius", n);
        fieldMap.put("radius_changed", n);
        n = new Integer(3);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(4);
        fieldMap.put("on", n);
        fieldMap.put("set_on", n);
        fieldMap.put("on_changed", n);
        n = new Integer(9);
        fieldMap.put("location", n);
        fieldMap.put("set_location", n);
        fieldMap.put("location_changed", n);
        n = new Integer(8);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(7);
        fieldMap.put("cutOffAngle", n);
        fieldMap.put("set_cutOffAngle", n);
        fieldMap.put("cutOffAngle_changed", n);
        n = new Integer(6);
        fieldMap.put("beamWidth", n);
        fieldMap.put("set_beamWidth", n);
        fieldMap.put("beamWidth_changed", n);
    }
}

