/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.navigation;

import java.util.HashMap;
import javax.vecmath.Vector3f;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.NavigationInfoChangeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;

public abstract class BaseNavigationInfo
extends BaseBindableNode
implements VRMLNavigationInfoNodeType {
    protected static final int FIELD_AVATAR_SIZE = 4;
    protected static final int FIELD_HEADLIGHT = 5;
    protected static final int FIELD_SPEED = 6;
    protected static final int FIELD_TYPE = 7;
    protected static final int FIELD_VISIBILITY_LIMIT = 8;
    protected static final int FIELD_TRANSITION_TYPE = 9;
    protected static final int FIELD_TRANSITION_TIME = 10;
    protected static final int LAST_NAVINFO_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    private static final String NEG_SPEED_MSG = "New NavInfo speed value provided is negative. Must be [0,oo): ";
    private static final String NEG_VIS_LIMIT_MSG = "New NavInfo visibilityLimit value provided is negative. Must be [0,oo): ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfAvatarSize;
    protected float[] vfTransitionTime;
    protected int numAvatarSize;
    protected boolean vfHeadlight;
    protected float vfSpeed;
    protected String[] vfType;
    protected String[] vfTransitionType;
    protected int numType;
    protected int numTransitionType;
    protected float vfVisibilityLimit;
    protected NavigationInfoChangeListener changeListener;

    protected BaseNavigationInfo() {
        super("NavigationInfo");
        this.hasChanged = new boolean[11];
        this.numAvatarSize = 3;
        this.numType = 2;
        this.vfAvatarSize = new float[]{0.25f, 1.6f, 0.75f};
        this.vfTransitionTime = new float[]{1.0f};
        this.vfHeadlight = true;
        this.vfSpeed = 1.0f;
        this.vfType = this.vrmlMajorVersion < 3 ? new String[]{"WALK", "ANY"} : new String[]{"EXAMINE", "ANY"};
        this.vfTransitionType = new String[]{"LINEAR"};
        this.vfVisibilityLimit = 0.0f;
    }

    protected BaseNavigationInfo(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("avatarSize");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfAvatarSize = new float[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfAvatarSize, 0, vRMLFieldData.numElements);
                this.numAvatarSize = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("headlight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHeadlight = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("speed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("type");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfType = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfType, 0, vRMLFieldData.numElements);
                this.numType = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("transitionType");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfTransitionType = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfTransitionType, 0, vRMLFieldData.numElements);
                this.numTransitionType = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("visibilityLimit");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVisibilityLimit = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String[] getType() {
        return this.vfType;
    }

    public int getNumTypes() {
        return this.numType;
    }

    public void setNavigationChangedListener(NavigationInfoChangeListener navigationInfoChangeListener) {
        this.changeListener = navigationInfoChangeListener;
    }

    public void setWorldLocation(Vector3f vector3f) {
    }

    public void setType(String[] stringArray, int n) throws InvalidFieldValueException {
        if (n == 0) {
            this.vfType[0] = "NONE";
            this.numType = 1;
        } else {
            if (this.vfType.length < n) {
                this.vfType = new String[n];
            }
            this.numType = n;
            System.arraycopy(stringArray, 0, this.vfType, 0, this.numType);
        }
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
            if (this.changeListener != null) {
                this.changeListener.notifyNavigationModesChanged(this.vfType, this.numType);
            }
        }
    }

    public void setTransitionType(String[] stringArray, int n) throws InvalidFieldValueException {
        if (n == 0) {
            this.vfTransitionType[0] = "LINEAR";
            this.numTransitionType = 1;
        } else {
            if (this.vfTransitionType.length < n) {
                this.vfTransitionType = new String[n];
            }
            this.numType = n;
            System.arraycopy(stringArray, 0, this.vfTransitionType, 0, this.numTransitionType);
        }
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public float[] getAvatarSize() {
        return this.vfAvatarSize;
    }

    public void setAvatarSize(float[] fArray, int n) throws InvalidFieldValueException {
        if (this.vfAvatarSize.length < n) {
            this.vfAvatarSize = new float[n];
        }
        this.numAvatarSize = n;
        System.arraycopy(fArray, 0, this.vfAvatarSize, 0, n);
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
            if (this.changeListener != null) {
                this.changeListener.notifyAvatarSizeChanged(this.vfAvatarSize, this.numAvatarSize);
            }
        }
    }

    public float getSpeed() {
        return this.vfSpeed;
    }

    public void setSpeed(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_SPEED_MSG + f);
        }
        if (f != this.vfSpeed) {
            this.vfSpeed = f;
            if (!this.inSetup) {
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                if (this.changeListener != null) {
                    this.changeListener.notifyNavigationSpeedChanged(this.vfSpeed);
                }
            }
        }
    }

    public float getVisibilityLimit() {
        return this.vfVisibilityLimit;
    }

    public void setVisibilityLimit(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_VIS_LIMIT_MSG + f);
        }
        if (f != this.vfVisibilityLimit) {
            this.vfVisibilityLimit = f;
            if (!this.inSetup) {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
            }
        }
    }

    public boolean getHeadlight() {
        return this.vfHeadlight;
    }

    public void setHeadlight(boolean bl) {
        if (bl != this.vfHeadlight) {
            this.vfHeadlight = bl;
            if (!this.inSetup) {
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
            }
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 31;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAvatarSize;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numAvatarSize;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfTransitionTime;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.vfTransitionTime.length;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfHeadlight;
                this.fieldData.dataType = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfType;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.numType;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfTransitionType;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.numTransitionType;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfVisibilityLimit;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAvatarSize, this.numAvatarSize);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfTransitionTime, this.vfTransitionTime.length);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfHeadlight);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfSpeed);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfType, this.numType);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfTransitionType, this.numTransitionType);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfVisibilityLimit);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setHeadlight(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setSpeed(f);
                break;
            }
            case 8: {
                this.setVisibilityLimit(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setAvatarSize(fArray, n2);
                break;
            }
            case 10: {
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setType(stringArray, n2);
                break;
            }
            case 9: {
                this.setTransitionType(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseNavigationInfo.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseNavigationInfo.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFFloat", "avatarSize");
        BaseNavigationInfo.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "headlight");
        BaseNavigationInfo.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "speed");
        BaseNavigationInfo.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFString", "type");
        BaseNavigationInfo.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "visibilityLimit");
        BaseNavigationInfo.fieldDecl[9] = new VRMLFieldDeclaration(3, "MFString", "transitionType");
        BaseNavigationInfo.fieldDecl[10] = new VRMLFieldDeclaration(3, "MFFloat", "transitionTime");
        BaseNavigationInfo.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseNavigationInfo.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseNavigationInfo.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("avatarSize", n);
        fieldMap.put("set_avatarSize", n);
        fieldMap.put("avatarSize_changed", n);
        fieldMap.put("set_bind", new Integer(1));
        fieldMap.put("isBound", new Integer(3));
        fieldMap.put("bindTime", new Integer(2));
        n = new Integer(5);
        fieldMap.put("headlight", n);
        fieldMap.put("set_headlight", n);
        fieldMap.put("headlight_changed", n);
        n = new Integer(9);
        fieldMap.put("transitionType", n);
        fieldMap.put("set_transitionType", n);
        fieldMap.put("transitionType_changed", n);
        n = new Integer(10);
        fieldMap.put("transitionTime", n);
        fieldMap.put("set_transitionTime", n);
        fieldMap.put("transitionTime_changed", n);
        n = new Integer(6);
        fieldMap.put("speed", n);
        fieldMap.put("set_speed", n);
        fieldMap.put("speed_changed", n);
        n = new Integer(7);
        fieldMap.put("type", n);
        fieldMap.put("set_type", n);
        fieldMap.put("type_changed", n);
        n = new Integer(8);
        fieldMap.put("visibilityLimit", n);
        fieldMap.put("set_visibilityLimit", n);
        fieldMap.put("visibilityLimit_changed", n);
    }
}

