/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.navigation;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseBindableNode;

public abstract class BaseViewpoint
extends BaseBindableNode
implements VRMLViewpointNodeType {
    protected static final int FIELD_FIELDOFVIEW = 4;
    protected static final int FIELD_JUMP = 5;
    protected static final int FIELD_ORIENTATION = 6;
    protected static final int FIELD_POSITION = 7;
    protected static final int FIELD_DESCRIPTION = 8;
    protected static final int FIELD_CENTEROFROTATION = 9;
    protected static final int LAST_VIEWPOINT_INDEX = 9;
    protected static final int NUM_FIELDS = 10;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float vfFieldOfView = 0.785398f;
    protected boolean vfJump = true;
    protected float[] vfOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    protected float[] vfPosition = new float[]{0.0f, 0.0f, 10.0f};
    protected float[] vfCenterOfRotation = new float[]{0.0f, 0.0f, 0.0f};
    protected String vfDescription;

    protected BaseViewpoint() {
        super("Viewpoint");
        this.hasChanged = new boolean[10];
    }

    protected BaseViewpoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("fieldOfView");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFieldOfView = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("jump");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfJump = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("orientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("position");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPosition[0] = vRMLFieldData.floatArrayValue[0];
            this.vfPosition[1] = vRMLFieldData.floatArrayValue[1];
            this.vfPosition[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("centerOfRotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenterOfRotation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenterOfRotation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenterOfRotation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("description");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDescription = vRMLFieldData.stringValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getProjectionType() {
        return 0;
    }

    public float getFieldOfView() {
        return this.vfFieldOfView;
    }

    public void setFieldOfView(float f) throws InvalidFieldValueException {
        this.checkFieldOfView(f);
        this.vfFieldOfView = f;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public boolean getJump() {
        return this.vfJump;
    }

    public void setJump(boolean bl) {
        bl = true;
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public float[] getCenterOfRotation() {
        return this.vfCenterOfRotation;
    }

    public void setCenterOfRotation(float[] fArray) throws InvalidFieldValueException {
        this.vfCenterOfRotation[0] = fArray[0];
        this.vfCenterOfRotation[1] = fArray[1];
        this.vfCenterOfRotation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 55;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfFieldOfView;
                this.fieldData.dataType = (short)4;
                this.fieldData.numElements = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfJump;
                this.fieldData.dataType = 1;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOrientation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfPosition;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfCenterOfRotation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfFieldOfView);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfJump);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfOrientation, 4);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfPosition, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfCenterOfRotation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseViewpoint.sendRoute: No field!" + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.vfJump = bl;
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setFieldOfView(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setOrientation(fArray);
                break;
            }
            case 7: {
                this.setPosition(fArray);
                break;
            }
            case 9: {
                this.setCenterOfRotation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.vfDescription = string;
                if (this.inSetup) break;
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setPosition(float[] fArray) {
        this.vfPosition[0] = fArray[0];
        this.vfPosition[1] = fArray[1];
        this.vfPosition[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void setOrientation(float[] fArray) {
        this.vfOrientation[0] = fArray[0];
        this.vfOrientation[1] = fArray[1];
        this.vfOrientation[2] = fArray[2];
        this.vfOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void checkFieldOfView(float f) throws InvalidFieldValueException {
        if (f <= 0.0f || f > (float)Math.PI) {
            throw new InvalidFieldValueException("FieldOfView must be (0,PI)");
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(30);
        BaseViewpoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseViewpoint.fieldDecl[1] = new VRMLFieldDeclaration(1, "SFBool", "set_bind");
        BaseViewpoint.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFTime", "bindTime");
        BaseViewpoint.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isBound");
        BaseViewpoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "fieldOfView");
        BaseViewpoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFBool", "jump");
        BaseViewpoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFRotation", "orientation");
        BaseViewpoint.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec3f", "position");
        BaseViewpoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFVec3f", "centerOfRotation");
        BaseViewpoint.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFString", "description");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("fieldOfView", n);
        fieldMap.put("set_fieldOfView", n);
        fieldMap.put("fieldOfView_changed", n);
        n = new Integer(5);
        fieldMap.put("jump", n);
        fieldMap.put("set_jump", n);
        fieldMap.put("jump_changed", n);
        n = new Integer(6);
        fieldMap.put("orientation", n);
        fieldMap.put("set_orientation", n);
        fieldMap.put("orientation_changed", n);
        n = new Integer(7);
        fieldMap.put("position", n);
        fieldMap.put("set_position", n);
        fieldMap.put("position_changed", n);
        n = new Integer(9);
        fieldMap.put("centerOfRotation", n);
        fieldMap.put("set_centerOfRotation", n);
        fieldMap.put("centerOfRotation_changed", n);
        fieldMap.put("set_bind", new Integer(1));
        fieldMap.put("bindTime", new Integer(2));
        fieldMap.put("isBound", new Integer(3));
        fieldMap.put("description", new Integer(8));
    }
}

