/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.networking;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLLinkNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGroupingNode;
import org.web3d.vrml.util.URLChecker;

public class BaseAnchor
extends BaseGroupingNode
implements VRMLLinkNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{28};
    protected static final int FIELD_DESCRIPTION = 6;
    protected static final int FIELD_PARAMETER = 7;
    protected static final int FIELD_URL = 8;
    protected static final int LAST_ANCHOR_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String[] vfUrl;
    protected String worldURL;
    protected boolean urlRelativeCheck;
    protected String[] vfParameter;
    protected String vfDescription;

    public BaseAnchor() {
        super("Anchor");
        this.hasChanged = new boolean[9];
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.vfParameter = FieldConstants.EMPTY_MFSTRING;
    }

    public BaseAnchor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLGroupingNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("description");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDescription = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("parameter");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfParameter = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfParameter, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public String[] getParameter() {
        return this.vfParameter;
    }

    public void setParameter(String[] stringArray) {
        if (this.vfParameter.length != stringArray.length) {
            this.vfParameter = new String[stringArray.length];
        }
        if (stringArray.length != 0) {
            System.arraycopy(stringArray, 0, this.vfParameter, 0, stringArray.length);
        }
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        this.worldURL = string;
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = n > 0 ? (this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray) : FieldConstants.EMPTY_MFSTRING;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfParameter;
                this.fieldData.dataType = (short)14;
                if (this.vfParameter != null) {
                    this.fieldData.numElements = this.vfParameter.length;
                    break;
                }
                this.fieldData.numElements = 0;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.dataType = (short)14;
                if (this.vfUrl != null) {
                    this.fieldData.numElements = this.vfUrl.length;
                    break;
                }
                this.fieldData.numElements = 0;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfParameter, this.vfParameter.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.setDescription(string);
                break;
            }
            case 8: {
                this.setUrl(new String[]{string}, 1);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.setUrl(stringArray, n2);
                break;
            }
            case 7: {
                this.setParameter(stringArray);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    private String[] checkURLs(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            stringArray2[i] = string.length() > 0 && string.charAt(0) != '#' && string.indexOf(58) == -1 ? this.worldURL + string : string;
        }
        return stringArray2;
    }

    static {
        nodeFields = new int[]{1, 0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(9);
        BaseAnchor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseAnchor.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseAnchor.fieldDecl[2] = new VRMLFieldDeclaration(1, "MFNode", "addChildren");
        BaseAnchor.fieldDecl[3] = new VRMLFieldDeclaration(1, "MFNode", "removeChildren");
        BaseAnchor.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseAnchor.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseAnchor.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFString", "description");
        BaseAnchor.fieldDecl[7] = new VRMLFieldDeclaration(3, "MFString", "parameter");
        BaseAnchor.fieldDecl[8] = new VRMLFieldDeclaration(3, "MFString", "url");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(2);
        fieldMap.put("addChildren", n);
        fieldMap.put("set_addChildren", n);
        n = new Integer(3);
        fieldMap.put("removeChildren", n);
        fieldMap.put("set_removeChildren", n);
        fieldMap.put("bboxCenter", new Integer(4));
        fieldMap.put("bboxSize", new Integer(5));
        n = new Integer(6);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(7);
        fieldMap.put("parameter", n);
        fieldMap.put("set_parameter", n);
        fieldMap.put("parameter_changed", n);
        n = new Integer(8);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
    }
}

