/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.networking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;
import org.web3d.vrml.util.URLChecker;

public class BaseInline
extends AbstractNode
implements VRMLInlineNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{44};
    protected static final int FIELD_URL = 1;
    protected static final int FIELD_BBOX_CENTER = 2;
    protected static final int FIELD_BBOX_SIZE = 3;
    protected static final int FIELD_LOAD = 4;
    protected static final int LAST_INLINE_INDEX = 4;
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    private static final HashSet validVrmlTypes;
    private static final HashSet validX3DTypes;
    protected float[] vfBboxCenter;
    protected float[] vfBboxSize;
    protected String[] vfUrl;
    protected boolean vfLoad;
    protected String worldURL;
    protected String loadedURI;
    protected boolean urlRelativeCheck;
    protected int loadState;
    protected VRMLScene scene;
    private ArrayList urlListeners;
    private ArrayList contentListeners;
    private VRMLExecutionSpace execSpace;
    private Map exportProxyNodes;

    public BaseInline() {
        super("Inline");
        this.inSetup = true;
        this.hasChanged = new boolean[5];
        this.urlRelativeCheck = false;
        this.vfBboxSize = new float[]{-1.0f, -1.0f, -1.0f};
        this.vfBboxCenter = new float[]{0.0f, 0.0f, 0.0f};
        this.vfLoad = true;
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.urlListeners = new ArrayList(1);
        this.contentListeners = new ArrayList(1);
    }

    public BaseInline(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("bboxCenter");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBboxCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBboxCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBboxCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("bboxSize");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBboxSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBboxSize[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBboxSize[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
            if (this.vrmlMajorVersion > 2) {
                n = vRMLNodeType.getFieldIndex("load");
                vRMLFieldData = vRMLNodeType.getFieldValue(n);
                this.vfLoad = vRMLFieldData.booleanValue;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public float[] getBboxCenter() {
        return this.vfBboxCenter;
    }

    public float[] getBboxSize() {
        return this.vfBboxSize;
    }

    public BasicScene getContainedScene() {
        return this.scene;
    }

    public VRMLExecutionSpace getParentSpace() {
        return this.execSpace;
    }

    public void setParentSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        this.execSpace = vRMLExecutionSpace;
    }

    public void setImportNodes(Map map) {
        this.exportProxyNodes = map;
    }

    public boolean checkValidContentType(String string) {
        if (this.vrmlMajorVersion == 2) {
            return validVrmlTypes.contains((Object)string);
        }
        return validX3DTypes.contains((Object)string);
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        this.loadState = n;
        this.fireContentStateChanged();
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
            this.fireUrlChanged();
        }
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        if (!(object instanceof VRMLScene)) {
            throw new IllegalArgumentException("Invalid content type for inline. Not VRMLScene");
        }
        this.scene = (VRMLScene)object;
        this.stateManager.registerAddedScene((VRMLExecutionSpace)this);
        if (this.exportProxyNodes == null) {
            return;
        }
        Map map = this.scene.getExports();
        Map map2 = this.scene.getDEFNodes();
        Set set = this.exportProxyNodes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            VRMLNodeType vRMLNodeType = (VRMLNodeType)map2.get(string3);
            if (vRMLNodeType == null) {
                this.errorReporter.warningReport("Unable to map import of " + string2 + " to an exported " + " name in " + this.loadedURI, null);
                continue;
            }
            ImportNodeProxy importNodeProxy = (ImportNodeProxy)this.exportProxyNodes.get(string2);
            importNodeProxy.setErrorReporter(this.errorReporter);
            importNodeProxy.setRealNode(vRMLNodeType);
        }
    }

    public void setLoadedURI(String string) {
        this.loadedURI = string;
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            this.vfUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfUrl, (boolean)false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (!this.vfLoad) {
            this.loadState = 3;
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        if (this.exportProxyNodes != null) {
            Set set = this.exportProxyNodes.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ImportNodeProxy importNodeProxy = (ImportNodeProxy)this.exportProxyNodes.get(string);
                importNodeProxy.setErrorReporter(this.errorReporter);
            }
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 24;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfUrl.length;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxSize;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBboxCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                if (this.vrmlMajorVersion == 2) {
                    throw new InvalidFieldException("load field not defined for VRML97");
                }
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfLoad;
                this.fieldData.dataType = 1;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfLoad);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setBboxCenter(fArray);
                break;
            }
            case 3: {
                this.setBboxSize(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setUrl(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.setLoad(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    private void setBboxCenter(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("bboxCenter is initializeOnly");
        }
        this.vfBboxCenter[0] = fArray[0];
        this.vfBboxCenter[1] = fArray[1];
        this.vfBboxCenter[2] = fArray[2];
    }

    private void setBboxSize(float[] fArray) {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("bboxSize is initializeOnly");
        }
        FieldValidator.checkBBoxSize((String)"BaseShape.bboxSize", (float[])fArray);
        this.vfBboxSize[0] = fArray[0];
        this.vfBboxSize[1] = fArray[1];
        this.vfBboxSize[2] = fArray[2];
    }

    protected void setLoad(boolean bl) throws InvalidFieldException {
        if (this.vrmlMajorVersion == 2) {
            throw new InvalidFieldException("load field not defined for VRML97");
        }
        if (!this.inSetup && !bl) {
            this.stateManager.registerRemovedScene((VRMLExecutionSpace)this);
        }
        boolean bl2 = !this.vfLoad && bl;
        this.vfLoad = bl;
        if (!this.inSetup) {
            this.fireFieldChanged(4);
            this.hasChanged[4] = true;
        }
        if (bl2) {
            this.fireUrlChanged();
        }
    }

    protected void fireUrlChanged() {
        int n = this.urlListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, 1);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, 1, this.loadState);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(5);
        BaseInline.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseInline.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFString", "url");
        BaseInline.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseInline.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseInline.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "load");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
        n = new Integer(4);
        fieldMap.put("load", n);
        fieldMap.put("set_load", n);
        fieldMap.put("load_changed", n);
        fieldMap.put("bboxCenter", new Integer(2));
        fieldMap.put("bboxSize", new Integer(3));
        validVrmlTypes = new HashSet();
        validX3DTypes = new HashSet();
        validVrmlTypes.add((Object)"model/vrml");
        validVrmlTypes.add((Object)"x-world/x-vrml");
        validX3DTypes.add((Object)"model/x3d+vrml");
        validX3DTypes.add((Object)"model/x3d+xml");
        validX3DTypes.add((Object)"model/x3d+binary");
    }
}

