/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.nurbs;

import java.util.HashMap;
import org.j3d.geom.GeometryData;
import org.j3d.geom.spline.BSplineGenerator;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParametricGeometryNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseNurbsCurve
extends AbstractNode
implements VRMLParametricGeometryNodeType {
    protected static final int FIELD_CONTROL_POINT = 1;
    protected static final int FIELD_TESSELLATION = 2;
    protected static final int FIELD_WEIGHT = 3;
    protected static final int FIELD_KNOT = 4;
    protected static final int FIELD_ORDER = 5;
    protected static final int LAST_CURVE_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int vfTessellation;
    private double[] vfControlPoint;
    private double[] vfWeight;
    private double[] vfKnot;
    private int vfOrder;
    private BSplineGenerator generator;
    protected GeometryData geometryData;
    private boolean controlPointsChanged;
    private boolean weightsChanged;

    protected BaseNurbsCurve() {
        super("NurbsCurve");
        this.hasChanged = new boolean[6];
        this.vfOrder = 3;
        this.generator = new BSplineGenerator();
        this.geometryData = new GeometryData();
        this.geometryData.geometryType = 10;
        this.controlPointsChanged = false;
        this.weightsChanged = false;
    }

    public BaseNurbsCurve(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("controlPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfControlPoint = new double[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfControlPoint, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("order");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrder = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("tessellation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTessellation = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("weight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfWeight = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfWeight, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("knot");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKnot = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfKnot, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        boolean bl = true;
        if (this.vfControlPoint != null) {
            this.generator.setControlPoints(this.vfControlPoint);
        } else {
            bl = false;
        }
        if (this.vfKnot != null && this.vfKnot.length >= this.vfControlPoint.length / 3 + this.vfOrder) {
            this.generator.setKnots(this.vfOrder - 1, this.vfKnot);
        } else {
            bl = false;
        }
        if (this.vfWeight != null) {
            this.generator.setWeights(this.vfWeight);
        }
        if (!bl || this.vfOrder < 2) {
            this.geometryData.vertexCount = 0;
        }
        this.updateFacetCount();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 35;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfControlPoint;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfControlPoint == null ? 0 : this.vfControlPoint.length / 3;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfWeight;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfWeight == null ? 0 : this.vfWeight.length;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfKnot;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfKnot == null ? 0 : this.vfKnot.length;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfOrder;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfTessellation;
                this.fieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfControlPoint, this.vfControlPoint.length);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfTessellation);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfOrder);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfKnot, this.vfKnot.length);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfWeight, this.vfWeight.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field order");
                }
                this.vfOrder = n2;
                if (this.vfOrder >= 2) break;
                throw new InvalidFieldValueException("Order < 2: " + n2);
            }
            case 2: {
                this.vfTessellation = n2;
                this.updateFacetCount();
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setWeight(dArray, n2);
                break;
            }
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field knot");
                }
                this.setKnot(dArray);
                break;
            }
            case 1: {
                this.setControlPoints(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    private void setKnot(double[] dArray) {
        if (dArray != null) {
            if (dArray.length > this.vfKnot.length) {
                this.vfKnot = new double[dArray.length];
            }
            System.arraycopy(dArray, 0, this.vfKnot, 0, dArray.length);
        } else {
            this.vfKnot = null;
        }
    }

    private void setWeight(double[] dArray, int n) {
        if (n != 0) {
            if (this.vfWeight == null || n > this.vfWeight.length) {
                this.vfWeight = new double[n];
            }
            System.arraycopy(dArray, 0, this.vfWeight, 0, n);
        } else {
            this.vfWeight = null;
        }
        if (!this.inSetup) {
            this.weightsChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setControlPoints(double[] dArray) {
        int n = 0;
        if (dArray != null) {
            this.vfControlPoint = new double[dArray.length];
            n = dArray.length;
        }
        if (n != 0) {
            System.arraycopy(dArray, 0, this.vfControlPoint, 0, n);
        }
        if (!this.inSetup) {
            this.controlPointsChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void updateFacetCount() {
        int n = 0;
        n = this.vfTessellation > 0 ? this.vfTessellation : (this.vfTessellation < 0 ? -this.vfTessellation * this.vfControlPoint.length / 3 : 2 * this.vfControlPoint.length / 3);
        this.generator.setFacetCount(n);
    }

    protected boolean regenerateCurve() {
        if (this.vfControlPoint == null || this.vfKnot == null || this.vfOrder < 2) {
            this.geometryData.vertexCount = 0;
            return false;
        }
        if (this.controlPointsChanged) {
            this.generator.setControlPoints(this.vfControlPoint);
            this.controlPointsChanged = false;
        }
        if (this.weightsChanged) {
            this.generator.setWeights(this.vfWeight);
            this.weightsChanged = false;
        }
        this.generator.generate(this.geometryData);
        return true;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(6);
        BaseNurbsCurve.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseNurbsCurve.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3d", "controlPoint");
        BaseNurbsCurve.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFDouble", "weight");
        BaseNurbsCurve.fieldDecl[4] = new VRMLFieldDeclaration(2, "MFDouble", "knot");
        BaseNurbsCurve.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFInt32", "order");
        BaseNurbsCurve.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFInt32", "tessellation");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("tessellation", n);
        fieldMap.put("set_tessellation", n);
        fieldMap.put("tessellation_changed", n);
        n = new Integer(1);
        fieldMap.put("controlPoint", n);
        fieldMap.put("set_controlPoint", n);
        fieldMap.put("controlPoint_changed", n);
        n = new Integer(3);
        fieldMap.put("weight", n);
        fieldMap.put("set_weight", n);
        fieldMap.put("weight_changed", n);
        fieldMap.put("knot", new Integer(4));
        fieldMap.put("order", new Integer(5));
    }
}

