/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.nurbs;

import java.util.HashMap;
import org.j3d.geom.spline.BSplineCurveData;
import org.j3d.geom.spline.BSplineUtils;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLInterpolatorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseInterpolatorNode;

public abstract class BaseNurbsPositionInterpolator
extends BaseInterpolatorNode {
    protected static final int FIELD_WEIGHT = 5;
    protected static final int FIELD_KNOT = 6;
    protected static final int FIELD_ORDER = 7;
    protected static final int LAST_NURBSPOSITIONINTERPOLATOR_INDEX = 7;
    private static final int NUM_FIELDS = 8;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private float[] vfKeyValue;
    private int numKeyValue;
    private double[] vfWeight;
    private double[] vfKnot;
    private int vfOrder;
    private float[] vfValue;
    private BSplineCurveData curveData;
    private float[] position;

    protected BaseNurbsPositionInterpolator() {
        super("NurbsPositionInterpolator");
        this.hasChanged = new boolean[8];
        this.vfKeyValue = FieldConstants.EMPTY_MFVEC3F;
        this.vfValue = new float[3];
        this.vfOrder = 3;
        this.curveData = new BSplineCurveData();
        this.position = new float[3];
    }

    protected BaseNurbsPositionInterpolator(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLInterpolatorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("keyValue");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.numKeyValue = vRMLFieldData.numElements;
            if (vRMLFieldData.numElements != 0) {
                this.vfKeyValue = new float[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfKeyValue, 0, vRMLFieldData.numElements);
                this.numKeyValue = vRMLFieldData.numElements;
            }
            n = vRMLNodeType.getFieldIndex("order");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrder = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("weight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfWeight = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfWeight, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("knot");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfKnot = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfKnot, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setFraction(float f) {
        this.vfFraction = f;
        if (this.vfKey != null && this.vfKey.length > 0) {
            BSplineUtils.interpolatePoint((BSplineCurveData)this.curveData, (float)f, (float[])this.position);
            this.setValue(this.position);
        }
    }

    public void setKey(float[] fArray, int n) {
        super.setKey(fArray, n);
        if (!this.inSetup) {
            this.setFraction(this.vfFraction);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 7) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfKeyValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numKeyValue / 3;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfValue;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfWeight;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfWeight == null ? 0 : this.vfWeight.length;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfKnot;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfKnot == null ? 0 : this.vfKnot.length;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfOrder;
                this.fieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfKeyValue, this.numKeyValue);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfValue, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfWeight, this.vfWeight.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Cannot set knot field");
        }
        switch (n) {
            case 7: {
                this.vfOrder = n2;
                this.curveData.degree = n2 - 1;
                if (this.inSetup) break;
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 3) {
            super.setValue(n, f);
            return;
        }
        this.setFraction(f);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setKeyValue(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setWeight(dArray, n2);
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set knot");
                }
                this.setKnot(dArray, n2);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    private void setKnot(double[] dArray, int n) {
        int n2 = 0;
        if (n != 0) {
            if (this.vfKnot == null || n > this.vfKnot.length) {
                this.vfKnot = new double[n];
                this.curveData.knots = new float[n];
            }
            n2 = n;
        } else {
            this.vfKnot = null;
        }
        this.curveData.numKnots = n2;
        if (n2 != 0) {
            System.arraycopy(dArray, 0, this.vfKnot, 0, n2);
            for (int i = 0; i < n2; ++i) {
                this.curveData.knots[i] = (float)dArray[i];
            }
        }
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setWeight(double[] dArray, int n) {
        int n2 = 0;
        if (n != 0) {
            if (this.vfWeight == null || n > this.vfWeight.length) {
                this.vfWeight = new double[n];
                this.curveData.weights = new float[n];
            }
            n2 = n;
        } else {
            this.vfWeight = null;
        }
        this.curveData.numWeights = n2;
        if (n2 != 0) {
            System.arraycopy(dArray, 0, this.vfWeight, 0, n2);
            for (int i = 0; i < n2; ++i) {
                this.curveData.weights[i] = (float)dArray[i];
            }
        }
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setKeyValue(float[] fArray, int n) {
        this.numKeyValue = n;
        if (this.numKeyValue > this.vfKeyValue.length) {
            this.vfKeyValue = new float[this.numKeyValue];
        }
        if (this.numKeyValue > 0) {
            System.arraycopy(fArray, 0, this.vfKeyValue, 0, n);
        }
        this.curveData.controlPoints = fArray;
        this.curveData.numControlPoints = n;
        if (!this.inSetup) {
            this.setFraction(this.vfFraction);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setValue(float[] fArray) {
        if (fArray != null) {
            this.vfValue[0] = fArray[0];
            this.vfValue[1] = fArray[1];
            this.vfValue[2] = fArray[2];
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[8];
        fieldMap = new HashMap(24);
        BaseNurbsPositionInterpolator.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseNurbsPositionInterpolator.fieldDecl[3] = new VRMLFieldDeclaration(1, "SFFloat", "set_fraction");
        BaseNurbsPositionInterpolator.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFFloat", "key");
        BaseNurbsPositionInterpolator.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFVec3f", "keyValue");
        BaseNurbsPositionInterpolator.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "value_changed");
        BaseNurbsPositionInterpolator.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFDouble", "weight");
        BaseNurbsPositionInterpolator.fieldDecl[6] = new VRMLFieldDeclaration(2, "MFDouble", "knot");
        BaseNurbsPositionInterpolator.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFInt32", "order");
        fieldMap.put("set_fraction", new Integer(3));
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("key", n);
        fieldMap.put("set_key", n);
        fieldMap.put("key_changed", n);
        n = new Integer(2);
        fieldMap.put("keyValue", n);
        fieldMap.put("set_keyValue", n);
        fieldMap.put("keyValue_changed", n);
        fieldMap.put("value_changed", new Integer(4));
        n = new Integer(5);
        fieldMap.put("weight", n);
        fieldMap.put("set_weight", n);
        fieldMap.put("weight_changed", n);
        fieldMap.put("knot", new Integer(6));
        fieldMap.put("order", new Integer(7));
    }
}

