/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.nurbs;

import java.util.HashMap;
import org.j3d.geom.GeometryData;
import org.j3d.geom.spline.BSplinePatchGenerator;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParametricGeometryNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseNurbsSurface
extends AbstractNode
implements VRMLParametricGeometryNodeType {
    protected static final int FIELD_CONTROL_POINT = 1;
    protected static final int FIELD_TEXCOORD = 2;
    protected static final int FIELD_UTESSELLATION = 3;
    protected static final int FIELD_VTESSELLATION = 4;
    protected static final int FIELD_WEIGHT = 5;
    protected static final int FIELD_SOLID = 6;
    protected static final int FIELD_UDIMENSION = 7;
    protected static final int FIELD_UKNOT = 8;
    protected static final int FIELD_UORDER = 9;
    protected static final int FIELD_VDIMENSION = 10;
    protected static final int FIELD_VKNOT = 11;
    protected static final int FIELD_VORDER = 12;
    protected static final int LAST_CURVE_INDEX = 12;
    protected static final int NUM_FIELDS = 13;
    protected static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture object";
    protected static final String TEXTURE_NODE_MSG = "Node does not describe a Texture object";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected VRMLProtoInstance pTexCoord;
    protected VRMLTextureCoordinateNodeType vfTexCoord;
    protected double[] vfControlPoint;
    protected int vfUTessellation;
    protected int vfVTessellation;
    protected double[] vfWeight;
    protected boolean vfSolid;
    private int vfUDimension;
    private double[] vfUKnot;
    private int vfUOrder;
    private int vfVDimension;
    private double[] vfVKnot;
    private int vfVOrder;
    private BSplinePatchGenerator generator;
    protected GeometryData geometryData;
    private boolean controlPointsChanged;
    private boolean weightsChanged;

    protected BaseNurbsSurface() {
        super("NurbsSurface");
        this.hasChanged = new boolean[13];
        this.vfUOrder = 3;
        this.vfVOrder = 3;
        this.vfSolid = true;
        this.generator = new BSplinePatchGenerator();
        this.geometryData = new GeometryData();
        this.geometryData.geometryType = 3;
        this.geometryData.geometryComponents = 6;
        this.controlPointsChanged = false;
        this.weightsChanged = false;
    }

    public BaseNurbsSurface(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("controlPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfControlPoint = new double[vRMLFieldData.numElements * 3];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfControlPoint, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("uTessellation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUTessellation = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("vTessellation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVTessellation = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("solid");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSolid = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("uOrder");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUOrder = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("vOrder");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfVOrder = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("weight");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfWeight = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfWeight, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("uKnot");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUKnot = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfUKnot, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("vKnot");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfVKnot = new double[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.vfVKnot, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean hasLocalColors() {
        return false;
    }

    public boolean hasLocalColorAlpha() {
        return false;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public int getNumSets() {
        return 0;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pTexCoord != null) {
            this.pTexCoord.setupFinished();
        }
        if (this.vfTexCoord != null) {
            this.vfTexCoord.setupFinished();
        }
        boolean bl = true;
        if (this.vfControlPoint != null) {
            this.generator.setPatchControlPoints(this.vfControlPoint, this.vfUDimension, this.vfVDimension);
        } else {
            bl = false;
        }
        if (this.vfUKnot != null && this.vfVKnot != null && this.vfUKnot.length >= this.vfUDimension + this.vfUOrder && this.vfVKnot.length >= this.vfVDimension + this.vfVOrder) {
            this.generator.setPatchKnots(this.vfUOrder - 1, this.vfUKnot, this.vfVOrder - 1, this.vfVKnot);
        } else {
            bl = false;
        }
        if (this.vfWeight != null) {
            this.generator.setPatchWeights(this.vfWeight, this.vfUDimension, this.vfVDimension);
        }
        if (!bl || this.vfUOrder < 2 || this.vfVOrder < 2) {
            this.geometryData.vertexCount = 0;
        }
        this.updateFacetCount();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 35;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfControlPoint;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfControlPoint == null ? 0 : this.vfControlPoint.length / 3;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pTexCoord != null ? this.pTexCoord : this.vfTexCoord;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfWeight;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfWeight == null ? 0 : this.vfWeight.length;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfUKnot;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfUKnot == null ? 0 : this.vfUKnot.length;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.doubleArrayValue = this.vfVKnot;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements = this.vfVKnot == null ? 0 : this.vfVKnot.length;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfUOrder;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfVOrder;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfUDimension;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfVDimension;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfUTessellation;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfVTessellation;
                this.fieldData.dataType = (short)2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfControlPoint, this.vfControlPoint.length);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfUTessellation);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfVTessellation);
                    break;
                }
                case 2: {
                    if (this.pTexCoord != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pTexCoord);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfTexCoord);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfWeight, this.vfWeight.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot write to field solid");
                }
                this.vfSolid = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field uOrder");
                }
                this.vfUOrder = n2;
                if (this.vfUOrder >= 2) break;
                throw new InvalidFieldValueException("uOrder < 2: " + n2);
            }
            case 12: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field vOrder");
                }
                this.vfVOrder = n2;
                if (this.vfVOrder >= 2) break;
                throw new InvalidFieldValueException("vOrder < 2: " + n2);
            }
            case 3: {
                this.vfUTessellation = n2;
                this.updateFacetCount();
                break;
            }
            case 4: {
                this.vfVTessellation = n2;
                this.updateFacetCount();
                break;
            }
            case 7: {
                this.vfUDimension = n2;
                this.updateFacetCount();
                break;
            }
            case 10: {
                this.vfVDimension = n2;
                this.updateFacetCount();
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setWeight(dArray, n2);
                break;
            }
            case 8: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field uKnot");
                }
                if (dArray == null) break;
                this.vfUKnot = new double[dArray.length];
                System.arraycopy(dArray, 0, this.vfUKnot, 0, dArray.length);
                break;
            }
            case 11: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set field vKnot");
                }
                if (dArray == null) break;
                this.vfVKnot = new double[dArray.length];
                System.arraycopy(dArray, 0, this.vfVKnot, 0, dArray.length);
                break;
            }
            case 1: {
                this.setControlPoints(dArray);
                break;
            }
            default: {
                super.setValue(n, dArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 2: {
                this.setTexCoord(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    private void setWeight(double[] dArray, int n) {
        if (n != 0) {
            if (this.vfWeight == null || n > this.vfWeight.length) {
                this.vfWeight = new double[n];
            }
            System.arraycopy(dArray, 0, this.vfWeight, 0, n);
        } else {
            this.vfWeight = null;
        }
        if (!this.inSetup) {
            this.weightsChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setControlPoints(double[] dArray) {
        int n = 0;
        if (dArray != null) {
            this.vfControlPoint = new double[dArray.length];
            n = dArray.length;
        }
        if (n != 0) {
            System.arraycopy(dArray, 0, this.vfControlPoint, 0, n);
        }
        if (!this.inSetup) {
            this.controlPointsChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void updateFacetCount() {
        int n = 0;
        int n2 = 0;
        n = this.vfUTessellation > 0 ? this.vfUTessellation : (this.vfUTessellation < 0 ? -this.vfUTessellation * this.vfUDimension : 2 * this.vfUDimension);
        n2 = this.vfVTessellation > 0 ? this.vfVTessellation : (this.vfVTessellation < 0 ? -this.vfVTessellation * this.vfUDimension : 2 * this.vfUDimension);
        this.generator.setFacetCount(n, n2);
    }

    private void setTexCoord(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType;
        Object object = this.pTexCoord != null ? this.pTexCoord : this.vfTexCoord;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pTexCoord = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLTextureCoordinateNodeType != null && !(vRMLTextureCoordinateNodeType instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
            }
            this.pTexCoord = null;
            vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)vRMLNodeType;
        }
        this.vfTexCoord = vRMLTextureCoordinateNodeType;
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                vRMLNodeType.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected boolean regenerateSurface() {
        if (this.vfControlPoint == null || this.vfUKnot == null || this.vfVKnot == null || this.vfUOrder < 2 || this.vfVOrder < 2) {
            this.geometryData.vertexCount = 0;
            return false;
        }
        if (this.controlPointsChanged) {
            this.generator.setPatchControlPoints(this.vfControlPoint, this.vfUDimension, this.vfVDimension);
            this.controlPointsChanged = false;
        }
        if (this.weightsChanged) {
            this.generator.setPatchWeights(this.vfWeight, this.vfUDimension, this.vfVDimension);
            this.weightsChanged = false;
        }
        this.generator.generate(this.geometryData);
        return true;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(13);
        BaseNurbsSurface.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseNurbsSurface.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFVec3d", "controlPoint");
        BaseNurbsSurface.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseNurbsSurface.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFInt32", "uTessellation");
        BaseNurbsSurface.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFInt32", "vTessellation");
        BaseNurbsSurface.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFDouble", "weight");
        BaseNurbsSurface.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseNurbsSurface.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFDouble", "vKnot");
        BaseNurbsSurface.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFInt32", "vDimension");
        BaseNurbsSurface.fieldDecl[12] = new VRMLFieldDeclaration(2, "SFInt32", "vOrder");
        BaseNurbsSurface.fieldDecl[8] = new VRMLFieldDeclaration(2, "MFDouble", "uKnot");
        BaseNurbsSurface.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFInt32", "uDimension");
        BaseNurbsSurface.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFInt32", "uOrder");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("uTessellation", n);
        fieldMap.put("set_uTessellation", n);
        fieldMap.put("uTessellation_changed", n);
        n = new Integer(4);
        fieldMap.put("vTessellation", n);
        fieldMap.put("set_vTessellation", n);
        fieldMap.put("vTessellation_changed", n);
        n = new Integer(1);
        fieldMap.put("controlPoint", n);
        fieldMap.put("set_controlPoint", n);
        fieldMap.put("controlPoint_changed", n);
        n = new Integer(5);
        fieldMap.put("weight", n);
        fieldMap.put("set_weight", n);
        fieldMap.put("weight_changed", n);
        n = new Integer(2);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        fieldMap.put("solid", new Integer(6));
        fieldMap.put("uDimension", new Integer(7));
        fieldMap.put("vDimension", new Integer(10));
        fieldMap.put("uKnot", new Integer(8));
        fieldMap.put("uOrder", new Integer(9));
        fieldMap.put("vKnot", new Integer(11));
        fieldMap.put("vOrder", new Integer(12));
    }
}

