/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import java.util.HashMap;
import org.j3d.geom.particle.ExplosionPointEmitter;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticleEmitterNodeType;
import org.web3d.vrml.renderer.common.nodes.particle.BaseEmitter;

public abstract class BaseExplosionEmitter
extends BaseEmitter {
    protected static final int FIELD_POSITION = 6;
    protected static final int LAST_EXPL_EMITTER_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfPosition;

    protected BaseExplosionEmitter() {
        super("ExplosionEmitter");
        this.hasChanged = new boolean[7];
        this.vfPosition = new float[]{0.0f, 0.0f, 0.0f};
        this.initializer = new ExplosionPointEmitter();
        this.initializer.setMass(this.vfMass);
        this.initializer.setSurfaceArea(this.vfSurfaceArea);
        this.initializer.setSpeed(this.vfSpeed);
        this.initializer.setParticleVariation(this.vfVariation);
    }

    public BaseExplosionEmitter(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLParticleEmitterNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("position");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPosition[0] = vRMLFieldData.floatArrayValue[0];
            this.vfPosition[1] = vRMLFieldData.floatArrayValue[1];
            this.vfPosition[2] = vRMLFieldData.floatArrayValue[2];
            ((ExplosionPointEmitter)this.initializer).setPosition(this.vfPosition[0], this.vfPosition[1], this.vfPosition[2]);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfPosition;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfPosition, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 6: {
                this.setPosition(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void setPosition(float[] fArray) {
        this.vfPosition[0] = fArray[0];
        this.vfPosition[1] = fArray[1];
        this.vfPosition[2] = fArray[2];
        ((ExplosionPointEmitter)this.initializer).setPosition(fArray[0], fArray[1], fArray[2]);
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseExplosionEmitter.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseExplosionEmitter.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "position");
        BaseExplosionEmitter.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "variation");
        BaseExplosionEmitter.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "speed");
        BaseExplosionEmitter.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFFloat", "mass");
        BaseExplosionEmitter.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFFloat", "surfaceArea");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(6);
        fieldMap.put("position", n);
        fieldMap.put("set_position", n);
        fieldMap.put("position_changed", n);
        n = new Integer(1);
        fieldMap.put("speed", n);
        fieldMap.put("set_speed", n);
        fieldMap.put("speed_changed", n);
        n = new Integer(4);
        fieldMap.put("variation", n);
        fieldMap.put("set_variation", n);
        fieldMap.put("variation_changed", n);
        n = new Integer(2);
        fieldMap.put("mass", n);
        fieldMap.put("set_mass", n);
        fieldMap.put("mass_changed", n);
        n = new Integer(3);
        fieldMap.put("surfaceArea", n);
        fieldMap.put("set_surfaceArea", n);
        fieldMap.put("surfaceArea_changed", n);
    }
}

