/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.particle;

import java.util.HashMap;
import org.j3d.geom.particle.WindParticleFunction;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLParticlePhysicsModelNodeType;
import org.web3d.vrml.renderer.common.nodes.particle.BasePhysicsModel;

public abstract class BaseWindPhysicsModel
extends BasePhysicsModel {
    protected static final int FIELD_DIRECTION = 2;
    protected static final int FIELD_GUSTINESS = 3;
    protected static final int FIELD_TURBULENCE = 4;
    protected static final int FIELD_SPEED = 5;
    protected static final int LAST_WIND_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    private static final String TURBULENCE_RANGE_ERR = "Value of turbulence is outside the acceptable range [0,1]: ";
    private static final String NEG_GUSTINESS_ERR = "The gustiness value being set is negative: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfDirection;
    protected float vfGustiness;
    protected float vfSpeed;
    protected float vfTurbulence;

    public BaseWindPhysicsModel() {
        super("WindPhysics");
        this.hasChanged = new boolean[6];
        this.vfDirection = new float[3];
        this.vfTurbulence = 0.0f;
        this.vfSpeed = 0.1f;
        this.vfGustiness = 0.1f;
        this.particleFunction = new WindParticleFunction(this.vfDirection, this.vfSpeed, this.vfGustiness, this.vfTurbulence);
    }

    public BaseWindPhysicsModel(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLParticlePhysicsModelNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirection[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDirection[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDirection[2] = vRMLFieldData.floatArrayValue[2];
            ((WindParticleFunction)this.particleFunction).setDirection(this.vfDirection[0], this.vfDirection[1], this.vfDirection[2]);
            n = vRMLNodeType.getFieldIndex("gustiness");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGustiness = vRMLFieldData.floatValue;
            ((WindParticleFunction)this.particleFunction).setGustiness(this.vfGustiness);
            n = vRMLNodeType.getFieldIndex("speed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpeed = vRMLFieldData.floatValue;
            ((WindParticleFunction)this.particleFunction).setSpeed(this.vfSpeed);
            n = vRMLNodeType.getFieldIndex("turbulence");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTurbulence = vRMLFieldData.floatValue;
            ((WindParticleFunction)this.particleFunction).setTurbulence(this.vfTurbulence);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfDirection;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfGustiness;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfTurbulence;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfDirection, 3);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfGustiness);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfSpeed);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfTurbulence);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setGustiness(f);
                break;
            }
            case 5: {
                this.setSpeed(f);
                break;
            }
            case 4: {
                this.setTurbulence(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setDirection(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setDirection(float[] fArray) {
        this.vfDirection[0] = fArray[0];
        this.vfDirection[1] = fArray[1];
        this.vfDirection[2] = fArray[2];
        ((WindParticleFunction)this.particleFunction).setDirection(this.vfDirection[0], this.vfDirection[1], this.vfDirection[2]);
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setSpeed(float f) throws InvalidFieldValueException {
        this.vfSpeed = f;
        ((WindParticleFunction)this.particleFunction).setSpeed(this.vfSpeed);
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setGustiness(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_GUSTINESS_ERR + f);
        }
        this.vfGustiness = f;
        ((WindParticleFunction)this.particleFunction).setGustiness(this.vfGustiness);
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setTurbulence(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(TURBULENCE_RANGE_ERR + f);
        }
        this.vfTurbulence = f;
        ((WindParticleFunction)this.particleFunction).setTurbulence(this.vfTurbulence);
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BaseWindPhysicsModel.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseWindPhysicsModel.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseWindPhysicsModel.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        BaseWindPhysicsModel.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFFloat", "gustiness");
        BaseWindPhysicsModel.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFFloat", "speed");
        BaseWindPhysicsModel.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "turbulence");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("gustiness", n);
        fieldMap.put("set_gustiness", n);
        fieldMap.put("gustiness_changed", n);
        n = new Integer(4);
        fieldMap.put("turbulence", n);
        fieldMap.put("set_turbulence", n);
        fieldMap.put("turbulence_changed", n);
        n = new Integer(5);
        fieldMap.put("speed", n);
        fieldMap.put("set_speed", n);
        fieldMap.put("speed_changed", n);
    }
}

