/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public class BaseColorRGBA
extends BaseGeometricPropertyNode
implements VRMLColorNodeType {
    protected static final int FIELD_COLOR = 1;
    protected static final int LAST_COLOR_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float[] vfColor = FieldConstants.EMPTY_MFCOLORRGBA;
    protected int numColor;

    protected BaseColorRGBA() {
        super("ColorRGBA");
        this.hasChanged = new boolean[2];
    }

    protected BaseColorRGBA(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("color");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfColor = new float[vRMLFieldData.numElements * 4];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfColor, 0, vRMLFieldData.numElements * 4);
                this.numColor = vRMLFieldData.numElements * 4;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getNumColorComponents() {
        return 4;
    }

    public void setColor(float[] fArray, int n) {
        if (n > this.vfColor.length) {
            this.vfColor = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfColor, 0, n);
        this.numColor = n;
        if (!this.inSetup) {
            this.fireComponentChanged(1);
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public int getNumColors() {
        return this.numColor;
    }

    public void getColor(float[] fArray) {
        if (this.vfColor != null) {
            System.arraycopy(this.vfColor, 0, fArray, 0, this.numColor);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 9;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numColor / 4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfColor, this.numColor);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.setColor(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseColorRGBA.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseColorRGBA.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFColorRGBA", "color");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
    }
}

