/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.render;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseIndexedTriangleGeometryNode;

public abstract class BaseIndexedTriangleFanSet
extends BaseIndexedTriangleGeometryNode {
    private static final int NUM_FIELDS = 13;
    private static final String MAX_INDEX_COUNT_MSG = "Max coordIndex value > number of coords in IndexedTriangleFanSet";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    private int[][] vertexToFace;
    protected int[] fanCounts;
    protected int numFanCounts;
    private int maxIndexValue;
    protected int[] processedIndex;
    protected int numProcessedIndex;

    protected BaseIndexedTriangleFanSet() {
        super("IndexedTriangleFanSet");
        this.hasChanged = new boolean[13];
    }

    protected BaseIndexedTriangleFanSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 12) {
            return null;
        }
        return fieldDecl[n];
    }

    protected void updateIndexMaps() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.processedIndex == null || this.processedIndex.length < this.numIndex) {
            this.processedIndex = new int[this.numIndex];
        }
        this.numFanCounts = 1;
        for (n5 = 0; n5 < this.numIndex - 1; ++n5) {
            if (this.vfIndex[n5] != -1) continue;
            ++this.numFanCounts;
        }
        if (this.fanCounts == null || this.fanCounts.length < this.numFanCounts) {
            this.fanCounts = new int[this.numFanCounts];
        }
        n5 = 0;
        this.numProcessedIndex = 0;
        for (n4 = 0; n4 < this.numIndex; ++n4) {
            if (this.vfIndex[n4] == -1) {
                ++n5;
                continue;
            }
            this.processedIndex[this.numProcessedIndex++] = this.vfIndex[n4];
            int n6 = n5;
            this.fanCounts[n6] = this.fanCounts[n6] + 1;
        }
        this.maxIndexValue = 0;
        for (n4 = 0; n4 < this.numProcessedIndex; ++n4) {
            if (this.processedIndex[n4] <= this.maxIndexValue) continue;
            this.maxIndexValue = this.processedIndex[n4];
        }
        if (this.vfCoord != null && (this.maxIndexValue + 1) * 3 > this.vfCoord.getNumPoints()) {
            this.errorReporter.warningReport(MAX_INDEX_COUNT_MSG, null);
        }
        if (this.vertexToFace == null || this.vertexToFace.length < this.maxIndexValue + 1) {
            this.vertexToFace = new int[this.maxIndexValue + 1][];
        }
        int[] nArray = new int[this.maxIndexValue + 1];
        int n7 = 0;
        for (n3 = 0; n3 < this.numFanCounts; ++n3) {
            n2 = this.processedIndex[n7];
            nArray[n2] = this.fanCounts[n3] - 2;
            for (n = 1; n < this.fanCounts[n3] - 1; ++n) {
                int n8 = this.processedIndex[n7 + n];
                nArray[n8] = nArray[n8] + 1;
                int n9 = this.processedIndex[n7 + n + 1];
                nArray[n9] = nArray[n9] + 1;
            }
            n7 += this.fanCounts[n3];
        }
        for (n3 = 0; n3 < this.maxIndexValue + 1; ++n3) {
            if (this.vertexToFace[n3] != null && this.vertexToFace[n3].length == nArray[n3]) continue;
            this.vertexToFace[n3] = new int[nArray[n3]];
        }
        for (n3 = 0; n3 < this.maxIndexValue + 1; ++n3) {
            nArray[n3] = 0;
        }
        n3 = 0;
        n7 = 0;
        for (n2 = 0; n2 < this.numFanCounts; ++n2) {
            n = this.processedIndex[n7];
            int n10 = nArray[n];
            for (int i = 0; i < this.fanCounts[n2] - 2; ++i) {
                this.vertexToFace[n][n10] = n3;
                int n11 = n;
                nArray[n11] = nArray[n11] + 1;
                int n12 = this.processedIndex[n7 + 1];
                int n13 = this.processedIndex[n7 + 2];
                this.vertexToFace[n12][nArray[n12]] = n3;
                this.vertexToFace[n13][nArray[n13]] = n3++;
                int n14 = n12;
                nArray[n14] = nArray[n14] + 1;
                int n15 = n13;
                nArray[n15] = nArray[n15] + 1;
                ++n7;
            }
            n7 += 2;
        }
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[13];
        fieldMap = new HashMap(39);
        BaseIndexedTriangleFanSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseIndexedTriangleFanSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseIndexedTriangleFanSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseIndexedTriangleFanSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseIndexedTriangleFanSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseIndexedTriangleFanSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseIndexedTriangleFanSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseIndexedTriangleFanSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseIndexedTriangleFanSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        BaseIndexedTriangleFanSet.fieldDecl[11] = new VRMLFieldDeclaration(2, "MFInt32", "index");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
        fieldMap.put("index", new Integer(11));
        fieldMap.put("set_Index", new Integer(12));
    }
}

