/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.GeomBox;
import org.odejava.GeomCappedCylinder;
import org.odejava.GeomCone;
import org.odejava.GeomSphere;
import org.odejava.GeomTriMesh;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseCollidableNode;

public abstract class BaseCollidableShape
extends BaseCollidableNode {
    protected static final int FIELD_SHAPE = 6;
    protected static final int LAST_SHAPE_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    protected static final String SHAPE_PROTO_MSG = "shape field proto value does not describe a Shape node.";
    protected static final String SHAPE_NODE_MSG = "shape field node value does not describe a Shape node.";
    private static final int[] nodeFields = new int[]{0, 6};
    private static VRMLFieldDeclaration[] fieldDecl = new VRMLFieldDeclaration[7];
    private static HashMap fieldMap = new HashMap(21);
    protected VRMLProtoInstance pShape;
    protected VRMLShapeNodeType vfShape;

    public BaseCollidableShape() {
        super("CollidableShape");
        this.hasChanged = new boolean[7];
    }

    public BaseCollidableShape(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLNBodyCollidableNodeType)vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        if (this.pShape != null) {
            this.pShape.setupFinished();
        } else if (this.vfShape != null) {
            this.vfShape.setupFinished();
        }
        this.createODEGeom();
        super.setupFinished();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 6: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pShape != null ? this.pShape : this.vfShape;
                this.fieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        switch (n) {
            case 6: {
                this.setShape(vRMLNodeType2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setShape(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLShapeNodeType vRMLShapeNodeType;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("You have attempted to write to an initializeOnly field:  shape");
        }
        Object object = this.pShape != null ? this.pShape : this.vfShape;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLShapeNodeType)) {
                throw new InvalidFieldValueException(SHAPE_PROTO_MSG);
            }
            vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType2;
            this.pShape = (VRMLProtoInstance)vRMLNodeType;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLShapeNodeType)) {
                throw new InvalidFieldValueException(SHAPE_NODE_MSG);
            }
            this.pShape = null;
            vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType;
        }
        this.vfShape = vRMLShapeNodeType;
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
        }
    }

    private void createODEGeom() {
        Object object;
        if (this.vfShape == null) {
            return;
        }
        VRMLNodeType vRMLNodeType = this.vfShape.getGeometry();
        if (vRMLNodeType == null) {
            return;
        }
        VRMLGeometryNodeType vRMLGeometryNodeType = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            object = ((VRMLProtoInstance)this.vfShape).getImplementationNode();
            while (object != null && object instanceof VRMLProtoInstance) {
                object = ((VRMLProtoInstance)object).getImplementationNode();
            }
            if (object == null || !(object instanceof VRMLGeometryNodeType)) {
                return;
            }
            vRMLGeometryNodeType = (VRMLGeometryNodeType)object;
        } else {
            vRMLGeometryNodeType = (VRMLGeometryNodeType)vRMLNodeType;
        }
        object = vRMLGeometryNodeType.getVRMLNodeName();
        if (((String)object).equals("Box")) {
            int n = vRMLGeometryNodeType.getFieldIndex("size");
            VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            this.odeGeom = new GeomBox(vRMLFieldData.floatArrayValue[0], vRMLFieldData.floatArrayValue[1], vRMLFieldData.floatArrayValue[2]);
        } else if (((String)object).equals("Sphere")) {
            int n = vRMLGeometryNodeType.getFieldIndex("radius");
            VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            this.odeGeom = new GeomSphere(vRMLFieldData.floatValue);
        } else if (((String)object).equals("Cone")) {
            int n = vRMLGeometryNodeType.getFieldIndex("bottomRadius");
            VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            float f = vRMLFieldData.floatValue;
            n = vRMLGeometryNodeType.getFieldIndex("height");
            vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            this.odeGeom = new GeomCone(f, vRMLFieldData.floatValue);
        } else if (((String)object).equals("Cylinder")) {
            int n = vRMLGeometryNodeType.getFieldIndex("radius");
            VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            float f = vRMLFieldData.floatValue;
            n = vRMLGeometryNodeType.getFieldIndex("height");
            vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
            this.odeGeom = new GeomCappedCylinder(f, vRMLFieldData.floatValue);
        } else if (((String)object).equals("ElevationGrid")) {
            System.out.println("CollidableShape does not handle ElevationGrid proxy yet");
        } else if (!((String)object).equals("IndexedFaceSet")) {
            if (((String)object).equals("TriangleSet")) {
                int n = vRMLGeometryNodeType.getFieldIndex("coord");
                VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n);
                VRMLNodeType vRMLNodeType2 = (VRMLNodeType)vRMLFieldData.nodeValue;
                n = vRMLNodeType2.getFieldIndex("point");
                vRMLFieldData = vRMLNodeType2.getFieldValue(n);
                this.odeGeom = new GeomTriMesh(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements);
            } else if (((String)object).equals("TriangleStripSet") || ((String)object).equals("TriangleFanSet") || ((String)object).equals("IndexedTriangleSet") || ((String)object).equals("IndexedTriangleStripSet") || ((String)object).equals("IndexedTriangleFanSet")) {
                System.out.println("CollidableShape does not handle triangle data proxy yet");
            }
        }
    }

    static {
        BaseCollidableShape.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseCollidableShape.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxSize");
        BaseCollidableShape.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec3f", "bboxCenter");
        BaseCollidableShape.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFNode", "shape");
        BaseCollidableShape.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        BaseCollidableShape.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFRotation", "rotation");
        BaseCollidableShape.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(5);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
        n = new Integer(3);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(4);
        fieldMap.put("rotation", n);
        fieldMap.put("set_rotation", n);
        fieldMap.put("rotation_changed", n);
        fieldMap.put("bboxCenter", new Integer(2));
        fieldMap.put("bboxSize", new Integer(1));
        fieldMap.put("shape", new Integer(6));
    }
}

