/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.JointHinge2;
import org.odejava.World;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseDoubleAxisHingeJoint
extends BaseJointNode {
    protected static final int FIELD_ANCHOR_POINT = 4;
    protected static final int FIELD_AXIS1 = 5;
    protected static final int FIELD_AXIS2 = 6;
    protected static final int FIELD_BODY1_ANCHOR_POINT = 7;
    protected static final int FIELD_BODY2_ANCHOR_POINT = 8;
    protected static final int FIELD_ANGULAR_VELOCITY1 = 9;
    protected static final int FIELD_ANGULAR_VELOCITY2 = 10;
    protected static final int FIELD_BODY1_AXIS = 11;
    protected static final int FIELD_BODY2_AXIS = 12;
    protected static final int FIELD_MIN_ANGLE1 = 13;
    protected static final int FIELD_MAX_ANGLE1 = 14;
    protected static final int FIELD_MAX_TORQUE1 = 15;
    protected static final int FIELD_MAX_TORQUE2 = 16;
    protected static final int FIELD_HINGE1_ANGLE = 17;
    protected static final int FIELD_HINGE2_ANGLE = 18;
    protected static final int FIELD_HINGE1_ANGLE_RATE = 19;
    protected static final int FIELD_HINGE2_ANGLE_RATE = 20;
    protected static final int FIELD_STOP_BOUNCE1 = 21;
    protected static final int FIELD_STOP_ERROR_CORRECTION1 = 22;
    protected static final int FIELD_STOP_CFM1 = 23;
    protected static final int FIELD_SUSPENSION_FORCE = 24;
    protected static final int FIELD_SUSPENSION_ERP = 25;
    protected static final int LAST_INDEX = 25;
    private static final int NUM_FIELDS = 26;
    protected static final String MIN_ANGLE1_MSG = "The minAngle1 value is out of the required range [-pi,pi]: ";
    protected static final String MAX_ANGLE1_MSG = "The maxAngle1 value is out of the required range [-pi,pi]: ";
    protected static final String BOUNCE1_RANGE_MSG = "The stopBounce1 value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR1_RANGE_MSG = "The stopErrorCorrection1 value is out of the required range [0,1]: ";
    protected static final String STOP_CFM1_NEG_MSG = "The stopConstantForceMix1 value is negative: ";
    protected static final String SUSP_NEG_MSG = "The suspensionForce value is negative: ";
    protected static final String SUSP_ERROR_RANGE_MSG = "The suspensionErrorCorrection value is out of the required range [0,1]: ";
    private static final String AP1_WRITE_MSG = "body1AnchorPoint is outputOnly and cannot be set";
    private static final String AP2_WRITE_MSG = "body2AnchorPoint is outputOnly and cannot be set";
    private static final String AX1_WRITE_MSG = "body1Axis is outputOnly and cannot be set";
    private static final String AX2_WRITE_MSG = "body2Axis is outputOnly and cannot be set";
    private static final String HA1_WRITE_MSG = "hinge1Angle is outputOnly and cannot be set";
    private static final String HA2_WRITE_MSG = "hinge2Angle is outputOnly and cannot be set";
    private static final String HAR1_WRITE_MSG = "hinge1AngleRate is outputOnly and cannot be set";
    private static final String HAR2_WRITE_MSG = "hinge2AngleRate is outputOnly and cannot be set";
    private static final int[] outputFields;
    private static final int[] nodeFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    protected float[] vfAnchorPoint = new float[3];
    protected float[] vfBody1AnchorPoint;
    protected float[] vfBody2AnchorPoint;
    protected float[] vfAxis1 = new float[3];
    protected float[] vfAxis2 = new float[3];
    protected float[] vfBody1Axis;
    protected float[] vfBody2Axis;
    protected float vfDesiredAngularVelocity1;
    protected float vfDesiredAngularVelocity2;
    protected float vfMaxTorque1;
    protected float vfMaxTorque2;
    protected float vfMinAngle1 = (float)(-Math.PI);
    protected float vfMaxAngle1 = (float)Math.PI;
    protected float vfHinge1Angle;
    protected float vfHinge2Angle;
    protected float vfHinge1AngleRate;
    protected float vfHinge2AngleRate;
    protected float vfStopBounce1 = 0.0f;
    protected float vfStopErrorCorrection1 = 0.8f;
    protected float vfStopConstantForceMix1 = 0.001f;
    protected float vfSuspensionForce;
    protected float vfSuspensionErrorCorrection = 0.8f;
    protected JointHinge2 odeJoint;

    public BaseDoubleAxisHingeJoint() {
        super("DoubleAxisHingeJoint");
        this.vfBody1AnchorPoint = new float[3];
        this.vfBody2AnchorPoint = new float[3];
        this.vfBody1Axis = new float[3];
        this.vfBody2Axis = new float[3];
        this.hasChanged = new boolean[26];
    }

    public BaseDoubleAxisHingeJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("anchorPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnchorPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAnchorPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAnchorPoint[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis1[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis1[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis1[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis2");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis2[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis2[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis2[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("desiredAngularVelocity1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDesiredAngularVelocity1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("desiredAngularVelocity2");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDesiredAngularVelocity2 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxTorque1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxTorque1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxTorque2");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxTorque2 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("minAngle1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinAngle1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("maxAngle1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxAngle1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopBounce1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopBounce1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopErrorCorrection1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopErrorCorrection1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stopConstantForceMix1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStopConstantForceMix1 = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("suspensionForce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSuspensionForce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("suspensionErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSuspensionErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        if (this.odeJoint == null) {
            return;
        }
        block10: for (int i = 0; i < this.numOutputIndices; ++i) {
            switch (this.outputIndices[i]) {
                case 7: {
                    this.odeJoint.getAnchor(this.vfBody1AnchorPoint);
                    this.hasChanged[7] = true;
                    this.fireFieldChanged(7);
                    continue block10;
                }
                case 8: {
                    this.odeJoint.getAnchor2(this.vfBody2AnchorPoint);
                    this.hasChanged[8] = true;
                    this.fireFieldChanged(8);
                    continue block10;
                }
                case 11: {
                    this.odeJoint.getAxis1(this.vfBody1Axis);
                    this.hasChanged[11] = true;
                    this.fireFieldChanged(11);
                    continue block10;
                }
                case 12: {
                    this.odeJoint.getAxis2(this.vfBody2Axis);
                    this.hasChanged[12] = true;
                    this.fireFieldChanged(12);
                    continue block10;
                }
                case 17: {
                    this.vfHinge1Angle = this.odeJoint.getAngle1();
                    this.hasChanged[17] = true;
                    this.fireFieldChanged(17);
                    continue block10;
                }
                case 18: {
                    this.hasChanged[18] = true;
                    this.fireFieldChanged(18);
                    continue block10;
                }
                case 19: {
                    this.vfHinge1AngleRate = this.odeJoint.getAngle1Rate();
                    this.hasChanged[19] = true;
                    this.fireFieldChanged(19);
                    continue block10;
                }
                case 20: {
                    this.vfHinge2AngleRate = this.odeJoint.getAngle2Rate();
                    this.hasChanged[20] = true;
                    this.fireFieldChanged(20);
                }
            }
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointHinge2(world, jointGroup);
            Body body = null;
            Body body2 = null;
            if (this.vfBody1 != null) {
                body = this.vfBody1.getODEBody();
            }
            if (this.vfBody2 != null) {
                body2 = this.vfBody2.getODEBody();
            }
            if (body == null && body2 != null || body != null && body2 == null) {
                this.errorReporter.warningReport("Double Axis Hinge requires two non-null bodies", null);
                return;
            }
            this.odeJoint.attach(body, body2);
            this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
            this.odeJoint.setAxis1(this.vfAxis1[0], this.vfAxis1[1], this.vfAxis1[2]);
            this.odeJoint.setAxis2(this.vfAxis2[0], this.vfAxis2[1], this.vfAxis2[2]);
            this.odeJoint.setMinAngleStop(this.vfMinAngle1);
            this.odeJoint.setMaxAngleStop(this.vfMaxAngle1);
            this.odeJoint.setMaxTorque1(this.vfMaxTorque1);
            this.odeJoint.setMaxTorque2(this.vfMaxTorque2);
            this.odeJoint.setDesiredAngularVelocity1(this.vfDesiredAngularVelocity1);
            this.odeJoint.setDesiredAngularVelocity2(this.vfDesiredAngularVelocity2);
            this.odeJoint.setStopBounce(this.vfStopBounce1);
            this.odeJoint.setStopERP(this.vfStopErrorCorrection1);
            this.odeJoint.setStopCFM(this.vfStopConstantForceMix1);
            this.odeJoint.setSuspensionERP(this.vfSuspensionErrorCorrection);
            this.odeJoint.setSuspensionCFM(this.vfSuspensionForce);
        } else {
            this.odeJoint.delete();
        }
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            if (body == null && body2 != null || body != null && body2 == null) {
                this.errorReporter.warningReport("Double Axis Hinge requires two non-null bodies", null);
                return;
            }
            this.odeJoint.attach(body, body2);
        }
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (this.odeJoint != null) {
            if (body == null && body2 != null || body != null && body2 == null) {
                this.errorReporter.warningReport("Double Axis Hinge requires two non-null bodies", null);
                return;
            }
            this.odeJoint.attach(body, body2);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.odeJoint == null) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        if (body == null && body2 != null || body != null && body2 == null) {
            this.errorReporter.warningReport("Double Axis Hinge requires two non-null bodies", null);
            return;
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
        this.odeJoint.setMinAngleStop(this.vfMinAngle1);
        this.odeJoint.setMaxAngleStop(this.vfMaxAngle1);
        this.odeJoint.setMaxTorque1(this.vfMaxTorque1);
        this.odeJoint.setMaxTorque2(this.vfMaxTorque2);
        this.odeJoint.setDesiredAngularVelocity1(this.vfDesiredAngularVelocity1);
        this.odeJoint.setDesiredAngularVelocity2(this.vfDesiredAngularVelocity2);
        this.odeJoint.setStopBounce(this.vfStopBounce1);
        this.odeJoint.setStopERP(this.vfStopErrorCorrection1);
        this.odeJoint.setStopCFM(this.vfStopConstantForceMix1);
        this.odeJoint.setSuspensionERP(this.vfSuspensionErrorCorrection);
        this.odeJoint.setSuspensionCFM(this.vfSuspensionForce);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 25) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAnchorPoint;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAxis1;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAxis2;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDesiredAngularVelocity1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDesiredAngularVelocity2;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBody1AnchorPoint;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBody2AnchorPoint;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBody1Axis;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBody2Axis;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMinAngle1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 14: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxAngle1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 17: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfHinge1Angle;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 18: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfHinge2Angle;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxTorque1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 16: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxTorque2;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 19: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfHinge1AngleRate;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 20: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfHinge2AngleRate;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 21: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfStopBounce1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 22: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfStopErrorCorrection1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 23: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfStopConstantForceMix1;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 24: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfSuspensionForce;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 25: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfSuspensionErrorCorrection;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAnchorPoint, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfAxis1, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfAxis2, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfBody1AnchorPoint, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfBody2AnchorPoint, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfBody1Axis, 3);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfBody2Axis, 3);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfMinAngle1);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfMaxAngle1);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfMaxTorque1);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfMaxTorque2);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfDesiredAngularVelocity1);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfDesiredAngularVelocity2);
                    break;
                }
                case 17: {
                    vRMLNodeType.setValue(n2, this.vfHinge1Angle);
                    break;
                }
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfHinge2Angle);
                    break;
                }
                case 19: {
                    vRMLNodeType.setValue(n2, this.vfHinge1AngleRate);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfHinge2AngleRate);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfStopBounce1);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfStopErrorCorrection1);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfStopConstantForceMix1);
                    break;
                }
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfSuspensionForce);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfSuspensionErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("SingleAxis1Joint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("SingleAxis1Joint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 13: {
                this.setMinAngle1(f);
                break;
            }
            case 14: {
                this.setMaxAngle1(f);
                break;
            }
            case 15: {
                this.setMaxTorque1(f);
                break;
            }
            case 16: {
                this.setMaxTorque2(f);
                break;
            }
            case 9: {
                this.setDesiredAngularVelocity1(f);
                break;
            }
            case 10: {
                this.setDesiredAngularVelocity2(f);
                break;
            }
            case 21: {
                this.setStopBounce1(f);
                break;
            }
            case 22: {
                this.setStopErrorCorrection1(f);
                break;
            }
            case 23: {
                this.setStopConstantForceMix1(f);
                break;
            }
            case 17: {
                throw new InvalidFieldAccessException(HA1_WRITE_MSG);
            }
            case 18: {
                throw new InvalidFieldAccessException(HA2_WRITE_MSG);
            }
            case 19: {
                throw new InvalidFieldAccessException(HAR1_WRITE_MSG);
            }
            case 20: {
                throw new InvalidFieldAccessException(HAR2_WRITE_MSG);
            }
            case 24: {
                this.setSuspensionForce(f);
                break;
            }
            case 25: {
                this.setSuspensionErrorCorrection(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAnchorPoint(fArray);
                break;
            }
            case 5: {
                this.setAxis1(fArray);
                break;
            }
            case 6: {
                this.setAxis2(fArray);
                break;
            }
            case 7: {
                throw new InvalidFieldAccessException(AP1_WRITE_MSG);
            }
            case 8: {
                throw new InvalidFieldAccessException(AP2_WRITE_MSG);
            }
            case 11: {
                throw new InvalidFieldAccessException(AX1_WRITE_MSG);
            }
            case 12: {
                throw new InvalidFieldAccessException(AX2_WRITE_MSG);
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setMinAngle1(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(MIN_ANGLE1_MSG + f);
        }
        this.vfMinAngle1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMinAngleStop(f);
            }
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void setMaxAngle1(float f) throws InvalidFieldValueException {
        if (f < (float)(-Math.PI) || f > (float)Math.PI) {
            throw new InvalidFieldValueException(MAX_ANGLE1_MSG + f);
        }
        this.vfMaxAngle1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMaxAngleStop(f);
            }
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setMaxTorque1(float f) {
        this.vfMaxTorque1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMaxTorque1(f);
            }
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void setMaxTorque2(float f) {
        this.vfMaxTorque2 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setMaxTorque2(f);
            }
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    private void setDesiredAngularVelocity1(float f) {
        this.vfDesiredAngularVelocity1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setDesiredAngularVelocity1(f);
            }
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setDesiredAngularVelocity2(float f) {
        this.vfDesiredAngularVelocity2 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setDesiredAngularVelocity2(f);
            }
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setAnchorPoint(float[] fArray) {
        this.vfAnchorPoint[0] = fArray[0];
        this.vfAnchorPoint[1] = fArray[1];
        this.vfAnchorPoint[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAnchor(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setAxis1(float[] fArray) {
        this.vfAxis1[0] = fArray[0];
        this.vfAxis1[1] = fArray[1];
        this.vfAxis1[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis1(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setAxis2(float[] fArray) {
        this.vfAxis2[0] = fArray[0];
        this.vfAxis2[1] = fArray[1];
        this.vfAxis2[2] = fArray[2];
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setAxis2(fArray[0], fArray[1], fArray[2]);
            }
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setStopBounce1(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE1_RANGE_MSG + f);
        }
        this.vfStopBounce1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setStopBounce(f);
            }
            this.hasChanged[21] = true;
            this.fireFieldChanged(21);
        }
    }

    private void setStopErrorCorrection1(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR1_RANGE_MSG + f);
        }
        this.vfStopErrorCorrection1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setStopERP(f);
            }
            this.hasChanged[22] = true;
            this.fireFieldChanged(22);
        }
    }

    private void setStopConstantForceMix1(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(STOP_CFM1_NEG_MSG + f);
        }
        this.vfStopConstantForceMix1 = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setStopCFM(f);
            }
            this.hasChanged[23] = true;
            this.fireFieldChanged(23);
        }
    }

    private void setSuspensionForce(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(SUSP_NEG_MSG + f);
        }
        this.vfSuspensionForce = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setSuspensionCFM(f);
            }
            this.hasChanged[24] = true;
            this.fireFieldChanged(24);
        }
    }

    private void setSuspensionErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(SUSP_ERROR_RANGE_MSG + f);
        }
        this.vfSuspensionErrorCorrection = f;
        if (!this.inSetup) {
            if (this.odeJoint != null) {
                this.odeJoint.setSuspensionERP(f);
            }
            this.hasChanged[25] = true;
            this.fireFieldChanged(25);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{7, 8, 11, 12, 17, 18, 19, 20};
        fieldDecl = new VRMLFieldDeclaration[26];
        fieldMap = new HashMap(78);
        BaseDoubleAxisHingeJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseDoubleAxisHingeJoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "anchorPoint");
        BaseDoubleAxisHingeJoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "axis1");
        BaseDoubleAxisHingeJoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "axis2");
        BaseDoubleAxisHingeJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseDoubleAxisHingeJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseDoubleAxisHingeJoint.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFString", "mustOutput");
        BaseDoubleAxisHingeJoint.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFVec3f", "body1AnchorPoint");
        BaseDoubleAxisHingeJoint.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFVec3f", "body2AnchorPoint");
        BaseDoubleAxisHingeJoint.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFVec3f", "body1Axis");
        BaseDoubleAxisHingeJoint.fieldDecl[12] = new VRMLFieldDeclaration(4, "SFVec3f", "body2Axis");
        BaseDoubleAxisHingeJoint.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFFloat", "minAngle1");
        BaseDoubleAxisHingeJoint.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "maxAngle1");
        BaseDoubleAxisHingeJoint.fieldDecl[21] = new VRMLFieldDeclaration(3, "SFFloat", "stopBounce1");
        BaseDoubleAxisHingeJoint.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFFloat", "maxTorque1");
        BaseDoubleAxisHingeJoint.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFFloat", "maxTorque2");
        BaseDoubleAxisHingeJoint.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFFloat", "desiredAngularVelocity1");
        BaseDoubleAxisHingeJoint.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "desiredAngularVelocity2");
        BaseDoubleAxisHingeJoint.fieldDecl[17] = new VRMLFieldDeclaration(4, "SFFloat", "hinge1Angle");
        BaseDoubleAxisHingeJoint.fieldDecl[18] = new VRMLFieldDeclaration(4, "SFFloat", "hinge2Angle");
        BaseDoubleAxisHingeJoint.fieldDecl[19] = new VRMLFieldDeclaration(4, "SFFloat", "hinge1AngleRate");
        BaseDoubleAxisHingeJoint.fieldDecl[20] = new VRMLFieldDeclaration(4, "SFFloat", "hinge2AngleRate");
        BaseDoubleAxisHingeJoint.fieldDecl[22] = new VRMLFieldDeclaration(3, "SFFloat", "stopErrorCorrection1");
        BaseDoubleAxisHingeJoint.fieldDecl[23] = new VRMLFieldDeclaration(3, "SFFloat", "stopConstantForceMix1");
        BaseDoubleAxisHingeJoint.fieldDecl[24] = new VRMLFieldDeclaration(3, "SFFloat", "suspensionForce");
        BaseDoubleAxisHingeJoint.fieldDecl[25] = new VRMLFieldDeclaration(3, "SFFloat", "suspensionErrorCorrection");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("anchorPoint", n);
        fieldMap.put("set_anchorPoint", n);
        fieldMap.put("anchorPoint_changed", n);
        n = new Integer(5);
        fieldMap.put("axis1", n);
        fieldMap.put("set_axis1", n);
        fieldMap.put("axis1_changed", n);
        n = new Integer(6);
        fieldMap.put("axis2", n);
        fieldMap.put("set_axis2", n);
        fieldMap.put("axis2_changed", n);
        n = new Integer(3);
        fieldMap.put("mustOutput", n);
        fieldMap.put("set_mustOutput", n);
        fieldMap.put("mustOutput_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(9);
        fieldMap.put("desiredAngularVelocity1", n);
        fieldMap.put("set_desiredAngularVelocity1", n);
        fieldMap.put("desiredAngularVelocity1_changed", n);
        n = new Integer(10);
        fieldMap.put("desiredAngularVelocity2", n);
        fieldMap.put("set_desiredAngularVelocity2", n);
        fieldMap.put("desiredAngularVelocity2_changed", n);
        n = new Integer(15);
        fieldMap.put("maxTorque1", n);
        fieldMap.put("set_maxTorque1", n);
        fieldMap.put("maxTorque1_changed", n);
        n = new Integer(16);
        fieldMap.put("maxTorque2", n);
        fieldMap.put("set_maxTorque2", n);
        fieldMap.put("maxTorque2_changed", n);
        n = new Integer(13);
        fieldMap.put("minAngle1", n);
        fieldMap.put("set_minAngle1", n);
        fieldMap.put("minAngle1_changed", n);
        n = new Integer(14);
        fieldMap.put("maxAngle1", n);
        fieldMap.put("set_maxAngle1", n);
        fieldMap.put("maxAngle1_changed", n);
        n = new Integer(21);
        fieldMap.put("stopBounce1", n);
        fieldMap.put("set_stopBounce1", n);
        fieldMap.put("stopBounce1_changed", n);
        n = new Integer(22);
        fieldMap.put("stopErrorCorrection1", n);
        fieldMap.put("set_stopErrorCorrection1", n);
        fieldMap.put("stopErrorCorrection1_changed", n);
        n = new Integer(23);
        fieldMap.put("stopConstantForceMix1", n);
        fieldMap.put("set_stopConstantForceMix1", n);
        fieldMap.put("stopConstantForceMix1_changed", n);
        n = new Integer(24);
        fieldMap.put("suspensionForce", n);
        fieldMap.put("set_suspensionForce", n);
        fieldMap.put("suspensionForce_changed", n);
        n = new Integer(25);
        fieldMap.put("suspensionErrorCorrection", n);
        fieldMap.put("set_suspensionErrorCorrection", n);
        fieldMap.put("suspensionErrorCorrection_changed", n);
        fieldMap.put("body1AnchorPoint", new Integer(7));
        fieldMap.put("body2AnchorPoint", new Integer(8));
        fieldMap.put("body1Axis", new Integer(11));
        fieldMap.put("body2Axis", new Integer(12));
        fieldMap.put("hinge1Angle", new Integer(17));
        fieldMap.put("hinge2Angle", new Integer(18));
        fieldMap.put("hinge1AngleRate", new Integer(19));
        fieldMap.put("hinge2AngleRate", new Integer(20));
    }
}

