/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.odejava.Body;
import org.odejava.PlaceableGeom;
import org.odejava.World;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNBodyCollidableNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLRigidBodyNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseRigidBody
extends AbstractNode
implements VRMLRigidBodyNodeType {
    protected static final int FIELD_ANGULAR_DAMPING_FACTOR = 1;
    protected static final int FIELD_ANGULAR_VELOCITY = 2;
    protected static final int FIELD_AUTO_DAMP = 3;
    protected static final int FIELD_AUTO_DISABLE = 4;
    protected static final int FIELD_CENTER_OF_MASS = 5;
    protected static final int FIELD_DISABLE_TIME = 6;
    protected static final int FIELD_DISABLE_ANGULAR_SPEED = 7;
    protected static final int FIELD_DISABLE_LINEAR_SPEED = 8;
    protected static final int FIELD_ENABLED = 9;
    protected static final int FIELD_FINITE_ROTATION_AXIS = 10;
    protected static final int FIELD_FORCES = 11;
    protected static final int FIELD_GEOMETRY = 12;
    protected static final int FIELD_INERTIA = 13;
    protected static final int FIELD_LINEAR_DAMPING_FACTOR = 14;
    protected static final int FIELD_LINEAR_VELOCITY = 15;
    protected static final int FIELD_MASS = 16;
    protected static final int FIELD_MASS_DENSITY_MODEL = 17;
    protected static final int FIELD_ORIENTATION = 18;
    protected static final int FIELD_POSITION = 19;
    protected static final int FIELD_TORQUES = 20;
    protected static final int FIELD_USE_FINITE_ROTATION = 21;
    protected static final int FIELD_USE_GLOBAL_GRAVITY = 22;
    protected static final int LAST_BODY_INDEX = 22;
    private static final int NUM_FIELDS = 23;
    protected static final String MASS_TYPE_PROTO_MSG = "Proto does not describe a valid mass density object. Permitted values are Sphere, Box and Cone";
    protected static final String MASS_PROTO_MSG = "MassDensityModel proto does not describe a X3DGeometryNode object.";
    protected static final String MASS_NODE_MSG = "MassDensityModel node does not describe a X3DGeometryNode object.";
    protected static final String MASS_TYPE_MSG = "MassDensityModel describes a geometry node, but it is not one of the allowable types. Permitted values are Sphere, Box and Cone";
    protected static final String GEOM_NODE_MSG = "An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode";
    protected static final String GEOM_PROTO_MSG = "An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode";
    protected static final String DIS_ANG_VEL_RANGE_MSG = "The disableAngularSpeed value is out of the required range [0,inf): ";
    protected static final String DIS_LIN_VEL_RANGE_MSG = "The disableLinearSpeed value is out of the required range [0,inf): ";
    protected static final String NEG_MASS_MSG = "The mass value is negative or zero. Mass must be positive.";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private static HashSet validDensityTypes;
    protected float vfAngularDampingFactor = 0.001f;
    protected float[] vfAngularVelocity = new float[3];
    protected boolean vfAutoDamp = false;
    protected boolean vfAutoDisable = false;
    protected float[] vfCenterOfMass = new float[3];
    protected float vfDisableTime = 0.0f;
    protected float vfDisableAngularSpeed = 0.0f;
    protected float vfDisableLinearSpeed = 0.0f;
    protected boolean vfEnabled = true;
    protected float[] vfFiniteRotationAxis = new float[3];
    protected float[] vfForces = FieldConstants.EMPTY_MFVEC3F;
    protected int numForces;
    protected VRMLNodeType[] vfGeometry;
    protected int numGeometry;
    protected float[] vfInertia = new float[9];
    protected int numInertia;
    protected float vfLinearDampingFactor;
    protected float[] vfLinearVelocity;
    protected float vfMass;
    protected VRMLGeometryNodeType vfMassDensityModel;
    protected VRMLProtoInstance pMassDensityModel;
    protected float[] vfOrientation;
    protected float[] vfPosition;
    protected float[] vfTorques;
    protected int numTorques;
    protected boolean vfUseFiniteRotation;
    protected boolean vfUseGlobalGravity;
    private Body odeBody;
    private World odeWorld;
    private Vector3f positionTmp;
    private AxisAngle4f angleTmp;
    private Quat4f orientTmp;

    public BaseRigidBody() {
        super("RigidBody");
        this.vfInertia[0] = 1.0f;
        this.vfInertia[4] = 1.0f;
        this.vfInertia[8] = 1.0f;
        this.numInertia = 6;
        this.vfLinearVelocity = new float[3];
        this.vfLinearDampingFactor = 0.001f;
        this.vfMass = 1.0f;
        this.vfOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        this.vfPosition = new float[3];
        this.vfTorques = FieldConstants.EMPTY_MFVEC3F;
        this.vfUseFiniteRotation = false;
        this.vfUseGlobalGravity = true;
        this.hasChanged = new boolean[23];
        this.orientTmp = new Quat4f();
        this.angleTmp = new AxisAngle4f();
        this.positionTmp = new Vector3f();
    }

    public BaseRigidBody(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("angularVelocity");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAngularVelocity[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAngularVelocity[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAngularVelocity[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("angularDampingFactor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAngularDampingFactor = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("autoDamp");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAutoDamp = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("autoDisable");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAutoDisable = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("centerOfMass");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenterOfMass[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenterOfMass[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenterOfMass[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("disableAngularSpeed   ");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableAngularSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("disableLinearSpeed   ");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableLinearSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("disableTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableTime = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("finiteRotationAxis");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFiniteRotationAxis[0] = vRMLFieldData.floatArrayValue[0];
            this.vfFiniteRotationAxis[1] = vRMLFieldData.floatArrayValue[1];
            this.vfFiniteRotationAxis[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("forces");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfForces = new float[vRMLFieldData.numElements * 3];
                this.numForces = vRMLFieldData.numElements * 3;
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfForces, 0, vRMLFieldData.numElements * 3);
            }
            n = vRMLNodeType.getFieldIndex("inertia");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfInertia, 0, 9);
            n = vRMLNodeType.getFieldIndex("linearDampingFactor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinearDampingFactor = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("linearVelocity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfLinearVelocity[0] = vRMLFieldData.floatArrayValue[0];
            this.vfLinearVelocity[1] = vRMLFieldData.floatArrayValue[1];
            this.vfLinearVelocity[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("mass");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMass = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("orientation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfOrientation[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("position");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPosition[0] = vRMLFieldData.floatArrayValue[0];
            this.vfPosition[1] = vRMLFieldData.floatArrayValue[1];
            this.vfPosition[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("torques");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfTorques = new float[vRMLFieldData.numElements * 3];
                this.numTorques = vRMLFieldData.numElements * 3;
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfTorques, 0, vRMLFieldData.numElements * 3);
            }
            n = vRMLNodeType.getFieldIndex("useFiniteRotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUseFiniteRotation = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("useGlobalGravity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUseGlobalGravity = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setODEWorld(World world) {
        if (world != null) {
            this.odeBody = new Body(world);
            this.odeBody.setPosition(this.vfPosition[0], this.vfPosition[1], this.vfPosition[2]);
            this.odeBody.setAxisAndAngle(this.vfOrientation[0], this.vfOrientation[1], this.vfOrientation[2], this.vfOrientation[3]);
            this.odeBody.setLinearVel(this.vfLinearVelocity[0], this.vfLinearVelocity[1], this.vfLinearVelocity[2]);
            this.odeBody.setAngularVel(this.vfAngularVelocity[0], this.vfAngularVelocity[1], this.vfAngularVelocity[2]);
            this.odeBody.setFiniteRotationAxis(this.vfFiniteRotationAxis[0], this.vfFiniteRotationAxis[1], this.vfFiniteRotationAxis[2]);
            this.odeBody.setMassParameters(this.vfMass, this.vfCenterOfMass[0], this.vfCenterOfMass[1], this.vfCenterOfMass[2], this.vfInertia[0], this.vfInertia[4], this.vfInertia[8], this.vfInertia[1], this.vfInertia[2], this.vfInertia[5]);
            this.odeBody.setFiniteRotationMode(this.vfUseFiniteRotation ? 1 : 0);
            this.odeBody.setGravityMode(this.vfUseGlobalGravity ? 1 : 0);
            this.odeBody.setAngularVelocityDisableThreshold(this.vfDisableAngularSpeed);
            this.odeBody.setLinearVelocityDisableThreshold(this.vfDisableLinearSpeed);
            this.odeBody.setTimeDisableThreshold(this.vfDisableTime);
            this.odeBody.setAutoDisable(this.vfAutoDisable);
            this.odeBody.adjustMass(this.vfMass);
        }
        this.odeWorld = world;
    }

    public Body getODEBody() {
        return this.odeBody;
    }

    public void updateODEFromNode() {
        int n;
        int n2 = this.numForces / 3;
        for (n = 0; n < n2; ++n) {
            this.odeBody.addForce(this.vfForces[n * 3], this.vfForces[n * 3 + 1], this.vfForces[n * 3 + 2]);
        }
        n2 = this.numTorques / 3;
        for (n = 0; n < n2; ++n) {
            this.odeBody.addTorque(this.vfTorques[n * 3], this.vfTorques[n * 3 + 1], this.vfTorques[n * 3 + 2]);
        }
        if (this.vfAutoDamp) {
            if (this.vfLinearDampingFactor != 0.0f) {
                this.odeBody.addForce(this.vfLinearVelocity[0] * -this.vfLinearDampingFactor, this.vfLinearVelocity[1] * -this.vfLinearDampingFactor, this.vfLinearVelocity[2] * -this.vfLinearDampingFactor);
            }
            if (this.vfAngularDampingFactor != 0.0f) {
                this.odeBody.addTorque(this.vfAngularVelocity[0] * -this.vfAngularDampingFactor, this.vfAngularVelocity[1] * -this.vfAngularDampingFactor, this.vfAngularVelocity[2] * -this.vfAngularDampingFactor);
            }
        }
    }

    public void updateNodeFromODE() {
        if (!this.vfEnabled) {
            return;
        }
        this.odeBody.getPosition(this.positionTmp);
        this.vfPosition[0] = this.positionTmp.x;
        this.vfPosition[1] = this.positionTmp.y;
        this.vfPosition[2] = this.positionTmp.z;
        this.hasChanged[19] = true;
        this.fireFieldChanged(19);
        this.odeBody.getQuaternion(this.orientTmp);
        this.angleTmp.set(this.orientTmp);
        this.vfOrientation[0] = this.angleTmp.x;
        this.vfOrientation[1] = this.angleTmp.y;
        this.vfOrientation[2] = this.angleTmp.z;
        this.vfOrientation[3] = this.angleTmp.angle;
        this.hasChanged[18] = true;
        this.fireFieldChanged(18);
        this.odeBody.getLinearVel(this.positionTmp);
        this.vfLinearVelocity[0] = this.positionTmp.x;
        this.vfLinearVelocity[1] = this.positionTmp.y;
        this.vfLinearVelocity[2] = this.positionTmp.z;
        this.hasChanged[15] = true;
        this.fireFieldChanged(15);
        this.odeBody.getPosition(this.positionTmp);
        this.vfAngularVelocity[0] = this.positionTmp.x;
        this.vfAngularVelocity[1] = this.positionTmp.y;
        this.vfAngularVelocity[2] = this.positionTmp.z;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public int numGeometry() {
        return this.numGeometry;
    }

    public VRMLNodeType[] getGeometry() {
        return this.vfGeometry;
    }

    public void setGeometry(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        VRMLNodeType vRMLNodeType;
        int n2;
        if (!this.inSetup) {
            for (n2 = 0; n2 < this.numGeometry; ++n2) {
                if (this.vfGeometry[n2] == null || (vRMLNodeType = this.findODEGeometry(this.vfGeometry[n2])) == null) continue;
                this.odeBody.removeGeom((PlaceableGeom)vRMLNodeType);
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (vRMLNodeTypeArray[n2] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)vRMLNodeTypeArray[n2]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType == null || vRMLNodeType instanceof VRMLNBodyCollidableNodeType) continue;
                throw new InvalidFieldValueException("An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode");
            }
            if (vRMLNodeTypeArray[n2] instanceof VRMLNBodyCollidableNodeType || vRMLNodeTypeArray[n2] == null) continue;
            throw new InvalidFieldValueException("An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode");
        }
        if (this.vfGeometry == null || this.vfGeometry.length < n) {
            this.vfGeometry = new VRMLNodeType[n];
        }
        System.arraycopy(vRMLNodeTypeArray, 0, this.vfGeometry, 0, n);
        this.numGeometry = n;
        if (!this.inSetup) {
            for (n2 = 0; n2 < this.numGeometry; ++n2) {
                if (this.vfGeometry[n2] == null || (vRMLNodeType = this.findODEGeometry(this.vfGeometry[n2])) == null) continue;
                this.odeBody.addGeom((PlaceableGeom)vRMLNodeType);
            }
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    public VRMLNodeType getMassDensityModel() {
        if (this.pMassDensityModel != null) {
            return this.pMassDensityModel;
        }
        return this.vfMassDensityModel;
    }

    public void setMassDensityModel(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        String string = null;
        Object object = this.pMassDensityModel != null ? this.pMassDensityModel : this.vfMassDensityModel;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLGeometryNodeType)) {
                throw new InvalidFieldValueException(MASS_PROTO_MSG);
            }
            string = vRMLNodeType2.getVRMLNodeName();
            if (!validDensityTypes.contains((Object)string)) {
                throw new InvalidFieldValueException(MASS_TYPE_MSG);
            }
            this.pMassDensityModel = (VRMLProtoInstance)vRMLNodeType;
            this.vfMassDensityModel = (VRMLGeometryNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLGeometryNodeType) {
            string = vRMLNodeType.getVRMLNodeName();
            if (!validDensityTypes.contains((Object)string)) {
                throw new InvalidFieldValueException(MASS_TYPE_MSG);
            }
            this.pMassDensityModel = null;
            this.vfMassDensityModel = (VRMLGeometryNodeType)vRMLNodeType;
        } else {
            throw new InvalidFieldValueException(MASS_NODE_MSG);
        }
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (this.vfMassDensityModel != null) {
                this.vfMassDensityModel.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)this.vfMassDensityModel);
            }
            if (this.vfMassDensityModel != null) {
                if (string.equals("Box")) {
                    int n = this.vfMassDensityModel.getFieldIndex("size");
                    VRMLFieldData vRMLFieldData = this.vfMassDensityModel.getFieldValue(n);
                    float[] fArray = vRMLFieldData.floatArrayValue;
                    float f = fArray[0] * fArray[1] * fArray[2];
                    this.odeBody.setBoxMass(this.vfMass / f, fArray[0], fArray[1], fArray[2]);
                } else if (string.equals("Sphere")) {
                    int n = this.vfMassDensityModel.getFieldIndex("radius");
                    VRMLFieldData vRMLFieldData = this.vfMassDensityModel.getFieldValue(n);
                    float f = vRMLFieldData.floatValue;
                    this.odeBody.setSphereMass(this.vfMass / (f * f), f);
                } else {
                    System.out.println("RigidBody unhandled mass density model type object: " + string);
                }
            }
            this.hasChanged[17] = true;
            this.fireFieldChanged(17);
        }
    }

    public void setupFinished() {
        PlaceableGeom placeableGeom;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pMassDensityModel != null) {
            this.pMassDensityModel.setupFinished();
        } else if (this.vfMassDensityModel != null) {
            this.vfMassDensityModel.setupFinished();
        }
        this.odeBody.setPosition(this.vfPosition[0], this.vfPosition[1], this.vfPosition[2]);
        this.odeBody.setAxisAndAngle(this.vfOrientation[0], this.vfOrientation[1], this.vfOrientation[2], this.vfOrientation[3]);
        this.odeBody.setLinearVel(this.vfLinearVelocity[0], this.vfLinearVelocity[1], this.vfLinearVelocity[2]);
        this.odeBody.setAngularVel(this.vfAngularVelocity[0], this.vfAngularVelocity[1], this.vfAngularVelocity[2]);
        this.odeBody.setFiniteRotationMode(this.vfUseFiniteRotation ? 1 : 0);
        this.odeBody.setFiniteRotationAxis(this.vfFiniteRotationAxis[0], this.vfFiniteRotationAxis[1], this.vfFiniteRotationAxis[2]);
        this.odeBody.setGravityMode(this.vfUseGlobalGravity ? 1 : 0);
        this.odeBody.setAngularVelocityDisableThreshold(this.vfDisableAngularSpeed);
        this.odeBody.setLinearVelocityDisableThreshold(this.vfDisableLinearSpeed);
        this.odeBody.setTimeDisableThreshold(this.vfDisableTime);
        this.odeBody.setAutoDisable(this.vfAutoDisable);
        for (n = 0; n < this.numGeometry; ++n) {
            if (this.vfGeometry[n] == null) continue;
            this.vfGeometry[n].setupFinished();
            placeableGeom = this.findODEGeometry(this.vfGeometry[n]);
            if (placeableGeom == null) continue;
            this.odeBody.addGeom(placeableGeom);
        }
        if (this.vfMassDensityModel != null) {
            String string = this.vfMassDensityModel.getVRMLNodeName();
            if (string.equals("Box")) {
                n = this.vfMassDensityModel.getFieldIndex("size");
                placeableGeom = this.vfMassDensityModel.getFieldValue(n);
                float[] fArray = placeableGeom.floatArrayValue;
                float f = fArray[0] * fArray[1] * fArray[2];
                this.odeBody.setBoxMass(this.vfMass / f, fArray[0], fArray[1], fArray[2]);
            } else if (string.equals("Sphere")) {
                n = this.vfMassDensityModel.getFieldIndex("radius");
                placeableGeom = this.vfMassDensityModel.getFieldValue(n);
                float f = placeableGeom.floatValue;
                float f2 = (float)(4.1887902047863905 * (double)f * (double)f * (double)f);
                this.odeBody.setSphereMass(this.vfMass / f2, f);
            }
        } else {
            this.odeBody.setMassParameters(this.vfMass, this.vfCenterOfMass[0], this.vfCenterOfMass[1], this.vfCenterOfMass[2], this.vfInertia[0], this.vfInertia[4], this.vfInertia[8], this.vfInertia[1], this.vfInertia[2], this.vfInertia[5]);
        }
        this.odeBody.adjustMass(this.vfMass);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 22) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 82;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfAngularVelocity;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfAngularDampingFactor;
                this.fieldData.dataType = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfAutoDamp;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfAutoDisable;
                this.fieldData.dataType = 1;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfCenterOfMass;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableAngularSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableLinearSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableTime;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfEnabled;
                this.fieldData.dataType = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfFiniteRotationAxis;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfForces;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numForces / 3;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.vfGeometry;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = this.numGeometry;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfInertia;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 14: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfLinearDampingFactor;
                this.fieldData.dataType = 1;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfLinearVelocity;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 16: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMass;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 17: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.pMassDensityModel != null ? this.pMassDensityModel : this.vfMassDensityModel;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 18: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOrientation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 19: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfPosition;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 20: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfTorques;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numTorques / 3;
                break;
            }
            case 21: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfUseFiniteRotation;
                this.fieldData.dataType = 1;
                break;
            }
            case 22: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfUseGlobalGravity;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfAngularVelocity, 3);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfAngularDampingFactor);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfAutoDamp);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAutoDisable);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfCenterOfMass, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfDisableAngularSpeed);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfDisableLinearSpeed);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfFiniteRotationAxis, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfForces, this.numForces);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfGeometry, this.numGeometry);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfInertia, this.numInertia);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfLinearDampingFactor);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfLinearVelocity, 3);
                    break;
                }
                case 16: {
                    vRMLNodeType.setValue(n2, this.vfMass);
                    break;
                }
                case 17: {
                    if (this.pMassDensityModel != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pMassDensityModel);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfMassDensityModel);
                    break;
                }
                case 18: {
                    vRMLNodeType.setValue(n2, this.vfOrientation, 4);
                    break;
                }
                case 19: {
                    vRMLNodeType.setValue(n2, this.vfPosition, 3);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfTorques, this.numTorques);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfUseFiniteRotation);
                    break;
                }
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfUseGlobalGravity);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseJointNode.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseJointNode.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAutoDisable(bl);
                break;
            }
            case 3: {
                this.setAutoDamp(bl);
                break;
            }
            case 9: {
                this.setEnabled(bl);
                break;
            }
            case 21: {
                this.setUseFiniteRotation(bl);
                break;
            }
            case 22: {
                this.setUseGlobalGravity(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 1: {
                this.setAngularDampingFactor(f);
                break;
            }
            case 7: {
                this.setDisableAngularVelocity(f);
                break;
            }
            case 8: {
                this.setDisableLinearVelocity(f);
                break;
            }
            case 6: {
                this.setDisableTime(f);
                break;
            }
            case 14: {
                this.setLinearDampingFactor(f);
                break;
            }
            case 16: {
                this.setMass(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 2: {
                this.setAngularVelocity(fArray);
                break;
            }
            case 5: {
                this.setCenterOfMass(fArray);
                break;
            }
            case 10: {
                this.setFiniteRotationAxis(fArray);
                break;
            }
            case 11: {
                this.setForces(fArray, n2);
                break;
            }
            case 13: {
                this.setInertia(fArray, n2);
                break;
            }
            case 15: {
                this.setLinearVelocity(fArray);
                break;
            }
            case 18: {
                this.setOrientation(fArray);
                break;
            }
            case 19: {
                this.setPosition(fArray);
                break;
            }
            case 20: {
                this.setTorques(fArray, n2);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 17: {
                this.setMassDensityModel(vRMLNodeType);
                break;
            }
            case 12: {
                this.addGeometry(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 12: {
                this.setGeometry(vRMLNodeTypeArray, n2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    private void setAngularVelocity(float[] fArray) {
        this.vfAngularVelocity[0] = fArray[0];
        this.vfAngularVelocity[1] = fArray[1];
        this.vfAngularVelocity[2] = fArray[2];
        if (!this.inSetup) {
            this.odeBody.setAngularVel(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setAutoDamp(boolean bl) {
        this.vfAutoDamp = bl;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    private void setAngularDampingFactor(float f) {
        this.vfAngularDampingFactor = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void setLinearDampingFactor(float f) {
        this.vfLinearDampingFactor = f;
        if (!this.inSetup) {
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setAutoDisable(boolean bl) {
        this.vfAutoDisable = bl;
        if (!this.inSetup) {
            this.odeBody.setAutoDisable(bl);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setCenterOfMass(float[] fArray) {
        this.vfCenterOfMass[0] = fArray[0];
        this.vfCenterOfMass[1] = fArray[1];
        this.vfCenterOfMass[2] = fArray[2];
        if (!this.inSetup) {
            this.odeBody.setMassParameters(this.vfMass, fArray[0], fArray[1], fArray[2], this.vfInertia[0], this.vfInertia[4], this.vfInertia[8], this.vfInertia[1], this.vfInertia[2], this.vfInertia[5]);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setDisableAngularVelocity(float f) {
        this.vfDisableAngularSpeed = f;
        if (!this.inSetup) {
            this.odeBody.setAngularVelocityDisableThreshold(f);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setDisableLinearVelocity(float f) {
        this.vfDisableLinearSpeed = f;
        if (!this.inSetup) {
            this.odeBody.setLinearVelocityDisableThreshold(f);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setDisableTime(float f) {
        this.vfDisableTime = f;
        if (!this.inSetup) {
            this.odeBody.setTimeDisableThreshold(f);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            if (bl) {
                this.odeBody.setForce(0.0f, 0.0f, 0.0f);
                this.odeBody.setTorque(0.0f, 0.0f, 0.0f);
            }
            this.odeBody.setEnabled(bl);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setFiniteRotationAxis(float[] fArray) {
        this.vfFiniteRotationAxis[0] = fArray[0];
        this.vfFiniteRotationAxis[1] = fArray[1];
        this.vfFiniteRotationAxis[2] = fArray[2];
        if (!this.inSetup) {
            this.odeBody.setFiniteRotationAxis(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setForces(float[] fArray, int n) {
        if (this.vfForces.length < n) {
            this.vfForces = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfForces, 0, n);
        this.numForces = n;
        if (!this.inSetup) {
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    private void setInertia(float[] fArray, int n) {
        if (this.vfInertia.length < n) {
            this.vfInertia = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfInertia, 0, n);
        this.numInertia = n;
        if (!this.inSetup) {
            this.odeBody.setMassParameters(this.vfMass, this.vfCenterOfMass[0], this.vfCenterOfMass[1], this.vfCenterOfMass[2], this.vfInertia[0], this.vfInertia[4], this.vfInertia[8], this.vfInertia[1], this.vfInertia[2], this.vfInertia[5]);
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void setLinearVelocity(float[] fArray) {
        this.vfLinearVelocity[0] = fArray[0];
        this.vfLinearVelocity[1] = fArray[1];
        this.vfLinearVelocity[2] = fArray[2];
        if (!this.inSetup) {
            this.odeBody.setLinearVel(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void setMass(float f) throws InvalidFieldValueException {
        if (f <= 0.0f) {
            throw new InvalidFieldValueException(NEG_MASS_MSG);
        }
        this.vfMass = f;
        if (!this.inSetup) {
            this.odeBody.adjustMass(this.vfMass);
            this.hasChanged[16] = true;
            this.fireFieldChanged(16);
        }
    }

    private void setOrientation(float[] fArray) {
        this.vfOrientation[0] = fArray[0];
        this.vfOrientation[1] = fArray[1];
        this.vfOrientation[2] = fArray[2];
        this.vfOrientation[3] = fArray[3];
        if (!this.inSetup) {
            this.odeBody.setAxisAndAngle(this.vfOrientation[0], this.vfOrientation[1], this.vfOrientation[2], this.vfOrientation[3]);
            this.hasChanged[18] = true;
            this.fireFieldChanged(18);
        }
    }

    private void setPosition(float[] fArray) {
        this.vfPosition[0] = fArray[0];
        this.vfPosition[1] = fArray[1];
        this.vfPosition[2] = fArray[2];
        if (!this.inSetup) {
            this.odeBody.setPosition(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[19] = true;
            this.fireFieldChanged(19);
        }
    }

    private void setTorques(float[] fArray, int n) {
        if (this.vfTorques.length < n) {
            this.vfTorques = new float[n];
        }
        System.arraycopy(fArray, 0, this.vfTorques, 0, n);
        this.numTorques = n;
        if (!this.inSetup) {
            this.hasChanged[20] = true;
            this.fireFieldChanged(20);
        }
    }

    private void setUseFiniteRotation(boolean bl) {
        this.vfUseFiniteRotation = bl;
        if (!this.inSetup) {
            this.odeBody.setFiniteRotationMode(bl ? 1 : 0);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setUseGlobalGravity(boolean bl) {
        this.vfUseGlobalGravity = bl;
        if (!this.inSetup) {
            this.odeBody.setGravityMode(bl ? 1 : 0);
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    protected void addGeometry(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldAccessException {
        VRMLNodeType vRMLNodeType2;
        if (!this.inSetup) {
            throw new InvalidFieldAccessException("Should not call out of setup");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType instanceof VRMLNBodyCollidableNodeType)) {
                throw new InvalidFieldValueException("An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode");
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLNBodyCollidableNodeType)) {
            throw new InvalidFieldValueException("An invalid node type has been specified for the geometry. Valid types extend X3DCollidableNode");
        }
        if (this.vfGeometry == null || this.numGeometry == this.vfGeometry.length) {
            vRMLNodeType2 = new VRMLNodeType[this.numGeometry + 8];
            if (this.vfGeometry != null) {
                System.arraycopy(this.vfGeometry, 0, vRMLNodeType2, 0, this.numGeometry);
            }
            this.vfGeometry = vRMLNodeType2;
        }
        this.vfGeometry[this.numGeometry++] = vRMLNodeType;
    }

    private PlaceableGeom findODEGeometry(VRMLNodeType vRMLNodeType) {
        PlaceableGeom placeableGeom = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null) {
                placeableGeom = ((VRMLNBodyCollidableNodeType)vRMLNodeType2).getODEGeometry();
            }
        } else if (vRMLNodeType != null) {
            placeableGeom = ((VRMLNBodyCollidableNodeType)vRMLNodeType).getODEGeometry();
        }
        return placeableGeom;
    }

    static {
        nodeFields = new int[]{0, 12, 17};
        fieldDecl = new VRMLFieldDeclaration[23];
        fieldMap = new HashMap(69);
        BaseRigidBody.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseRigidBody.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "angularDampingFactor");
        BaseRigidBody.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFVec3f", "angularVelocity");
        BaseRigidBody.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "autoDamp");
        BaseRigidBody.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFBool", "autoDisable");
        BaseRigidBody.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "centerOfMass");
        BaseRigidBody.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "disableAngularSpeed");
        BaseRigidBody.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "disableLinearSpeed");
        BaseRigidBody.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "disableTime");
        BaseRigidBody.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseRigidBody.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "finiteRotationAxis");
        BaseRigidBody.fieldDecl[11] = new VRMLFieldDeclaration(3, "MFVec3f", "forces");
        BaseRigidBody.fieldDecl[12] = new VRMLFieldDeclaration(3, "MFNode", "geometry");
        BaseRigidBody.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFMatrix3f", "inertia");
        BaseRigidBody.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "lineaarDampingFactor");
        BaseRigidBody.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFVec3f", "linearVelocity");
        BaseRigidBody.fieldDecl[16] = new VRMLFieldDeclaration(3, "SFFloat", "mass");
        BaseRigidBody.fieldDecl[17] = new VRMLFieldDeclaration(3, "SFNode", "massDensityModel");
        BaseRigidBody.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseRigidBody.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFRotation", "orientation");
        BaseRigidBody.fieldDecl[19] = new VRMLFieldDeclaration(3, "SFVec3f", "position");
        BaseRigidBody.fieldDecl[20] = new VRMLFieldDeclaration(3, "MFVec3f", "torques");
        BaseRigidBody.fieldDecl[21] = new VRMLFieldDeclaration(3, "SFBool", "useFiniteRotation");
        BaseRigidBody.fieldDecl[22] = new VRMLFieldDeclaration(3, "SFBool", "useGlobalGravity");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("angularVelocity", n);
        fieldMap.put("set_angularVelocity", n);
        fieldMap.put("angularVelocity_changed", n);
        n = new Integer(1);
        fieldMap.put("angularDampingFactor", n);
        fieldMap.put("set_angularDampingFactor", n);
        fieldMap.put("angularDampingFactor_changed", n);
        n = new Integer(3);
        fieldMap.put("autoDamp", n);
        fieldMap.put("set_autoDamp", n);
        fieldMap.put("autoDamp_changed", n);
        n = new Integer(4);
        fieldMap.put("autoDisable", n);
        fieldMap.put("set_autoDisable", n);
        fieldMap.put("autoDisable_changed", n);
        n = new Integer(5);
        fieldMap.put("centerOfMass", n);
        fieldMap.put("set_centerOfMass", n);
        fieldMap.put("centerOfMass_changed", n);
        n = new Integer(7);
        fieldMap.put("disableAngularSpeed", n);
        fieldMap.put("set_disableAngularSpeed", n);
        fieldMap.put("disableAngularSpeed_changed", n);
        n = new Integer(8);
        fieldMap.put("disableLinearSpeed", n);
        fieldMap.put("set_disableLinearSpeed", n);
        fieldMap.put("disableLinearSpeed_changed", n);
        n = new Integer(6);
        fieldMap.put("disableTime", n);
        fieldMap.put("set_disableTime", n);
        fieldMap.put("disableTime_changed", n);
        n = new Integer(9);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(10);
        fieldMap.put("finiteRotationAxis", n);
        fieldMap.put("set_finiteRotationAxis", n);
        fieldMap.put("finiteRotationAxis_changed", n);
        n = new Integer(11);
        fieldMap.put("forces", n);
        fieldMap.put("set_forces", n);
        fieldMap.put("forces_changed", n);
        n = new Integer(12);
        fieldMap.put("geometry", n);
        fieldMap.put("set_geometry", n);
        fieldMap.put("geometry_changed", n);
        n = new Integer(13);
        fieldMap.put("inertia", n);
        fieldMap.put("set_inertia", n);
        fieldMap.put("inertia_changed", n);
        n = new Integer(15);
        fieldMap.put("linearVelocity", n);
        fieldMap.put("set_linearVelocity", n);
        fieldMap.put("linearVelocity_changed", n);
        n = new Integer(14);
        fieldMap.put("linearDampingFactor", n);
        fieldMap.put("set_linearDampingFactor", n);
        fieldMap.put("linearDampingFactor_changed", n);
        n = new Integer(16);
        fieldMap.put("mass", n);
        fieldMap.put("set_mass", n);
        fieldMap.put("mass_changed", n);
        n = new Integer(17);
        fieldMap.put("massDensityModel", n);
        fieldMap.put("set_massDensityModel", n);
        fieldMap.put("massDensityModel_changed", n);
        n = new Integer(18);
        fieldMap.put("orientation", n);
        fieldMap.put("set_orientation", n);
        fieldMap.put("orientation_changed", n);
        n = new Integer(19);
        fieldMap.put("position", n);
        fieldMap.put("set_position", n);
        fieldMap.put("position_changed", n);
        n = new Integer(20);
        fieldMap.put("torques", n);
        fieldMap.put("set_torques", n);
        fieldMap.put("torques_changed", n);
        n = new Integer(21);
        fieldMap.put("useFiniteRotation", n);
        fieldMap.put("set_useFiniteRotation", n);
        fieldMap.put("useFiniteRotation_changed", n);
        n = new Integer(22);
        fieldMap.put("useGlobalGravity", n);
        fieldMap.put("set_useGlobalGravity", n);
        fieldMap.put("useGlobalGravity_changed", n);
        validDensityTypes = new HashSet();
        validDensityTypes.add((Object)"Cone");
        validDensityTypes.add((Object)"Box");
        validDensityTypes.add((Object)"Sphere");
    }
}

