/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.ArrayList;
import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.World;
import org.odejava.collision.BulkContact;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLRigidBodyGroupNodeType;
import org.web3d.vrml.nodes.VRMLRigidBodyNodeType;
import org.web3d.vrml.nodes.VRMLRigidJointNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseContact;

public class BaseRigidBodyCollection
extends AbstractNode
implements VRMLRigidBodyGroupNodeType,
VRMLChildNodeType {
    protected static final int FIELD_SET_CONTACTS = 1;
    protected static final int FIELD_AUTO_DISABLE = 2;
    protected static final int FIELD_BODIES = 3;
    protected static final int FIELD_CONSTANT_FORCE_MIX = 4;
    protected static final int FIELD_CONTACT_SURFACE_THICKNESS = 5;
    protected static final int FIELD_DISABLE_ANGULAR_SPEED = 6;
    protected static final int FIELD_DISABLE_LINEAR_SPEED = 7;
    protected static final int FIELD_DISABLE_TIME = 8;
    protected static final int FIELD_ENABLED = 9;
    protected static final int FIELD_ERROR_CORRECTION = 10;
    protected static final int FIELD_GRAVITY = 11;
    protected static final int FIELD_ITERATIONS = 12;
    protected static final int FIELD_JOINTS = 13;
    protected static final int FIELD_MAX_CORRECTION_SPEED = 14;
    protected static final int FIELD_PREFER_ACCURACY = 15;
    protected static final int FIELD_COLLIDER = 16;
    protected static final int LAST_COLLECTION_INDEX = 16;
    private static final int NUM_FIELDS = 17;
    protected static final String BODY_PROTO_MSG = "Proto does not describe a Body object.";
    protected static final String BODY_NODE_MSG = "Node does not describe a Body object.";
    protected static final String CONTACT_PROTO_MSG = "Proto does not describe a Contact node.";
    protected static final String CONTACT_NODE_MSG = "Node does not describe a Contact node.";
    protected static final String COLL_PROTO_MSG = "collider proto does not describe a CollisionCollection object.";
    protected static final String COLL_NODE_MSG = "Collider node does not describe a CollisionCollection object.";
    protected static final String INVALID_BODY_NODE_MSG = "An invalid node type has been specified for the bodies field. The only valid node is RigidBody.";
    protected static final String INVALID_JOINT_NODE_MSG = "An invalid node type has been specified for the joints field. Valid nodes must be of the X3DRigidJointNode base type.";
    protected static final String DIS_ANG_VEL_RANGE_MSG = "The disableAngularSpeed value is out of the required range [0,inf): ";
    protected static final String DIS_LIN_VEL_RANGE_MSG = "The disableLinearSpeed value is out of the required range [0,inf): ";
    protected static final String NEG_SURFACE_MSG = "The value of contactSurfaceThickness field is negative.";
    protected static final String NEG_ERR_CORR_MSG = "The value of errorCorrection field is negative.";
    protected static final String NEG_ERR_SPEED_MSG = "The value of maxCorrectionSpeed is negative.";
    protected static final String NEG_ITERATIONS_MSG = "The value of iterations is negative.";
    protected static final String NEG_CFM_MSG = "The value of constantForceMix is negative: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected ArrayList vfSetContacts;
    protected boolean vfAutoDisable = false;
    protected float vfContactSurfaceThickness = 0.0f;
    protected float vfConstantForceMix = 1.0E-4f;
    protected VRMLNodeType[] vfBodies;
    protected int numBodies;
    protected float vfDisableTime = 0.0f;
    protected float vfDisableAngularSpeed = 0.0f;
    protected float vfDisableLinearSpeed = 0.0f;
    protected boolean vfEnabled = true;
    protected float vfErrorCorrection = 0.8f;
    protected float[] vfGravity = new float[]{0.0f, -0.98f, 0.0f};
    protected int vfIterations = 10;
    protected VRMLNodeType[] vfJoints;
    protected int numJoints;
    protected float vfMaxCorrectionSpeed = 0.0f;
    protected boolean vfPreferAccuracy = false;
    protected VRMLNBodyGroupNodeType vfCollider;
    protected VRMLProtoInstance pCollider;
    private World odeWorld;
    private JointGroup odeJointGroup;
    private ArrayList bodyNodes;
    private boolean[] receivedContacts;

    public BaseRigidBodyCollection() {
        super("RigidBodyCollection");
        this.vfSetContacts = new ArrayList();
        this.odeJointGroup = new JointGroup();
        this.bodyNodes = new ArrayList();
        this.receivedContacts = new boolean[1500];
        this.hasChanged = new boolean[17];
    }

    public BaseRigidBodyCollection(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("autoDisable");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAutoDisable = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("contactSurfaceThickness");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfContactSurfaceThickness = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("disableAngularSpeed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableAngularSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("disableLinearSpeed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableLinearSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("disableTime");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDisableTime = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("enabled");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEnabled = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("errorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfErrorCorrection = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("gravity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGravity[0] = vRMLFieldData.floatArrayValue[0];
            this.vfGravity[1] = vRMLFieldData.floatArrayValue[1];
            this.vfGravity[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("iterations");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfIterations = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("maxCorrectionSpeed");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxCorrectionSpeed = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("preferAccuracy");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfPreferAccuracy = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("constantForceMix");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfConstantForceMix = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void processInputContacts() {
        int n;
        int n2 = this.vfSetContacts.size();
        if (this.vfSetContacts.size() == 0 || this.vfCollider == null) {
            return;
        }
        int n3 = this.vfCollider.numContacts();
        if (this.receivedContacts.length < n3) {
            this.receivedContacts = new boolean[n3];
        }
        for (int i = 0; i < n3; ++i) {
            this.receivedContacts[i] = false;
        }
        BulkContact bulkContact = this.vfCollider.getContacts();
        for (n = 0; n < n2; ++n) {
            BaseContact baseContact = (BaseContact)this.vfSetContacts.get(n);
            if (baseContact.getContacts() != bulkContact) continue;
            this.receivedContacts[n] = true;
        }
        for (n = 0; n < n3; ++n) {
            if (this.receivedContacts[n]) continue;
            bulkContact.ignoreContact(n);
        }
        this.vfCollider.applyContacts();
    }

    public void setTimestep(float f) {
        this.odeWorld.setStepSize(f);
    }

    public void evaluateModel() {
        int n = this.bodyNodes.size();
        for (int i = 0; i < n; ++i) {
            VRMLRigidBodyNodeType vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)this.bodyNodes.get(i);
            vRMLRigidBodyNodeType.updateODEFromNode();
        }
        if (this.vfPreferAccuracy) {
            this.odeWorld.step();
        } else {
            this.odeWorld.quickStep();
        }
    }

    public void delete() {
        this.odeWorld.delete();
    }

    public void updatePostSimulation() {
        int n = this.bodyNodes.size();
        for (int i = 0; i < n; ++i) {
            VRMLRigidBodyNodeType vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)this.bodyNodes.get(i);
            vRMLRigidBodyNodeType.updateNodeFromODE();
        }
    }

    public boolean isEnabled() {
        return this.vfEnabled;
    }

    public void setGravity(float[] fArray) {
        this.vfGravity[0] = fArray[0];
        this.vfGravity[1] = fArray[1];
        this.vfGravity[2] = fArray[2];
        if (!this.inSetup) {
            this.odeWorld.setGravity(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    public void getGravity(float[] fArray) {
        fArray[0] = this.vfGravity[0];
        fArray[1] = this.vfGravity[1];
        fArray[2] = this.vfGravity[2];
    }

    public int numJoints() {
        return this.numJoints;
    }

    public VRMLNodeType[] getJoints() {
        return this.vfJoints;
    }

    public void setJoints(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        VRMLRigidJointNodeType vRMLRigidJointNodeType;
        VRMLNodeType vRMLNodeType;
        int n2;
        for (n2 = 0; n2 < this.numJoints; ++n2) {
            if (vRMLNodeTypeArray[n2] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)this.vfJoints[n2]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType != null) {
                    vRMLRigidJointNodeType = (VRMLRigidJointNodeType)vRMLNodeType;
                    vRMLRigidJointNodeType.setODEWorld(null, null);
                }
            } else if (this.vfJoints[n2] instanceof VRMLRigidJointNodeType) {
                vRMLNodeType = (VRMLRigidJointNodeType)this.vfJoints[n2];
                vRMLNodeType.setODEWorld(null, null);
            }
            this.odeJointGroup.empty();
            this.vfJoints[n2] = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (vRMLNodeTypeArray[n2] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)vRMLNodeTypeArray[n2]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLRigidJointNodeType)) {
                    throw new InvalidFieldValueException(INVALID_JOINT_NODE_MSG);
                }
                if (vRMLNodeType == null) continue;
                vRMLRigidJointNodeType = (VRMLRigidJointNodeType)vRMLNodeType;
                vRMLRigidJointNodeType.setODEWorld(this.odeWorld, this.odeJointGroup);
                continue;
            }
            if (vRMLNodeTypeArray[n2] instanceof VRMLRigidJointNodeType) {
                vRMLNodeType = (VRMLRigidJointNodeType)vRMLNodeTypeArray[n2];
                vRMLNodeType.setODEWorld(this.odeWorld, this.odeJointGroup);
                continue;
            }
            if (vRMLNodeTypeArray[n2] == null) continue;
            throw new InvalidFieldValueException(INVALID_JOINT_NODE_MSG);
        }
        if (this.vfJoints == null || this.vfJoints.length < n) {
            this.vfJoints = new VRMLNodeType[n];
        }
        System.arraycopy(vRMLNodeTypeArray, 0, this.vfJoints, 0, n);
        this.numJoints = n;
        if (!this.inSetup) {
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    public int numBodies() {
        return this.numBodies;
    }

    public VRMLNodeType[] getBodies() {
        return this.vfBodies;
    }

    public void setBodies(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        VRMLRigidBodyNodeType vRMLRigidBodyNodeType;
        VRMLNodeType vRMLNodeType;
        int n2;
        this.bodyNodes.clear();
        for (n2 = 0; n2 < this.numBodies; ++n2) {
            if (vRMLNodeTypeArray[n2] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)this.vfBodies[n2]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType != null) {
                    vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
                    Body body = vRMLRigidBodyNodeType.getODEBody();
                    this.odeWorld.deleteBody(body);
                }
            } else if (this.vfBodies[n2] instanceof VRMLRigidBodyNodeType) {
                vRMLNodeType = (VRMLRigidBodyNodeType)this.vfBodies[n2];
                vRMLRigidBodyNodeType = vRMLNodeType.getODEBody();
                this.odeWorld.deleteBody((Body)vRMLRigidBodyNodeType);
            }
            this.vfBodies[n2] = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            if (vRMLNodeTypeArray[n2] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)vRMLNodeTypeArray[n2]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLRigidBodyNodeType)) {
                    throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
                }
                if (vRMLNodeType == null) continue;
                vRMLRigidBodyNodeType = (VRMLRigidBodyNodeType)vRMLNodeType;
                vRMLRigidBodyNodeType.setODEWorld(this.odeWorld);
                this.bodyNodes.add(vRMLRigidBodyNodeType);
                continue;
            }
            if (vRMLNodeTypeArray[n2] instanceof VRMLRigidBodyNodeType) {
                vRMLNodeType = (VRMLRigidBodyNodeType)vRMLNodeTypeArray[n2];
                vRMLNodeType.setODEWorld(this.odeWorld);
                this.bodyNodes.add(vRMLNodeType);
                continue;
            }
            if (vRMLNodeTypeArray[n2] == null) continue;
            throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
        }
        if (this.vfBodies == null || this.vfBodies.length < n) {
            this.vfBodies = new VRMLNodeType[n];
        }
        System.arraycopy(vRMLNodeTypeArray, 0, this.vfBodies, 0, n);
        this.numBodies = n;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    public void setupFinished() {
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.setWorld(new World());
        for (n = 0; n < this.numJoints; ++n) {
            if (this.vfJoints[n] == null) continue;
            this.vfJoints[n].setupFinished();
        }
        for (n = 0; n < this.numBodies; ++n) {
            if (this.vfBodies[n] == null) continue;
            this.vfBodies[n].setupFinished();
        }
        if (this.pCollider != null) {
            this.pCollider.setupFinished();
        } else if (this.vfCollider != null) {
            this.vfCollider.setupFinished();
        }
        if (this.vfCollider != null) {
            this.vfCollider.setOwningWorld(this.odeWorld);
        }
    }

    public int updateRefCount(boolean bl) {
        int n = this.refCount;
        super.updateRefCount(bl);
        if (this.refCount == 0) {
            this.odeWorld.delete();
            this.setWorld(null);
        } else if (n == 0 && this.refCount != 0) {
            this.setWorld(new World());
        }
        return this.refCount;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 16) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 83;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 2: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfAutoDisable;
                this.fieldData.dataType = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.vfBodies;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = this.numBodies;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfConstantForceMix;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfContactSurfaceThickness;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableAngularSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableLinearSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfDisableTime;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfEnabled;
                this.fieldData.dataType = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfErrorCorrection;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfGravity;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 12: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfIterations;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 13: {
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.vfJoints;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = this.numJoints;
                break;
            }
            case 14: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxCorrectionSpeed;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 15: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfPreferAccuracy;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfAutoDisable);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfBodies, this.numBodies);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfConstantForceMix);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfContactSurfaceThickness);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfDisableAngularSpeed);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfDisableLinearSpeed);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfEnabled);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfErrorCorrection);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfGravity, 3);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfIterations);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfJoints, this.numJoints);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfMaxCorrectionSpeed);
                    break;
                }
                case 15: {
                    vRMLNodeType.setValue(n2, this.vfPreferAccuracy);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseJointNode.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseJointNode.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 2: {
                this.setAutoDisable(bl);
                break;
            }
            case 9: {
                this.setEnabled(bl);
                break;
            }
            case 15: {
                this.setPreferAccuracy(bl);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 12: {
                this.setIterations(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setConstantForceMix(f);
                break;
            }
            case 6: {
                this.setDisableAngularVelocity(f);
                break;
            }
            case 7: {
                this.setDisableLinearVelocity(f);
                break;
            }
            case 8: {
                this.setDisableTime(f);
                break;
            }
            case 5: {
                this.setContactSurfaceThickness(f);
                break;
            }
            case 10: {
                this.setErrorCorrection(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 11: {
                this.setGravity(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                this.addBody(vRMLNodeType);
                break;
            }
            case 13: {
                this.addJoint(vRMLNodeType);
                break;
            }
            case 16: {
                this.setCollider(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 3: {
                this.setBodies(vRMLNodeTypeArray, n2);
                break;
            }
            case 13: {
                this.setJoints(vRMLNodeTypeArray, n2);
                break;
            }
            case 1: {
                this.setContacts(vRMLNodeTypeArray, n2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    private void setContacts(VRMLNodeType[] vRMLNodeTypeArray, int n) {
        this.vfSetContacts.clear();
        this.vfSetContacts.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            if (vRMLNodeTypeArray[i] instanceof BaseContact) {
                this.vfSetContacts.add(vRMLNodeTypeArray[i]);
                continue;
            }
            if (vRMLNodeTypeArray[i] instanceof VRMLProtoInstance) {
                VRMLNodeType vRMLNodeType = ((VRMLProtoInstance)vRMLNodeTypeArray[i]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType != null && !(vRMLNodeType instanceof BaseContact)) {
                    throw new InvalidFieldValueException(CONTACT_PROTO_MSG);
                }
                this.vfSetContacts.add(vRMLNodeType);
                continue;
            }
            if (vRMLNodeTypeArray[i] == null) continue;
            throw new InvalidFieldValueException(CONTACT_NODE_MSG);
        }
    }

    private void setAutoDisable(boolean bl) {
        this.vfAutoDisable = bl;
        if (!this.inSetup) {
            this.odeWorld.setAutoDisableBodies(bl);
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    private void setDisableAngularVelocity(float f) {
        this.vfDisableAngularSpeed = f;
        if (!this.inSetup) {
            this.odeWorld.setAngularVelocityDisableThreshold(f);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setDisableLinearVelocity(float f) {
        this.vfDisableLinearSpeed = f;
        if (!this.inSetup) {
            this.odeWorld.setLinearVelocityDisableThreshold(f);
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    private void setDisableTime(float f) {
        this.vfDisableTime = f;
        if (!this.inSetup) {
            this.odeWorld.setTimeDisableThreshold(f);
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    private void setConstantForceMix(float f) {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_CFM_MSG + f);
        }
        this.vfConstantForceMix = f;
        if (!this.inSetup) {
            this.odeWorld.setConstantForceMix(f);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setEnabled(boolean bl) {
        this.vfEnabled = bl;
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    private void setContactSurfaceThickness(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_SURFACE_MSG);
        }
        this.vfContactSurfaceThickness = f;
        if (!this.inSetup) {
            this.odeWorld.setContactSurfaceThickness(f);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_ERR_CORR_MSG);
        }
        this.vfErrorCorrection = f;
        if (!this.inSetup) {
            this.odeWorld.setErrorReductionParameter(f);
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    private void setIterations(int n) throws InvalidFieldValueException {
        if (n < 0) {
            throw new InvalidFieldValueException(NEG_ITERATIONS_MSG);
        }
        this.vfIterations = n;
        if (!this.inSetup) {
            this.odeWorld.setStepInteractions(this.vfIterations);
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    private void setMaxCorrectionSpeed(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException(NEG_ERR_SPEED_MSG);
        }
        this.vfMaxCorrectionSpeed = f;
        if (!this.inSetup) {
            if (this.vfMaxCorrectionSpeed == -1.0f) {
                this.odeWorld.setMaxCorrectionVelocity(Float.POSITIVE_INFINITY);
            } else {
                this.odeWorld.setMaxCorrectionVelocity(this.vfMaxCorrectionSpeed);
            }
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    private void setPreferAccuracy(boolean bl) {
        this.vfPreferAccuracy = bl;
        if (!this.inSetup) {
            this.hasChanged[15] = true;
            this.fireFieldChanged(15);
        }
    }

    private void addBody(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType[] vRMLNodeTypeArray;
        if (!this.inSetup) {
            throw new IllegalStateException("single addBody state error!");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeTypeArray = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeTypeArray != null && vRMLNodeTypeArray instanceof VRMLProtoInstance) {
                vRMLNodeTypeArray = ((VRMLProtoInstance)vRMLNodeTypeArray).getImplementationNode();
            }
            if (vRMLNodeTypeArray != null && !(vRMLNodeTypeArray instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
            }
            this.bodyNodes.add(vRMLNodeTypeArray);
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLRigidBodyNodeType)) {
                throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
            }
            this.bodyNodes.add(vRMLNodeType);
        }
        if (this.vfBodies == null || this.vfBodies.length == this.numBodies) {
            vRMLNodeTypeArray = new VRMLNodeType[this.numBodies + 8];
            if (this.vfBodies != null) {
                System.arraycopy(this.vfBodies, 0, vRMLNodeTypeArray, 0, this.numBodies);
            }
            this.vfBodies = vRMLNodeTypeArray;
        }
        this.vfBodies[this.numBodies++] = vRMLNodeType;
    }

    private void addJoint(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLNodeType vRMLNodeType2;
        if (!this.inSetup) {
            throw new IllegalStateException("single addBody state error!");
        }
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLRigidJointNodeType)) {
                throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLRigidJointNodeType)) {
            throw new InvalidFieldValueException(INVALID_BODY_NODE_MSG);
        }
        if (this.vfJoints == null || this.vfJoints.length == this.numJoints) {
            vRMLNodeType2 = new VRMLNodeType[this.numJoints + 8];
            if (this.vfJoints != null) {
                System.arraycopy(this.vfJoints, 0, vRMLNodeType2, 0, this.numJoints);
            }
            this.vfJoints = vRMLNodeType2;
        }
        this.vfJoints[this.numJoints++] = vRMLNodeType;
    }

    public void setCollider(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object var3_2 = null;
        Object object = this.pCollider != null ? this.pCollider : this.vfCollider;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLNBodyGroupNodeType)) {
                throw new InvalidFieldValueException(COLL_PROTO_MSG);
            }
            this.pCollider = (VRMLProtoInstance)vRMLNodeType;
            this.vfCollider = (VRMLNBodyGroupNodeType)vRMLNodeType2;
        } else if (vRMLNodeType instanceof VRMLNBodyGroupNodeType) {
            this.pCollider = null;
            this.vfCollider = (VRMLNBodyGroupNodeType)vRMLNodeType;
        } else {
            throw new InvalidFieldValueException(COLL_NODE_MSG);
        }
    }

    private void setWorld(World world) {
        VRMLNodeType vRMLNodeType;
        int n;
        this.odeWorld = world;
        if (this.odeWorld != null) {
            this.odeWorld.setStepInteractions(this.vfIterations);
            this.odeWorld.setGravity(this.vfGravity[0], this.vfGravity[1], this.vfGravity[2]);
            this.odeWorld.setErrorReductionParameter(this.vfErrorCorrection);
            if (this.vfMaxCorrectionSpeed == -1.0f) {
                this.odeWorld.setMaxCorrectionVelocity(Float.POSITIVE_INFINITY);
            } else {
                this.odeWorld.setMaxCorrectionVelocity(this.vfMaxCorrectionSpeed);
            }
            this.odeWorld.setAngularVelocityDisableThreshold(this.vfDisableAngularSpeed);
            this.odeWorld.setLinearVelocityDisableThreshold(this.vfDisableLinearSpeed);
            this.odeWorld.setTimeDisableThreshold(this.vfDisableTime);
            this.odeWorld.setAutoDisableBodies(this.vfAutoDisable);
            this.odeWorld.setContactSurfaceThickness(this.vfContactSurfaceThickness);
            this.odeWorld.setConstantForceMix(this.vfConstantForceMix);
        }
        for (n = 0; n < this.numBodies; ++n) {
            if (this.vfBodies[n] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)this.vfBodies[n]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType == null) continue;
                ((VRMLRigidBodyNodeType)vRMLNodeType).setODEWorld(world);
                continue;
            }
            if (this.vfBodies[n] == null) continue;
            ((VRMLRigidBodyNodeType)this.vfBodies[n]).setODEWorld(world);
        }
        for (n = 0; n < this.numJoints; ++n) {
            if (this.vfJoints[n] instanceof VRMLProtoInstance) {
                vRMLNodeType = ((VRMLProtoInstance)this.vfJoints[n]).getImplementationNode();
                while (vRMLNodeType != null && vRMLNodeType instanceof VRMLProtoInstance) {
                    vRMLNodeType = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
                }
                if (vRMLNodeType == null) continue;
                ((VRMLRigidJointNodeType)vRMLNodeType).setODEWorld(world, this.odeJointGroup);
                continue;
            }
            if (this.vfJoints[n] == null) continue;
            ((VRMLRigidJointNodeType)this.vfJoints[n]).setODEWorld(world, this.odeJointGroup);
        }
    }

    static {
        nodeFields = new int[]{0, 3, 13, 16};
        fieldDecl = new VRMLFieldDeclaration[17];
        fieldMap = new HashMap(51);
        BaseRigidBodyCollection.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseRigidBodyCollection.fieldDecl[1] = new VRMLFieldDeclaration(1, "MFNode", "set_contacts");
        BaseRigidBodyCollection.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFBool", "autoDisable");
        BaseRigidBodyCollection.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "bodies");
        BaseRigidBodyCollection.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "constantForceMix");
        BaseRigidBodyCollection.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFFloat", "contactSurfaceThickness");
        BaseRigidBodyCollection.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "disableAngularSpeed");
        BaseRigidBodyCollection.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "disableLinearSpeed");
        BaseRigidBodyCollection.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "disableTime");
        BaseRigidBodyCollection.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseRigidBodyCollection.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFFloat", "errorCorrectionFactor");
        BaseRigidBodyCollection.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFVec3f", "gravity");
        BaseRigidBodyCollection.fieldDecl[13] = new VRMLFieldDeclaration(3, "MFNode", "joints");
        BaseRigidBodyCollection.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFInt32", "iterations");
        BaseRigidBodyCollection.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "maxCorrectionSpeed");
        BaseRigidBodyCollection.fieldDecl[16] = new VRMLFieldDeclaration(2, "SFNode", "collider");
        BaseRigidBodyCollection.fieldDecl[15] = new VRMLFieldDeclaration(3, "SFBool", "preferAccuracy");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        fieldMap.put("set_contacts", new Integer(1));
        fieldMap.put("collider", new Integer(16));
        n = new Integer(2);
        fieldMap.put("autoDisable", n);
        fieldMap.put("set_autoDisable", n);
        fieldMap.put("autoDisable_changed", n);
        n = new Integer(3);
        fieldMap.put("bodies", n);
        fieldMap.put("set_bodies", n);
        fieldMap.put("bodies_changed", n);
        n = new Integer(4);
        fieldMap.put("constantForceMix", n);
        fieldMap.put("set_constantForceMix", n);
        fieldMap.put("constantForceMix_changed", n);
        n = new Integer(5);
        fieldMap.put("contactSurfaceThickness", n);
        fieldMap.put("set_contactSurfaceThickness", n);
        fieldMap.put("contactSurfaceThickness_changed", n);
        n = new Integer(6);
        fieldMap.put("disableAngularSpeed", n);
        fieldMap.put("set_disableAngularSpeed", n);
        fieldMap.put("disableAngularSpeed_changed", n);
        n = new Integer(7);
        fieldMap.put("disableLinearSpeed", n);
        fieldMap.put("set_disableLinearSpeed", n);
        fieldMap.put("disableLinearSpeed_changed", n);
        n = new Integer(8);
        fieldMap.put("disableTime", n);
        fieldMap.put("set_disableTime", n);
        fieldMap.put("disableTime_changed", n);
        n = new Integer(9);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(10);
        fieldMap.put("errorCorrection", n);
        fieldMap.put("set_errorCorrection", n);
        fieldMap.put("errorCorrection_changed", n);
        n = new Integer(11);
        fieldMap.put("gravity", n);
        fieldMap.put("set_gravity", n);
        fieldMap.put("gravity_changed", n);
        n = new Integer(13);
        fieldMap.put("joints", n);
        fieldMap.put("set_joints", n);
        fieldMap.put("joints_changed", n);
        n = new Integer(12);
        fieldMap.put("iterations", n);
        fieldMap.put("set_iterations", n);
        fieldMap.put("iterations_changed", n);
        n = new Integer(14);
        fieldMap.put("maxCorrectionSpeed", n);
        fieldMap.put("set_maxCorrectionSpeed", n);
        fieldMap.put("maxCorrectionSpeed_changed", n);
        n = new Integer(15);
        fieldMap.put("preferAccuracy", n);
        fieldMap.put("set_preferAccuracy", n);
        fieldMap.put("preferAccuracy_changed", n);
    }
}

