/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.scripting;

import java.util.ArrayList;
import java.util.List;
import org.web3d.util.HashSet;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.AbstractDynamicFieldNode;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.util.URLChecker;

public abstract class BaseScript
extends AbstractDynamicFieldNode
implements VRMLScriptNodeType {
    private static final Integer ZERO_SIZE;
    private static final Integer SINGLE_SIZE;
    private static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    private static final String VRML97_EXPOSED_MSG = "VRML97 Does not allow script fields to be declared as exposedField";
    private static final String[] VRML97_MIME_TYPES;
    private static final String[] X3D_MIME_TYPES;
    private static final int[] SECONDARY_TYPE;
    private static final HashSet validVrml97Types;
    private static final HashSet validX3DTypes;
    private static final HashSet forbiddenFields;
    private final int FIELD_METADATA;
    private final int FIELD_URL;
    private final int FIELD_MUST_EVALUATE;
    private final int FIELD_DIRECT_OUTPUT;
    private final int LAST_FIXED_INDEX;
    private IntHashMap fieldValueMap;
    private IntHashMap fieldSizeMap;
    private IntHashMap fieldChangedMap;
    private IntHashMap userData;
    private String worldURL;
    private int loadState;
    private boolean isDEF = false;
    private boolean isStatic;
    private boolean eventOutProcessingInProgress;
    protected int majorVersion;
    protected int minorVersion;
    private boolean[] hasChanged;
    private double[] lastChangedTime;
    private String[] vfUrl;
    private boolean vfMustEvaluate;
    private boolean vfDirectOutput;
    private ScriptWrapper realScript;
    private VRMLExecutionSpace execSpace;
    private ArrayList urlListeners;
    private ArrayList contentListeners;

    protected BaseScript() {
        super("Script");
        this.inSetup = true;
        this.vfMustEvaluate = false;
        this.vfDirectOutput = false;
        this.urlListeners = new ArrayList(1);
        this.contentListeners = new ArrayList(1);
        this.fieldSizeMap = new IntHashMap();
        this.fieldValueMap = new IntHashMap();
        this.fieldChangedMap = new IntHashMap();
        this.userData = new IntHashMap();
        int n = 0;
        this.loadState = 1;
        VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_METADATA = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(3, "MFString", "url");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_URL = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "SFBool", "mustEvaluate");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.FIELD_MUST_EVALUATE = n;
        vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "SFBool", "directOutput");
        try {
            n = this.appendField(vRMLFieldDeclaration);
        }
        catch (FieldExistsException fieldExistsException) {
            // empty catch block
        }
        this.LAST_FIXED_INDEX = this.FIELD_DIRECT_OUTPUT = n;
        this.fieldChangedMap = new IntHashMap();
        this.hasChanged = new boolean[this.LAST_FIXED_INDEX + 1];
        this.vfUrl = FieldConstants.EMPTY_MFSTRING;
        this.eventOutProcessingInProgress = false;
    }

    protected BaseScript(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((BaseScript)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfUrl = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfUrl, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("mustEvaluate");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMustEvaluate = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("directOutput");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDirectOutput = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        System.out.println("Script needs to handle notifyExternProtoLoaded");
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray;
        this.hasChanged[this.FIELD_URL] = true;
        this.fireFieldChanged(this.FIELD_URL);
        this.fireUrlChanged();
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        this.loadState = n;
        this.fireContentStateChanged();
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            this.vfUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfUrl, (boolean)false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        if (!(object instanceof ScriptWrapper)) {
            throw new IllegalArgumentException("Not a script wrapper");
        }
        this.realScript = (ScriptWrapper)object;
    }

    public void setLoadedURI(String string) {
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public void setExecutionSpace(VRMLExecutionSpace vRMLExecutionSpace) {
        this.execSpace = vRMLExecutionSpace;
    }

    public VRMLExecutionSpace getExecutionSpace() {
        return this.execSpace;
    }

    public void initialize(double d) {
        try {
            if (this.realScript != null) {
                this.realScript.setTimestamp(d);
                this.realScript.initialize((VRMLScriptNodeType)this);
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
        }
        catch (Exception exception) {
            System.out.println("Script failed to initialize: " + this.vfUrl[0]);
            exception.printStackTrace();
        }
    }

    public void prepareEvents(double d) {
        if (this.realScript != null) {
            this.realScript.setTimestamp(d);
            if (this.realScript.prepareEvents() && this.realScript.sendEvents()) {
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
        }
    }

    public void processEvents() {
        if (this.realScript != null && this.realScript.sendEvents()) {
            this.eventOutProcessingInProgress = true;
            this.realScript.updateEventOuts();
            this.eventOutProcessingInProgress = false;
        }
    }

    public void eventsProcessed() {
        if (this.realScript != null) {
            this.realScript.eventsProcessed();
            this.eventOutProcessingInProgress = true;
            this.realScript.updateEventOuts();
            this.eventOutProcessingInProgress = false;
        }
    }

    public void shutdown() {
        if (this.realScript != null) {
            this.realScript.shutdown();
            if (this.realScript.sendEvents()) {
                this.eventOutProcessingInProgress = true;
                this.realScript.updateEventOuts();
                this.eventOutProcessingInProgress = false;
            }
            this.realScript = null;
        }
    }

    public void shutdownAll() {
    }

    public boolean isSetupFinished() {
        return !this.inSetup;
    }

    public void setupFinished() {
        super.setupFinished();
        int n = this.getFieldCount();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType[] vRMLNodeTypeArray;
            int n2;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(i);
            this.fieldChangedMap.put(i, (Object)Boolean.FALSE);
            int n3 = vRMLFieldDeclaration.getAccessType();
            if (n3 == 1 || n3 == 4 || (n2 = vRMLFieldDeclaration.getFieldType()) != 12 && n2 != 11) continue;
            Object object = this.fieldValueMap.get(i);
            if (object instanceof VRMLNodeType) {
                vRMLNodeTypeArray = (VRMLNodeType[])object;
                if (vRMLNodeTypeArray == this) continue;
                vRMLNodeTypeArray.setupFinished();
                continue;
            }
            if (!(object instanceof VRMLNodeType[])) continue;
            vRMLNodeTypeArray = (VRMLNodeType[])object;
            int n4 = (Integer)this.fieldSizeMap.get(i);
            for (int j = 0; j < n4; ++j) {
                if (vRMLNodeTypeArray[j] == this || vRMLNodeTypeArray[j] == null) continue;
                vRMLNodeTypeArray[j].setupFinished();
            }
        }
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        if (n >= 0 && n <= this.LAST_FIXED_INDEX) {
            if (n == this.FIELD_URL) {
                this.fieldData.dataType = (short)14;
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.numElements = this.vfUrl == null ? 0 : this.vfUrl.length;
            } else if (n == this.FIELD_DIRECT_OUTPUT) {
                this.fieldData.dataType = 1;
                this.fieldData.booleanValue = this.vfDirectOutput;
            } else if (n == this.FIELD_MUST_EVALUATE) {
                this.fieldData.dataType = 1;
                this.fieldData.booleanValue = this.vfMustEvaluate;
            } else if (n == this.FIELD_METADATA) {
                this.fieldData.nodeValue = this.vfMetadata;
                this.fieldData.dataType = (short)7;
            }
        } else if (!this.fetchValue(n)) {
            return null;
        }
        return this.fieldData;
    }

    public boolean hasFieldChanged(int n) {
        boolean bl = false;
        Boolean bl2 = (Boolean)this.fieldChangedMap.get(n);
        bl = bl2;
        this.fieldChangedMap.put(n, (Object)Boolean.FALSE);
        return bl;
    }

    public int getPrimaryType() {
        return 41;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        Object object = this.fieldValueMap.get(n);
        if (object == null) {
            return;
        }
        Integer n3 = (Integer)this.fieldSizeMap.get(n);
        try {
            this.sendValue(vRMLNodeType, n2, object, n3);
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Script route to invalid event: " + invalidFieldException.getFieldName());
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Script route sending out of range values " + invalidFieldValueException.getFieldName());
            invalidFieldValueException.printStackTrace();
            System.out.println("URL: " + this.vfUrl[0]);
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(int): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, (Object)new Integer(n2));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(3, vRMLFieldDeclaration.getName(), n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(int[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (n2 != 0) {
            int[] nArray2 = (int[])this.fieldValueMap.get(n);
            if (nArray2 == null || nArray2.length < n2) {
                nArray2 = new int[n2];
                this.fieldValueMap.put(n, (Object)nArray2);
            }
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), nArray, n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        if (n >= 0 && n <= this.LAST_FIXED_INDEX) {
            if (n == this.FIELD_URL) {
                throw new InvalidFieldException("setValue(boolean): URL field not a boolean");
            }
            if (!this.inSetup) {
                throw new InvalidFieldException("Cannot change initialise  only fields");
            }
            if (n == this.FIELD_DIRECT_OUTPUT) {
                this.vfDirectOutput = bl;
                return;
            } else {
                if (n != this.FIELD_MUST_EVALUATE) throw new InvalidFieldException("Unknown fixed field");
                this.vfMustEvaluate = bl;
            }
            return;
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(int): Invalid Index: " + n);
            }
            this.fieldValueMap.put(n, (Object)new Boolean(bl));
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(1, vRMLFieldDeclaration.getName(), bl);
            }
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(boolean[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (n2 != 0) {
            boolean[] blArray2 = (boolean[])this.fieldValueMap.get(n);
            if (blArray2 == null || blArray2.length < n2) {
                blArray2 = new boolean[n2];
                this.fieldValueMap.put(n, (Object)blArray2);
            }
            System.arraycopy(blArray, 0, blArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(2, vRMLFieldDeclaration.getName(), blArray, n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(float): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, (Object)new Float(f));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), f);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(float[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (n2 != 0) {
            float[] fArray2 = (float[])this.fieldValueMap.get(n);
            if (fArray2 == null || fArray2.length < n2) {
                fArray2 = new float[n2];
                this.fieldValueMap.put(n, (Object)fArray2);
            }
            System.arraycopy(fArray, 0, fArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), fArray, n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(long): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, (Object)new Long(l));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), l);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(long): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (n2 != 0) {
            long[] lArray2 = (long[])this.fieldValueMap.get(n);
            if (lArray2 == null || lArray2.length < n2) {
                lArray2 = new long[n2];
                this.fieldValueMap.put(n, (Object)lArray2);
            }
            System.arraycopy(lArray, 0, lArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), lArray, n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(double): Invalid Index: " + n);
        }
        this.fieldValueMap.put(n, (Object)new Double(d));
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), d);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(double): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (n2 != 0) {
            double[] dArray2 = (double[])this.fieldValueMap.get(n);
            if (dArray2 == null || dArray2.length < n2) {
                dArray2 = new double[n2];
                this.fieldValueMap.put(n, (Object)dArray2);
            }
            System.arraycopy(dArray, 0, dArray2, 0, n2);
        }
        if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
            this.realScript.queueEvent(vRMLFieldDeclaration.getFieldType(), vRMLFieldDeclaration.getName(), dArray, n2);
        }
        this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
        this.fireFieldChanged(n);
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        if (n == this.FIELD_URL) {
            this.setUrl(new String[]{string}, 1);
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(String): Invalid Index: " + n);
            }
            this.fieldValueMap.put(n, (Object)string);
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(27, vRMLFieldDeclaration.getName(), string);
            }
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        if (n == this.FIELD_URL) {
            this.setUrl(stringArray, n2);
        } else {
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            if (vRMLFieldDeclaration == null) {
                throw new InvalidFieldException("setValue(String[]): Invalid Index: " + n);
            }
            this.fieldSizeMap.put(n, (Object)new Integer(n2));
            if (n2 != 0) {
                String[] stringArray2 = (String[])this.fieldValueMap.get(n);
                if (stringArray2 == null || stringArray2.length < n2) {
                    stringArray2 = new String[n2];
                    this.fieldValueMap.put(n, (Object)stringArray2);
                }
                System.arraycopy(stringArray, 0, stringArray2, 0, n2);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(28, vRMLFieldDeclaration.getName(), stringArray, n2);
            }
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(node): Invalid Index: " + n);
        }
        if (this.inSetup && vRMLFieldDeclaration.getFieldType() == 12) {
            Object object = this.fieldValueMap.get(n);
            if (object == null) {
                this.fieldValueMap.put(n, (Object)vRMLNodeType);
                this.fieldSizeMap.put(n, (Object)new Integer(1));
            } else if (object instanceof VRMLNodeType) {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[]{(VRMLNodeType)object, vRMLNodeType};
                this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray);
                this.fieldSizeMap.put(n, (Object)new Integer(2));
            } else {
                VRMLNodeType[] vRMLNodeTypeArray = (VRMLNodeType[])object;
                Integer n2 = (Integer)this.fieldSizeMap.get(n);
                int n3 = n2;
                if (vRMLNodeTypeArray.length == n3) {
                    VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[n3 + 4];
                    System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray2, 0, n3);
                    vRMLNodeTypeArray = vRMLNodeTypeArray2;
                    this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray2);
                }
                vRMLNodeTypeArray[n3] = vRMLNodeType;
                this.fieldSizeMap.put(n, (Object)new Integer(n3 + 1));
            }
        } else {
            if (n == this.FIELD_METADATA) {
                this.vfMetadata = vRMLNodeType;
            } else {
                this.fieldValueMap.put(n, (Object)vRMLNodeType);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                if (vRMLFieldDeclaration.getFieldType() == 11) {
                    this.realScript.queueEvent(11, vRMLFieldDeclaration.getName(), vRMLNodeType);
                } else {
                    this.realScript.queueEvent(12, vRMLFieldDeclaration.getName(), vRMLNodeType);
                }
            }
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            this.fireFieldChanged(n);
            this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("setValue(node[]): Invalid Index: " + n);
        }
        this.fieldSizeMap.put(n, (Object)new Integer(n2));
        if (this.inSetup) {
            Object object = this.fieldValueMap.get(n);
            if (object == null) {
                this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray);
            } else if (object instanceof VRMLNodeType) {
                VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[vRMLNodeTypeArray.length + 1];
                vRMLNodeTypeArray2[0] = (VRMLNodeType)object;
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray2, 1, vRMLNodeTypeArray.length);
                this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray2);
            } else {
                VRMLNodeType[] vRMLNodeTypeArray3 = (VRMLNodeType[])object;
                int n3 = vRMLNodeTypeArray3.length + vRMLNodeTypeArray.length;
                VRMLNodeType[] vRMLNodeTypeArray4 = new VRMLNodeType[n3];
                System.arraycopy(vRMLNodeTypeArray3, 0, vRMLNodeTypeArray4, 0, vRMLNodeTypeArray3.length);
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray4, vRMLNodeTypeArray3.length, vRMLNodeTypeArray.length);
                this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray4);
            }
        } else {
            if (n2 != 0) {
                VRMLNodeType[] vRMLNodeTypeArray5 = (VRMLNodeType[])this.fieldValueMap.get(n);
                if (vRMLNodeTypeArray5 == null || vRMLNodeTypeArray5.length < n2) {
                    vRMLNodeTypeArray5 = new VRMLNodeType[n2];
                    this.fieldValueMap.put(n, (Object)vRMLNodeTypeArray5);
                }
                System.arraycopy(vRMLNodeTypeArray, 0, vRMLNodeTypeArray5, 0, n2);
            }
            if (this.realScript != null && this.shouldUpdate(n, vRMLFieldDeclaration)) {
                this.realScript.queueEvent(12, vRMLFieldDeclaration.getName(), vRMLNodeTypeArray, n2);
            }
            this.fieldChangedMap.put(n, (Object)Boolean.TRUE);
            this.fireFieldChanged(n);
        }
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public boolean checkValidContentType(String string) {
        if (this.majorVersion == 2) {
            return validVrml97Types.contains((Object)string);
        }
        return validX3DTypes.contains((Object)string);
    }

    public int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException, InvalidFieldException {
        if (this.majorVersion == 2) {
            if (vRMLFieldDeclaration.getAccessType() == 3) {
                throw new InvalidFieldException(VRML97_EXPOSED_MSG + vRMLFieldDeclaration.getName());
            }
            switch (vRMLFieldDeclaration.getFieldType()) {
                case 2: 
                case 7: 
                case 8: 
                case 17: 
                case 18: 
                case 23: 
                case 24: 
                case 26: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    throw new InvalidFieldException(VRML97_FIELD_MSG + vRMLFieldDeclaration.getFieldTypeString() + " field name " + vRMLFieldDeclaration.getName());
                }
            }
        }
        int n = super.appendField(vRMLFieldDeclaration);
        this.fieldChangedMap.put(n, (Object)Boolean.FALSE);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                this.fieldValueMap.put(n, (Object)new Integer(0));
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 4: {
                this.fieldValueMap.put(n, (Object)FieldConstants.EMPTY_MFINT32);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 5: {
                this.fieldValueMap.put(n, (Object)new Float(0.0f));
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 7: {
                this.fieldValueMap.put(n, (Object)new Double(0.0));
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 31: {
                this.fieldValueMap.put(n, (Object)new Long(0L));
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 32: {
                this.fieldValueMap.put(n, (Object)FieldConstants.EMPTY_MFLONG);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 1: {
                this.fieldValueMap.put(n, (Object)Boolean.TRUE);
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 2: {
                this.fieldValueMap.put(n, (Object)FieldConstants.EMPTY_MFBOOL);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 9: {
                this.fieldValueMap.put(n, (Object)new Double(0.0));
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 11: {
                this.fieldValueMap.put(n, null);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 12: {
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 21: {
                this.fieldValueMap.put(n, (Object)new float[3]);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 23: {
                this.fieldValueMap.put(n, (Object)new float[4]);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 27: {
                this.fieldValueMap.put(n, (Object)"");
                this.fieldSizeMap.put(n, (Object)SINGLE_SIZE);
                break;
            }
            case 28: {
                this.fieldValueMap.put(n, (Object)FieldConstants.EMPTY_MFSTRING);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.fieldValueMap.put(n, (Object)new float[0]);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 8: 
            case 10: 
            case 17: 
            case 18: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.fieldValueMap.put(n, (Object)new double[0]);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 25: {
                this.fieldValueMap.put(n, (Object)new int[3]);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
                break;
            }
            case 26: {
                this.fieldValueMap.put(n, (Object)FieldConstants.EMPTY_MFIMAGE);
                this.fieldSizeMap.put(n, (Object)ZERO_SIZE);
            }
        }
        return n;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.isStatic = bl;
        this.isVrml97 = n == 2;
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length + this.fieldCount) {
            throw new InvalidFieldException("Invalid index in setUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.hasChanged.length + this.fieldCount) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    protected void copy(BaseScript baseScript) {
        List list = baseScript.getAllFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)list.get(i);
            if (vRMLFieldDeclaration == null || forbiddenFields.contains((Object)vRMLFieldDeclaration.getName())) continue;
            try {
                int n2 = this.appendField(vRMLFieldDeclaration);
                int n3 = vRMLFieldDeclaration.getAccessType();
                if (n3 == 1 || n3 == 4) continue;
                VRMLFieldData vRMLFieldData = baseScript.getFieldValue(i);
                this.copyField(i, vRMLFieldData);
                continue;
            }
            catch (FieldException fieldException) {
                System.out.println("Error copying field in abstract node");
                fieldException.printStackTrace();
            }
        }
    }

    private void sendValue(VRMLNodeType vRMLNodeType, int n, Object object, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                vRMLNodeType.setValue(n, ((Integer)object).intValue());
                break;
            }
            case 4: 
            case 25: 
            case 26: {
                vRMLNodeType.setValue(n, (int[])object, n2);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, ((Float)object).floatValue());
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 33: 
            case 37: 
            case 39: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 7: {
                vRMLNodeType.setValue(n, ((Double)object).doubleValue());
                break;
            }
            case 8: 
            case 17: 
            case 35: 
            case 41: 
            case 43: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 31: {
                vRMLNodeType.setValue(n, ((Long)object).longValue());
                break;
            }
            case 32: {
                vRMLNodeType.setValue(n, (long[])object, n2);
                break;
            }
            case 1: {
                vRMLNodeType.setValue(n, ((Boolean)object).booleanValue());
                break;
            }
            case 2: {
                vRMLNodeType.setValue(n, (boolean[])object, n2);
                break;
            }
            case 27: {
                vRMLNodeType.setValue(n, (String)object);
                break;
            }
            case 28: {
                vRMLNodeType.setValue(n, (String[])object, n2);
                break;
            }
            case 9: {
                vRMLNodeType.setValue(n, ((Double)object).doubleValue());
                break;
            }
            case 10: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 11: {
                vRMLNodeType.setValue(n, (VRMLNodeType)object);
                break;
            }
            case 12: {
                vRMLNodeType.setValue(n, (VRMLNodeType[])object, n2);
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 34: 
            case 38: 
            case 40: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 18: 
            case 36: 
            case 42: 
            case 44: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            default: {
                System.out.println("Unhandled case in Script.sendValue" + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
    }

    private boolean fetchValue(int n) throws InvalidFieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(this.nodeName, n);
        }
        Object object = this.fieldValueMap.get(n);
        Integer n2 = (Integer)this.fieldSizeMap.get(n);
        int n3 = n2 == null ? 0 : n2;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                this.fieldData.intValue = (Integer)object;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 4: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)9;
                break;
            }
            case 5: {
                this.fieldData.floatValue = ((Float)object).floatValue();
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 7: {
                this.fieldData.doubleValue = (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 8: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 31: {
                this.fieldData.longValue = (Long)object;
                this.fieldData.dataType = (short)3;
                break;
            }
            case 32: {
                this.fieldData.longArrayValue = (long[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)10;
                break;
            }
            case 1: {
                this.fieldData.booleanValue = (Boolean)object;
                this.fieldData.dataType = 1;
                break;
            }
            case 2: {
                this.fieldData.booleanArrayValue = (boolean[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)8;
                break;
            }
            case 9: {
                this.fieldData.doubleValue = (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 10: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 27: {
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 28: {
                if (object instanceof String[]) {
                    this.fieldData.stringArrayValue = (String[])object;
                    this.fieldData.numElements = n3;
                    this.fieldData.dataType = (short)14;
                    break;
                }
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 11: {
                this.fieldData.nodeValue = (VRMLNodeType)object;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 12: {
                if (object instanceof VRMLNodeType) {
                    this.fieldData.nodeArrayValue = new VRMLNodeType[1];
                    this.fieldData.nodeArrayValue[0] = (VRMLNodeType)object;
                } else {
                    this.fieldData.nodeArrayValue = (VRMLNodeType[])object;
                }
                this.fieldData.numElements = n3;
                this.fieldData.dataType = (short)13;
                break;
            }
            case 13: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 2 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 14: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3 / 2;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 15: 
            case 21: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 3 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 19: 
            case 23: 
            case 33: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = object == null || this.fieldData.floatArrayValue.length < 4 ? 0 : 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 16: 
            case 22: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3 / 3;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 20: 
            case 24: 
            case 34: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3 / 4;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 29: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object == null || this.fieldData.doubleArrayValue.length < 2 ? 0 : 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 17: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object == null || this.fieldData.doubleArrayValue.length < 3 ? 0 : 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 35: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = object == null || this.fieldData.doubleArrayValue.length < 4 ? 0 : 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 30: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3 / 2;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 18: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3 / 3;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 36: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3 / 4;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 37: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 39: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 41: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 43: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 38: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3 / 9;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 40: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.numElements = n3 / 16;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 42: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3 / 9;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 44: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.numElements = n3 / 16;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 25: 
            case 26: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.numElements = object != null ? this.fieldData.intArrayValue.length : 0;
                this.fieldData.dataType = (short)9;
            }
        }
        return true;
    }

    private void copyField(int n, VRMLFieldData vRMLFieldData) throws FieldException {
        int n2 = 0;
        switch (vRMLFieldData.dataType) {
            case 1: {
                this.setValue(n, vRMLFieldData.booleanValue);
                break;
            }
            case 8: {
                boolean[] blArray = null;
                if (vRMLFieldData.numElements != 0) {
                    blArray = new boolean[vRMLFieldData.numElements];
                    System.arraycopy(vRMLFieldData.booleanArrayValue, 0, blArray, 0, vRMLFieldData.numElements);
                }
                this.setValue(n, blArray, vRMLFieldData.numElements);
                break;
            }
            case 2: {
                this.setValue(n, vRMLFieldData.intValue);
                break;
            }
            case 9: {
                int[] nArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.intArrayValue.length;
                    nArray = new int[n2];
                    System.arraycopy(vRMLFieldData.intArrayValue, 0, nArray, 0, n2);
                }
                this.setValue(n, nArray, n2);
                break;
            }
            case 3: {
                this.setValue(n, vRMLFieldData.longValue);
                break;
            }
            case 10: {
                long[] lArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.longArrayValue.length;
                    lArray = new long[n2];
                    System.arraycopy(vRMLFieldData.longArrayValue, 0, lArray, 0, n2);
                }
                this.setValue(n, lArray, n2);
                break;
            }
            case 4: {
                this.setValue(n, vRMLFieldData.floatValue);
                break;
            }
            case 11: {
                float[] fArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.floatArrayValue.length;
                    fArray = new float[n2];
                    System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, n2);
                }
                this.setValue(n, fArray, n2);
                break;
            }
            case 5: {
                this.setValue(n, vRMLFieldData.doubleValue);
                break;
            }
            case 12: {
                double[] dArray = null;
                if (vRMLFieldData.numElements != 0) {
                    n2 = vRMLFieldData.doubleArrayValue.length;
                    dArray = new double[n2];
                    System.arraycopy(vRMLFieldData.doubleArrayValue, 0, dArray, 0, n2);
                }
                this.setValue(n, dArray, n2);
                break;
            }
            case 6: {
                this.setValue(n, vRMLFieldData.stringValue);
                break;
            }
            case 14: {
                String[] stringArray = null;
                if (vRMLFieldData.numElements != 0) {
                    stringArray = new String[vRMLFieldData.numElements];
                    System.arraycopy(vRMLFieldData.stringArrayValue, 0, stringArray, 0, vRMLFieldData.numElements);
                }
                this.setValue(n, stringArray, vRMLFieldData.numElements);
                break;
            }
        }
    }

    protected void fireUrlChanged() {
        int n = this.urlListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, this.FIELD_URL);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, this.FIELD_URL, this.loadState);
        }
    }

    private boolean shouldUpdate(int n, VRMLFieldDeclaration vRMLFieldDeclaration) {
        boolean bl = true;
        if (this.eventOutProcessingInProgress) {
            switch (vRMLFieldDeclaration.getAccessType()) {
                case 1: 
                case 3: {
                    Boolean bl2 = (Boolean)this.fieldChangedMap.get(n);
                    bl = bl2 == false;
                    break;
                }
                case 2: 
                case 4: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    static {
        int n;
        ZERO_SIZE = new Integer(0);
        SINGLE_SIZE = new Integer(1);
        VRML97_MIME_TYPES = new String[]{"application/x-javascript", "application/javascript", "application/x-java", "application/java"};
        X3D_MIME_TYPES = new String[]{"application/x-ecmascript", "application/ecmascript", "application/x-java", "application/java"};
        SECONDARY_TYPE = new int[]{44};
        validVrml97Types = new HashSet();
        for (n = 0; n < VRML97_MIME_TYPES.length; ++n) {
            validVrml97Types.add((Object)VRML97_MIME_TYPES[n]);
        }
        validX3DTypes = new HashSet();
        for (n = 0; n < X3D_MIME_TYPES.length; ++n) {
            validX3DTypes.add((Object)X3D_MIME_TYPES[n]);
        }
        forbiddenFields = new HashSet();
        forbiddenFields.add((Object)"metadata");
        forbiddenFields.add((Object)"url");
        forbiddenFields.add((Object)"mustEvaluate");
        forbiddenFields.add((Object)"directOutput");
    }
}

