/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseDragSensorNode;

public abstract class BasePlaneSensor
extends BaseDragSensorNode {
    protected static final int FIELD_MAXPOSITION = 7;
    protected static final int FIELD_MINPOSITION = 8;
    protected static final int FIELD_TRANSLATION_CHANGED = 9;
    protected static final int FIELD_OFFSET = 10;
    protected static final int LAST_PLANESENSOR_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    private float[] plane_normal;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfMaxPosition;
    protected float[] vfMinPosition;
    protected float[] vfOffset;
    protected float[] vfTranslationChanged;

    public BasePlaneSensor() {
        super("PlaneSensor");
        this.hasChanged = new boolean[11];
        this.vfOffset = new float[3];
        this.vfTranslationChanged = new float[3];
        this.vfMinPosition = new float[2];
        this.vfMaxPosition = new float[]{-1.0f, -1.0f};
        this.plane_normal = new float[4];
        this.plane_normal[2] = 1.0f;
    }

    public BasePlaneSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLDragSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("offset");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOffset[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOffset[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOffset[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("minPosition");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinPosition[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMinPosition[1] = vRMLFieldData.floatArrayValue[1];
            n = vRMLNodeType.getFieldIndex("maxPosition");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMaxPosition[0] = vRMLFieldData.floatArrayValue[0];
            this.vfMaxPosition[1] = vRMLFieldData.floatArrayValue[1];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void notifySensorDragEnd(float[] fArray, float[] fArray2) {
        super.notifySensorDragEnd(fArray, fArray2);
        if (this.vfAutoOffset) {
            this.vfOffset[0] = this.vfTranslationChanged[0];
            this.vfOffset[1] = this.vfTranslationChanged[1];
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfTranslationChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfMaxPosition;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfMinPosition;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOffset;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfTranslationChanged, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfMaxPosition, 2);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfMinPosition, 2);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfOffset, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BasePlaneSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BasePlaneSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.vfMinPosition[0] = fArray[0];
                this.vfMinPosition[1] = fArray[1];
                if (this.inSetup) break;
                this.hasChanged[n] = true;
                this.fireFieldChanged(n);
                break;
            }
            case 7: {
                this.vfMaxPosition[0] = fArray[0];
                this.vfMaxPosition[1] = fArray[1];
                if (this.inSetup) break;
                this.hasChanged[n] = true;
                this.fireFieldChanged(n);
                break;
            }
            case 10: {
                this.vfOffset[0] = fArray[0];
                this.vfOffset[1] = fArray[1];
                this.vfOffset[2] = fArray[2];
                if (this.inSetup) break;
                this.hasChanged[n] = true;
                this.fireFieldChanged(n);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void processDrag(float[] fArray, float[] fArray2) {
        this.plane_normal[3] = -this.initialPosition[2];
        if (!intersectionUtils.rayPlane(fArray, fArray2, this.plane_normal, wkPoint)) {
            return;
        }
        float f = wkPoint[0] - this.initialPosition[0] + this.vfOffset[0];
        float f2 = wkPoint[1] - this.initialPosition[1] + this.vfOffset[1];
        float f3 = f;
        float f4 = f2;
        if (this.vfMaxPosition[0] >= this.vfMinPosition[0]) {
            if (f >= this.vfMaxPosition[0]) {
                f3 = this.vfMaxPosition[0];
            }
            if (f < this.vfMinPosition[0]) {
                f3 = this.vfMinPosition[0];
            }
        }
        if (this.vfMaxPosition[1] >= this.vfMinPosition[1]) {
            if (f2 >= this.vfMaxPosition[1]) {
                f4 = this.vfMaxPosition[1];
            }
            if (f2 < this.vfMinPosition[1]) {
                f4 = this.vfMinPosition[1];
            }
        }
        this.vfTranslationChanged[0] = f3;
        this.vfTranslationChanged[1] = f4;
        this.vfTranslationChanged[2] = this.vfOffset[2];
        this.hasChanged[9] = true;
        this.fireFieldChanged(9);
        this.vfTrackPointChanged[0] = f;
        this.vfTrackPointChanged[1] = f2;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BasePlaneSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePlaneSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BasePlaneSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "autoOffset");
        BasePlaneSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "trackPoint_changed");
        BasePlaneSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BasePlaneSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BasePlaneSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFVec3f", "translation_changed");
        BasePlaneSensor.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFVec2f", "minPosition");
        BasePlaneSensor.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFVec2f", "maxPosition");
        BasePlaneSensor.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFVec3f", "offset");
        BasePlaneSensor.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFString", "description");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(5);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("isOver", new Integer(6));
        fieldMap.put("trackPoint_changed", new Integer(4));
        n = new Integer(3);
        fieldMap.put("autoOffset", n);
        fieldMap.put("set_autoOffset", n);
        fieldMap.put("autoOffset_changed", n);
        n = new Integer(10);
        fieldMap.put("offset", n);
        fieldMap.put("set_offset", n);
        fieldMap.put("offset_changed", n);
        n = new Integer(7);
        fieldMap.put("maxPosition", n);
        fieldMap.put("set_maxPosition", n);
        fieldMap.put("maxPosition_changed", n);
        n = new Integer(8);
        fieldMap.put("minPosition", n);
        fieldMap.put("set_minPosition", n);
        fieldMap.put("minPosition_changed", n);
        fieldMap.put("translation_changed", new Integer(9));
    }
}

