/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseDragSensorNode;

public abstract class BaseSphereSensor
extends BaseDragSensorNode {
    protected static final int FIELD_ROTATION_CHANGED = 9;
    protected static final int FIELD_OFFSET = 10;
    protected static final int LAST_PLANESENSOR_INDEX = 10;
    protected static final int NUM_FIELDS = 11;
    private static final float[] ORIGIN = new float[3];
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfOffset;
    protected float[] vfRotationChanged;
    private float dragRadius;
    private float[] initialNormal;

    public BaseSphereSensor() {
        super("SphereSensor");
        this.hasChanged = new boolean[11];
        this.vfOffset = new float[4];
        this.vfRotationChanged = new float[4];
        this.initialNormal = new float[3];
    }

    public BaseSphereSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLDragSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("offset");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOffset[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOffset[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOffset[2] = vRMLFieldData.floatArrayValue[2];
            this.vfOffset[3] = vRMLFieldData.floatArrayValue[3];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void notifySensorDragStart(float[] fArray, float[] fArray2) {
        super.notifySensorDragStart(fArray, fArray2);
        this.dragRadius = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        this.initialNormal[0] = fArray[0] / this.dragRadius;
        this.initialNormal[1] = fArray[1] / this.dragRadius;
        this.initialNormal[2] = fArray[2] / this.dragRadius;
    }

    public void notifySensorDragEnd(float[] fArray, float[] fArray2) {
        super.notifySensorDragEnd(fArray, fArray2);
        if (this.vfAutoOffset) {
            this.vfOffset[0] = this.vfRotationChanged[0];
            this.vfOffset[1] = this.vfRotationChanged[1];
            this.vfOffset[2] = this.vfRotationChanged[2];
            this.vfOffset[3] = this.vfRotationChanged[3];
            this.hasChanged[10] = true;
            this.fireFieldChanged(10);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfRotationChanged;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOffset;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfRotationChanged, 4);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfOffset, 4);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseSphereSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseSphereSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 10: {
                this.vfOffset[0] = fArray[0];
                this.vfOffset[1] = fArray[1];
                this.vfOffset[2] = fArray[2];
                this.vfOffset[3] = fArray[3];
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    protected void processDrag(float[] fArray, float[] fArray2) {
        if (!intersectionUtils.raySphere(fArray, fArray2, ORIGIN, this.dragRadius, wkPoint)) {
            return;
        }
        float f = (float)Math.sqrt(wkPoint[0] * wkPoint[0] + wkPoint[1] * wkPoint[1] + wkPoint[2] * wkPoint[2]);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (f != 0.0f) {
            f2 = wkPoint[0] / f;
            f3 = wkPoint[1] / f;
            f4 = wkPoint[2] / f;
        }
        this.vfTrackPointChanged[0] = f2;
        this.vfTrackPointChanged[1] = f3;
        this.vfTrackPointChanged[2] = f4;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
        float f5 = this.initialPosition[0];
        float f6 = this.initialPosition[1];
        float f7 = this.initialPosition[2];
        float f8 = wkPoint[0];
        float f9 = wkPoint[1];
        float f10 = wkPoint[2];
        float f11 = f6 * f10 - f7 * f9;
        float f12 = f7 * f8 - f5 * f10;
        float f13 = f5 * f9 - f6 * f8;
        double d = this.initialNormal[0] * f2 + this.initialNormal[1] * f3 + this.initialNormal[2] * f4;
        float f14 = (float)Math.acos(d);
        this.vfRotationChanged[0] = f11;
        this.vfRotationChanged[1] = f12;
        this.vfRotationChanged[2] = f13;
        this.vfRotationChanged[3] = f14;
        this.hasChanged[9] = true;
        this.fireFieldChanged(9);
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseSphereSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSphereSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseSphereSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "autoOffset");
        BaseSphereSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "trackPoint_changed");
        BaseSphereSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseSphereSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BaseSphereSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFRotation", "rotation_changed");
        BaseSphereSensor.fieldDecl[10] = new VRMLFieldDeclaration(3, "SFRotation", "offset");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("isOver", new Integer(6));
        fieldMap.put("trackPoint_changed", new Integer(4));
        n = new Integer(3);
        fieldMap.put("autoOffset", n);
        fieldMap.put("set_autoOffset", n);
        fieldMap.put("autoOffset_changed", n);
        n = new Integer(10);
        fieldMap.put("offset", n);
        fieldMap.put("set_offset", n);
        fieldMap.put("offset_changed", n);
        fieldMap.put("rotation_changed", new Integer(9));
    }
}

