/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.awt.event.KeyEvent;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public class BaseStringSensor
extends BaseSensorNode
implements VRMLKeyDeviceSensorNodeType {
    protected static final int FIELD_DELETION_ALLOWED = 3;
    protected static final int FIELD_ENTERED_TEXT = 4;
    protected static final int FIELD_FINAL_TEXT = 5;
    protected static final int LAST_STRINGSENSOR_INDEX = 5;
    protected static final int NUM_FIELDS = 6;
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected String vfEnteredText;
    protected String vfFinalText;
    protected boolean vfDeletionAllowed;
    private StringBuffer workingString;

    public BaseStringSensor() {
        super("StringSensor");
        this.hasChanged = new boolean[6];
        this.vfDeletionAllowed = true;
    }

    public BaseStringSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("deletionAllowed");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDeletionAllowed = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean requiresLastEventOnly() {
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 8: {
                if (!this.vfDeletionAllowed || this.workingString == null) break;
                int n = this.workingString.length();
                this.workingString.deleteCharAt(n - 1);
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 10: {
                this.vfFinalText = this.workingString.toString();
                this.vfEnteredText = null;
                this.workingString = null;
                this.vfIsActive = false;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            default: 
        }
        char c = keyEvent.getKeyChar();
        if (Character.getType(c) == 15) {
            return;
        }
        if (this.workingString == null) {
            this.workingString = new StringBuffer();
            this.vfIsActive = true;
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
        this.workingString.append(c);
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 26;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfDeletionAllowed;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                if (this.workingString != null) {
                    this.fieldData.stringValue = this.vfEnteredText = this.workingString.toString();
                }
                this.fieldData.dataType = (short)6;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfFinalText;
                this.fieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfDeletionAllowed);
                    break;
                }
                case 4: {
                    if (this.workingString != null) {
                        this.vfEnteredText = this.workingString.toString();
                    }
                    vRMLNodeType.setValue(n2, this.vfEnteredText);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfFinalText);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.vfDeletionAllowed = bl;
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[6];
        fieldMap = new HashMap(18);
        BaseStringSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseStringSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseStringSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseStringSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFString", "enteredText");
        BaseStringSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFString", "finalText");
        BaseStringSensor.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFBool", "deletionAllowed");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(5);
        fieldMap.put("finalText", n);
        fieldMap.put("finalText_changed", n);
        n = new Integer(4);
        fieldMap.put("enteredText", n);
        fieldMap.put("enteredText_changed", n);
        n = new Integer(3);
        fieldMap.put("deletionAllowed", n);
        fieldMap.put("deletionAllowed_changed", n);
        fieldMap.put("set_deletionAllowed", n);
        fieldMap.put("isActive", new Integer(2));
    }
}

