/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLAppearanceChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseFillProperties
extends AbstractNode
implements VRMLAppearanceChildNodeType {
    protected static final int FIELD_HATCHSTYLE = 1;
    protected static final int FIELD_HATCHCOLOR = 2;
    protected static final int FIELD_FILLSTYLE = 3;
    protected static final int NUM_FIELDS = 2;
    protected static final String FILL_TYPE_NONE = "NONE";
    protected static final String FILL_TYPE_HATCH = "HATCHED";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String vfFillStyle;
    protected int vfHatchStyle;
    protected float[] vfHatchColor;

    protected BaseFillProperties() {
        super("FillProperties");
        this.hasChanged = new boolean[2];
        this.vfFillStyle = FILL_TYPE_NONE;
        this.vfHatchStyle = 0;
        this.vfHatchColor = new float[3];
    }

    protected BaseFillProperties(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("fillStyle");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFillStyle = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("hatchStyle");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHatchStyle = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("hatchColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfHatchColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfHatchColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfHatchColor[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 1;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfFillStyle;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 1: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfHatchStyle;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfHatchColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfFillStyle);
                    break;
                }
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfHatchStyle);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfHatchColor, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setHatchStyle(n2);
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setHatchColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setFillStyle(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    protected void setFillStyle(String string) {
        this.vfFillStyle = string;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected void setHatchColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"FillProperties.hatchColor", (float[])fArray);
        this.vfHatchColor[0] = fArray[0];
        this.vfHatchColor[1] = fArray[1];
        this.vfHatchColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    protected void setHatchStyle(int n) throws InvalidFieldValueException {
        if (n < 0) {
            throw new InvalidFieldValueException("The linestyle is < 0: " + n);
        }
        this.vfHatchStyle = n;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseFillProperties.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseFillProperties.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFInt32", "hatchStyle");
        BaseFillProperties.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "hatchColor");
        BaseFillProperties.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFString", "fillStyle");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("hatchStyle", n);
        fieldMap.put("set_hatchStyle", n);
        fieldMap.put("hatchStyle_changed", n);
        n = new Integer(2);
        fieldMap.put("hatchColor", n);
        fieldMap.put("set_hatchColor", n);
        fieldMap.put("hatchColor_changed", n);
        n = new Integer(3);
        fieldMap.put("fillStyle", n);
        fieldMap.put("set_fillStyle", n);
        fieldMap.put("fillStyle_changed", n);
    }
}

