/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.shape;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.MaterialColorListener;
import org.web3d.vrml.nodes.MaterialColorListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMaterialNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseMaterial
extends AbstractNode
implements VRMLMaterialNodeType {
    protected static final int FIELD_AMBIENT_INTENSITY = 1;
    protected static final int FIELD_DIFFUSE_COLOR = 2;
    protected static final int FIELD_EMISSIVE_COLOR = 3;
    protected static final int FIELD_SHININESS = 4;
    protected static final int FIELD_SPECULAR_COLOR = 5;
    protected static final int FIELD_TRANSPARENCY = 6;
    protected static final int NUM_FIELDS = 7;
    private static final String EMISSIVE_ERROR_MSG = "Error sending emissive changed notification to: ";
    private static final VRMLFieldDeclaration[] fieldDecl;
    private static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected float vfAmbientIntensity;
    protected float[] vfDiffuseColor;
    protected float[] vfEmissiveColor;
    protected float vfShininess;
    protected float[] vfSpecularColor;
    protected float vfTransparency;
    protected boolean ignoreDiffuse;
    private MaterialColorListener colorListener;
    private float[] flScratch;

    protected BaseMaterial() {
        super("Material");
        this.hasChanged = new boolean[7];
        this.vfAmbientIntensity = 0.2f;
        this.vfDiffuseColor = new float[]{0.8f, 0.8f, 0.8f};
        this.vfEmissiveColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfShininess = 0.2f;
        this.vfSpecularColor = new float[]{0.0f, 0.0f, 0.0f};
        this.vfTransparency = 0.0f;
        this.ignoreDiffuse = false;
    }

    protected BaseMaterial(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("shininess");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfShininess = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("transparency");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTransparency = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("ambientIntensity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAmbientIntensity = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("diffuseColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfDiffuseColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfDiffuseColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfDiffuseColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("emissiveColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfEmissiveColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfEmissiveColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfEmissiveColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("specularColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpecularColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfSpecularColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfSpecularColor[2] = vRMLFieldData.floatArrayValue[2];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.ambientIntensity", (float)f);
        this.vfAmbientIntensity = f;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    public float getAmbientIntensity() {
        return this.vfAmbientIntensity;
    }

    public void setDiffuseColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.diffuseColor", (float[])fArray);
        this.vfDiffuseColor[0] = fArray[0];
        this.vfDiffuseColor[1] = fArray[1];
        this.vfDiffuseColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[2] = true;
            this.fireFieldChanged(2);
        }
    }

    public float[] getDiffuseColor() {
        return this.vfDiffuseColor;
    }

    public void setEmissiveColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.emmissiveColor", (float[])fArray);
        this.vfEmissiveColor[0] = fArray[0];
        this.vfEmissiveColor[1] = fArray[1];
        this.vfEmissiveColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
            this.fireEmissiveColorChanged(this.colorListener);
        }
    }

    public float[] getEmissiveColor() {
        return this.vfEmissiveColor;
    }

    public void setShininess(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.shininess", (float)f);
        this.vfShininess = f;
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public float getShininess() {
        return this.vfShininess;
    }

    public void setSpecularColor(float[] fArray) throws InvalidFieldValueException {
        FieldValidator.checkColorVector((String)"Material.specularColor", (float[])fArray);
        this.vfSpecularColor[0] = fArray[0];
        this.vfSpecularColor[1] = fArray[1];
        this.vfSpecularColor[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    public float[] getSpecularColor() {
        return this.vfSpecularColor;
    }

    public void setTransparency(float f) throws InvalidFieldValueException {
        FieldValidator.checkFloat((String)"Material.transparency", (float)f);
        this.vfTransparency = f;
        if (!this.inSetup) {
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    public void setIgnoreDiffuse(boolean bl) {
        this.ignoreDiffuse = bl;
    }

    public float getTransparency() {
        return this.vfTransparency;
    }

    public void addMaterialColorListener(MaterialColorListener materialColorListener) {
        this.colorListener = MaterialColorListenerMulticaster.add((MaterialColorListener)this.colorListener, (MaterialColorListener)materialColorListener);
        if (materialColorListener != null) {
            this.fireEmissiveColorChanged(materialColorListener);
        }
    }

    public void removeMaterialColorListener(MaterialColorListener materialColorListener) {
        this.colorListener = MaterialColorListenerMulticaster.remove((MaterialColorListener)this.colorListener, (MaterialColorListener)materialColorListener);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 29;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfAmbientIntensity;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfDiffuseColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfEmissiveColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfTransparency;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfShininess;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfSpecularColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfAmbientIntensity);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfDiffuseColor, 3);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfEmissiveColor, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfShininess);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfSpecularColor, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfTransparency);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setAmbientIntensity(f);
                break;
            }
            case 4: {
                this.setShininess(f);
                break;
            }
            case 6: {
                this.setTransparency(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setDiffuseColor(fArray);
                break;
            }
            case 3: {
                this.setEmissiveColor(fArray);
                break;
            }
            case 5: {
                this.setSpecularColor(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void fireEmissiveColorChanged(MaterialColorListener materialColorListener) {
        try {
            if (materialColorListener != null) {
                materialColorListener.emissiveColorChanged(this.vfEmissiveColor);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.errorReporter.errorReport(EMISSIVE_ERROR_MSG + materialColorListener, (Exception)throwable);
            }
            System.out.println("Unknown BAAAAD error: " + throwable);
            throwable.printStackTrace();
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseMaterial.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMaterial.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFFloat", "ambientIntensity");
        BaseMaterial.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFColor", "diffuseColor");
        BaseMaterial.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFColor", "emissiveColor");
        BaseMaterial.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "shininess");
        BaseMaterial.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFColor", "specularColor");
        BaseMaterial.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "transparency");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("ambientIntensity", n);
        fieldMap.put("set_ambientIntensity", n);
        fieldMap.put("ambientIntensity_changed", n);
        n = new Integer(6);
        fieldMap.put("transparency", n);
        fieldMap.put("set_transparency", n);
        fieldMap.put("transparency_changed", n);
        n = new Integer(2);
        fieldMap.put("diffuseColor", n);
        fieldMap.put("set_diffuseColor", n);
        fieldMap.put("diffuseColor_changed", n);
        n = new Integer(3);
        fieldMap.put("emissiveColor", n);
        fieldMap.put("set_emissiveColor", n);
        fieldMap.put("emissiveColor_changed", n);
        n = new Integer(4);
        fieldMap.put("shininess", n);
        fieldMap.put("set_shininess", n);
        fieldMap.put("shininess_changed", n);
        n = new Integer(5);
        fieldMap.put("specularColor", n);
        fieldMap.put("set_specularColor", n);
        fieldMap.put("specularColor_changed", n);
    }
}

