/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sound;

import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLSoundStateListener;
import org.web3d.vrml.nodes.VRMLTimeControlledNodeType;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.nodes.VRMLUrlListener;
import org.web3d.vrml.renderer.common.nodes.BaseTimeControlledNode;
import org.web3d.vrml.util.URLChecker;

public class BaseAudioClip
extends BaseTimeControlledNode
implements VRMLSingleExternalNodeType,
VRMLTimeListener,
VRMLTimeDependentNodeType,
VRMLAudioClipNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{44, 52};
    private boolean isTimeListening;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    private static int[] urlFieldIndexList;
    private static final int FIELD_DESCRIPTION = 7;
    private static final int FIELD_PITCH = 8;
    private static final int FIELD_URL = 9;
    private static final int FIELD_DURATION = 10;
    private static final int FIELD_IS_ACTIVE = 11;
    private static final int LAST_AUDIOCLIP_INDEX = 11;
    private static final int NUM_FIELDS = 12;
    protected String vfDescription;
    protected boolean vfIsActive;
    protected float vfPitch;
    protected double vfDuration;
    protected String[] vfUrl;
    private ArrayList urlListeners = new ArrayList();
    private ArrayList soundStateListeners;
    private ArrayList contentListeners = new ArrayList();
    private int loadState = 1;
    private String worldURL;

    public BaseAudioClip() {
        super("AudioClip");
        this.soundStateListeners = new ArrayList();
        this.hasChanged = new boolean[12];
        this.vfUrl = new String[0];
        this.vfIsActive = false;
        this.vfLoop = false;
        this.vfStartTime = 0.0;
        this.vfStopTime = 0.0;
        this.vfDescription = null;
        this.vfPitch = 1.0f;
        this.vfDuration = -1.0;
        this.isTimeListening = false;
    }

    public void copy(VRMLNodeType vRMLNodeType) {
        this.checkNodeType(vRMLNodeType);
        try {
            super.copy((VRMLTimeControlledNodeType)vRMLNodeType);
            int n = vRMLNodeType.getFieldIndex("description");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setDescription(vRMLFieldData.stringValue);
            n = vRMLNodeType.getFieldIndex("loop");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setLoop(vRMLFieldData.booleanValue);
            n = vRMLNodeType.getFieldIndex("pitch");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setPitch(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("url");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setUrl(vRMLFieldData.stringArrayValue, vRMLFieldData.numElements);
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setStartTime(double d) {
        if (!this.vfIsActive) {
            super.setStartTime(d);
            if (this.vrmlClock != null) {
                this.resetTimeListener(this.vrmlClock.getTime());
            }
        }
    }

    public void setStopTime(double d) {
        if (!this.vfIsActive || !(d < this.vfStartTime)) {
            super.setStopTime(d);
            if (this.vrmlClock == null) {
                this.resetTimeListener(0.0);
            } else {
                this.resetTimeListener(this.vrmlClock.getTime());
            }
        }
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void setIsActive(boolean bl) {
        if (this.vfIsActive != bl) {
            this.vfIsActive = bl;
            if (!this.inSetup) {
                this.hasChanged[11] = true;
                this.fireFieldChanged(11);
            }
            this.fireSoundStateChanged();
        }
    }

    public void setPitch(float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("Invalid pitch, must be >0: " + f);
        }
        if (this.vfPitch != f && f > 0.0f) {
            this.vfPitch = f;
            if (!this.inSetup) {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
                this.fireSoundStateChanged();
            }
        }
    }

    public void setDuration(double d) {
        if (d != this.vfDuration) {
            this.vfDuration = d;
            if (!this.inSetup) {
                this.hasChanged[10] = true;
                this.fireFieldChanged(10);
            }
        }
    }

    public void addSoundStateListener(VRMLSoundStateListener vRMLSoundStateListener) {
        if (!this.soundStateListeners.contains(vRMLSoundStateListener)) {
            this.soundStateListeners.add(vRMLSoundStateListener);
        }
    }

    public void removeSoundStateListener(VRMLSoundStateListener vRMLSoundStateListener) {
        this.soundStateListeners.remove(vRMLSoundStateListener);
    }

    public void addContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        if (!this.contentListeners.contains(vRMLContentStateListener)) {
            this.contentListeners.add(vRMLContentStateListener);
        }
    }

    public void removeContentStateListener(VRMLContentStateListener vRMLContentStateListener) {
        this.contentListeners.remove(vRMLContentStateListener);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int getPrimaryType() {
        return 3;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 11) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 7: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfDescription;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfPitch;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfUrl;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = 1;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.doubleValue = this.vfDuration;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 11: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfIsActive;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfPitch);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfUrl, this.vfUrl.length);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfDuration);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfIsActive);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseMidiSource sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseMidiSource sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                this.setDescription(string);
                break;
            }
            case 9: {
                this.setUrl(new String[]{string}, 1);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                this.setUrl(stringArray, n2);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setPitch(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void allEventsComplete() {
        this.fireUrlChanged(9);
    }

    protected void fireUrlChanged(int n) {
        int n2 = this.urlListeners.size();
        for (int i = 0; i < n2; ++i) {
            VRMLUrlListener vRMLUrlListener = (VRMLUrlListener)this.urlListeners.get(i);
            vRMLUrlListener.urlChanged((VRMLNodeType)this, n);
        }
    }

    protected void fireSoundStateChanged() {
        int n = this.soundStateListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLSoundStateListener vRMLSoundStateListener = (VRMLSoundStateListener)this.soundStateListeners.get(i);
            vRMLSoundStateListener.soundStateChanged((VRMLNodeType)this, this.vfIsActive, this.vfLoop, this.vfPitch, this.vfStartTime);
        }
    }

    protected void fireContentStateChanged() {
        int n = this.contentListeners.size();
        for (int i = 0; i < n; ++i) {
            VRMLContentStateListener vRMLContentStateListener = (VRMLContentStateListener)this.contentListeners.get(i);
            vRMLContentStateListener.contentStateChanged((VRMLNodeType)this, 9, this.loadState);
        }
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(int n) {
        switch (n) {
            case 2: {
                break;
            }
            case 3: {
                if (!this.vfLoop) break;
                this.setIsActive(true);
                break;
            }
            case 4: {
                if (this.vfUrl == null || this.vfUrl.length <= 0) break;
                System.out.println("Loading failed: " + this.vfUrl[0]);
                break;
            }
            case 1: {
                break;
            }
            default: {
                System.out.println("Unknown state: " + n);
            }
        }
        this.loadState = n;
        this.fireContentStateChanged();
    }

    public void setUrl(String[] stringArray, int n) {
        this.vfUrl = n > 0 ? (this.worldURL != null ? URLChecker.checkURLs((String)this.worldURL, (String[])stringArray, (boolean)false) : stringArray) : FieldConstants.EMPTY_MFSTRING;
        if (!this.inSetup) {
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public String[] getUrl() {
        return this.vfUrl;
    }

    public boolean checkValidContentType(String string) {
        return true;
    }

    public void setLoadedURI(String string) {
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
    }

    public void setWorldUrl(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        this.worldURL = string.charAt(string.length() - 1) != '/' ? string + '/' : string;
        if (this.vfUrl != null) {
            this.vfUrl = URLChecker.checkURLs((String)this.worldURL, (String[])this.vfUrl, (boolean)false);
        }
    }

    public String getWorldUrl() {
        return this.worldURL;
    }

    public void addUrlListener(VRMLUrlListener vRMLUrlListener) {
        if (!this.urlListeners.contains(vRMLUrlListener)) {
            this.urlListeners.add(vRMLUrlListener);
        }
    }

    public void removeUrlListener(VRMLUrlListener vRMLUrlListener) {
        this.urlListeners.remove(vRMLUrlListener);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        super.setVRMLClock(vRMLClock);
        this.resetTimeListener(this.vrmlClock.getTime());
    }

    public void setLoop(boolean bl) {
        super.setLoop(bl);
        if (bl) {
            if (!this.vfIsActive) {
                this.setIsActive(true);
            }
        } else if (this.vrmlClock != null && this.vfStopTime <= this.vrmlClock.getTime()) {
            this.setIsActive(false);
        }
    }

    public void timeClick(long l) {
        this.resetTimeListener(l);
    }

    private void resetTimeListener(double d) {
        if (this.vfIsActive) {
            if (this.vfStopTime > this.vfStartTime && d >= this.vfStopTime) {
                this.setIsActive(false);
            }
        } else {
            if (this.vfStartTime >= d && this.vfLoop) {
                this.setIsActive(true);
            }
            if (this.vfStartTime != 0.0 && this.vfStartTime <= d && (this.vfStopTime <= this.vfStartTime || this.vfStopTime > d)) {
                this.setIsActive(true);
            }
        }
        boolean bl = false;
        if (this.vfIsActive) {
            if (this.vfStopTime > this.vfStartTime) {
                bl = true;
            }
        } else if (this.vfStartTime >= d) {
            bl = true;
        }
        if (this.vrmlClock != null && bl != this.isTimeListening) {
            if (this.isTimeListening) {
                this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
            } else {
                this.vrmlClock.addTimeListener((VRMLTimeListener)this);
            }
            this.isTimeListening = bl;
        }
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public float getPitch() {
        return this.vfPitch;
    }

    public double getDuration() {
        return this.vfDuration;
    }

    public boolean getIsActive() {
        return this.vfIsActive;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[12];
        fieldMap = new HashMap(36);
        BaseAudioClip.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseAudioClip.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFString", "description");
        BaseAudioClip.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "loop");
        BaseAudioClip.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "pitch");
        BaseAudioClip.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFTime", "startTime");
        BaseAudioClip.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFTime", "pauseTime");
        BaseAudioClip.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFTime", "resumeTime");
        BaseAudioClip.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFTime", "elapsedTime");
        BaseAudioClip.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFTime", "stopTime");
        BaseAudioClip.fieldDecl[9] = new VRMLFieldDeclaration(3, "MFString", "url");
        BaseAudioClip.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(7);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(1);
        fieldMap.put("loop", n);
        fieldMap.put("set_loop", n);
        fieldMap.put("loop_changed", n);
        n = new Integer(8);
        fieldMap.put("pitch", n);
        fieldMap.put("set_pitch", n);
        fieldMap.put("pitch_changed", n);
        n = new Integer(2);
        fieldMap.put("startTime", n);
        fieldMap.put("set_startTime", n);
        fieldMap.put("startTime_changed", n);
        n = new Integer(4);
        fieldMap.put("pauseTime", n);
        fieldMap.put("set_pauseTime", n);
        fieldMap.put("pauseTime_changed", n);
        n = new Integer(3);
        fieldMap.put("stopTime", n);
        fieldMap.put("set_stopTime", n);
        fieldMap.put("stopTime_changed", n);
        n = new Integer(5);
        fieldMap.put("resumeTime", n);
        fieldMap.put("set_resumeTime", n);
        fieldMap.put("resumeTime_changed", n);
        n = new Integer(9);
        fieldMap.put("url", n);
        fieldMap.put("set_url", n);
        fieldMap.put("url_changed", n);
        fieldMap.put("isActive", new Integer(11));
        fieldMap.put("duration_changed", new Integer(10));
        fieldMap.put("elapsedTime", new Integer(6));
        urlFieldIndexList = new int[1];
        BaseAudioClip.urlFieldIndexList[0] = 9;
    }
}

