/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sound;

import java.util.HashMap;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public class BaseMidiSource
extends AbstractNode
implements VRMLChildNodeType,
Receiver {
    private static final int FIELD_SELECTED = 1;
    private static final int FIELD_AVAILABLE = 2;
    private static final int FIELD_EVENT_COMMAND = 3;
    private static final int FIELD_EVENT_CHANNEL = 4;
    private static final int FIELD_EVENT_DATA1 = 5;
    private static final int FIELD_EVENT_DATA2 = 6;
    private static final int LAST_MIDI_SOURCE_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected String[] vfSelected;
    protected String[] vfAvailable;
    protected int[] vfEventChannel;
    protected int[] vfEventCommand;
    protected int[] vfEventData1;
    protected int[] vfEventData2;
    private int eventLen;
    private MidiDevice.Info info;
    private static final int EVENT_SIZE = 512;
    private int[][] commands;
    private int[][] channels;
    private int[][] data1;
    private int[][] data2;
    private int[] eventNum;
    private int buffNum;
    private MidiChannel[] ochannels;
    private boolean on;
    private long lastTime;

    public BaseMidiSource() {
        super("MidiSource");
        this.hasChanged = new boolean[7];
        this.vfSelected = null;
        this.channels = new int[2][512];
        this.commands = new int[2][512];
        this.data1 = new int[2][512];
        this.data2 = new int[2][512];
        this.eventNum = new int[2];
        this.vfEventChannel = new int[512];
        this.vfEventCommand = new int[512];
        this.vfEventData1 = new int[512];
        this.vfEventData2 = new int[512];
        this.buffNum = 0;
    }

    public BaseMidiSource(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("selected");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSelected = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfSelected, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void allEventsComplete() {
        int n = this.buffNum++;
        if (this.buffNum > 1) {
            this.buffNum = 0;
        }
        if (this.eventNum[n] > 0) {
            this.vfEventChannel = new int[this.eventNum[n]];
            this.vfEventCommand = new int[this.eventNum[n]];
            this.vfEventData1 = new int[this.eventNum[n]];
            this.vfEventData2 = new int[this.eventNum[n]];
            for (int i = 0; i < this.eventNum[n]; ++i) {
                this.vfEventChannel[i] = this.channels[n][i];
                this.vfEventCommand[i] = this.commands[n][i];
                this.vfEventData1[i] = this.data1[n][i];
                this.vfEventData2[i] = this.data2[n][i];
            }
            this.eventLen = this.eventNum[n];
            this.eventNum[n] = 0;
            this.hasChanged[4] = true;
            this.hasChanged[3] = true;
            this.hasChanged[5] = true;
            this.hasChanged[6] = true;
            this.fireFieldChanged(4);
            this.fireFieldChanged(3);
            this.fireFieldChanged(5);
            this.fireFieldChanged(6);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        this.initMidiDevice();
        try {
            Synthesizer synthesizer = null;
            synthesizer = MidiSystem.getSynthesizer();
            this.ochannels = synthesizer.getChannels();
            synthesizer.open();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 7;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfSelected;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfSelected == null ? 0 : this.vfSelected.length;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfAvailable;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfAvailable == null ? 0 : this.vfAvailable.length;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfEventChannel;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfEventChannel == null ? 0 : this.eventLen;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfEventCommand;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfEventCommand == null ? 0 : this.eventLen;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfEventData1;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfEventData1 == null ? 0 : this.eventLen;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfEventData2;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfEventData2 == null ? 0 : this.eventLen;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfSelected, this.vfSelected.length);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfAvailable, this.vfAvailable.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfEventChannel, this.vfEventChannel.length);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfEventCommand, this.vfEventCommand.length);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfEventData1, this.vfEventData1.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfEventData2, this.vfEventData2.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseMidiSource sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseMidiSource sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldFormatException, InvalidFieldException {
        switch (n) {
            case 1: {
                this.vfSelected = new String[]{string};
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldFormatException, InvalidFieldException, InvalidFieldValueException {
        if (n == 1) {
            if (this.vfSelected == null || this.vfSelected.length != n2) {
                this.vfSelected = new String[n2];
            }
            System.arraycopy(stringArray, 0, this.vfSelected, 0, n2);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        } else {
            super.setValue(n, stringArray, n2);
        }
    }

    public void close() {
    }

    public void send(MidiMessage midiMessage, long l) {
        if (midiMessage instanceof ShortMessage) {
            ShortMessage shortMessage = (ShortMessage)midiMessage;
            this.commands[this.buffNum][this.eventNum[this.buffNum]] = shortMessage.getCommand();
            this.data1[this.buffNum][this.eventNum[this.buffNum]] = shortMessage.getData1();
            int n = this.buffNum;
            int n2 = this.eventNum[n];
            this.eventNum[n] = n2 + 1;
            this.data2[this.buffNum][n2] = shortMessage.getData2();
            this.channels[this.buffNum][this.eventNum[this.buffNum]] = shortMessage.getChannel();
            switch (shortMessage.getCommand()) {
                case 128: {
                    this.ochannels[0].noteOff(55);
                    break;
                }
                case 144: {
                    System.out.println("note on: " + shortMessage.getData1() + " vel: " + shortMessage.getData2());
                    int n3 = Math.min(127, shortMessage.getData2() * 3);
                    int n4 = shortMessage.getData1();
                    if (n3 > 0) {
                        this.ochannels[0].noteOn(n4, n3);
                        break;
                    }
                    this.ochannels[0].noteOff(n4);
                    break;
                }
                case 160: {
                    break;
                }
                case 176: {
                    break;
                }
                case 192: {
                    break;
                }
                case 208: {
                    break;
                }
            }
        }
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    private void initMidiDevice() {
        this.info = this.getMidiDeviceInfo(this.vfSelected);
        if (this.info == null) {
            System.out.println("no device info found for name: ");
            for (int i = 0; i < this.vfSelected.length; ++i) {
                System.out.println("   " + this.vfSelected[i]);
            }
            return;
        }
        MidiDevice midiDevice = null;
        try {
            midiDevice = MidiSystem.getMidiDevice(this.info);
            midiDevice.open();
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
        if (midiDevice == null) {
            System.out.println("wasn't able to retrieve MidiDevice");
            return;
        }
        System.out.println("MIDI initialized");
        try {
            Transmitter transmitter = midiDevice.getTransmitter();
            transmitter.setReceiver(this);
        }
        catch (MidiUnavailableException midiUnavailableException) {
            midiUnavailableException.printStackTrace();
        }
    }

    private MidiDevice.Info getMidiDeviceInfo(String[] stringArray) {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        System.out.println("Midi Devices Found:");
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < infoArray.length; ++j) {
                System.out.print(infoArray[j].getName());
                if (infoArray[j].getName().equals(stringArray[i])) {
                    try {
                        MidiDevice midiDevice = MidiSystem.getMidiDevice(infoArray[j]);
                        boolean bl = midiDevice.getMaxTransmitters() != 0;
                        boolean bl2 = midiDevice.getMaxReceivers() != 0;
                        System.out.println(" inputs: " + midiDevice.getMaxTransmitters() + " outputs: " + midiDevice.getMaxReceivers());
                        if (bl) {
                            return infoArray[j];
                        }
                    }
                    catch (MidiUnavailableException midiUnavailableException) {}
                    continue;
                }
                System.out.println("");
            }
        }
        return null;
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(7);
        BaseMidiSource.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMidiSource.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFString", "selected");
        BaseMidiSource.fieldDecl[2] = new VRMLFieldDeclaration(4, "MFString", "available");
        BaseMidiSource.fieldDecl[4] = new VRMLFieldDeclaration(4, "MFInt32", "eventChannel");
        BaseMidiSource.fieldDecl[3] = new VRMLFieldDeclaration(4, "MFInt32", "eventCommand");
        BaseMidiSource.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFInt32", "eventData1");
        BaseMidiSource.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFInt32", "eventData2");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("selected", n);
        fieldMap.put("selected_changed", n);
        fieldMap.put("set_selected", n);
        n = new Integer(2);
        fieldMap.put("available", n);
        fieldMap.put("available_changed", n);
        n = new Integer(4);
        fieldMap.put("eventChannel", n);
        fieldMap.put("eventChannel_changed", n);
        n = new Integer(3);
        fieldMap.put("eventCommand", n);
        fieldMap.put("eventCommand_changed", n);
        n = new Integer(5);
        fieldMap.put("eventData1", n);
        fieldMap.put("eventData1_changed", n);
        n = new Integer(6);
        fieldMap.put("eventData2", n);
        fieldMap.put("eventData2_changed", n);
    }
}

