/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sound;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLAudioClipNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLContentStateListener;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSoundNodeType;
import org.web3d.vrml.nodes.VRMLSoundStateListener;
import org.web3d.vrml.nodes.VRMLTimeDependentNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;
import org.web3d.vrml.renderer.common.nodes.sound.BaseAudioClip;

public class BaseSound
extends AbstractNode
implements VRMLContentStateListener,
VRMLSoundStateListener,
VRMLTimeDependentNodeType,
VRMLSoundNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{52};
    private static final int FIELD_DIRECTION = 1;
    private static final int FIELD_INTENSITY = 2;
    private static final int FIELD_LOCATION = 3;
    private static final int FIELD_MAXBACK = 4;
    private static final int FIELD_MAXFRONT = 5;
    private static final int FIELD_MINBACK = 6;
    private static final int FIELD_MINFRONT = 7;
    private static final int FIELD_PRIORITY = 8;
    private static final int FIELD_SOURCE = 9;
    private static final int FIELD_SPATIALIZE = 10;
    private static final int LAST_SOUND_INDEX = 10;
    private static final int NUM_FIELDS = 11;
    protected static final String SOURCE_PROTO_MSG = "Proto does not describe a AudioClipNodeType object";
    protected static final String SOURCE_NODE_MSG = "Node does not describe a AudioClipNodeType object";
    protected VRMLClock vrmlClock;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfDirection = new float[]{0.0f, 0.0f, 1.0f};
    protected float vfIntensity = 1.0f;
    protected float[] vfLocation = new float[]{0.0f, 0.0f, 0.0f};
    protected float vfMaxBack = 10.0f;
    protected float vfMaxFront = 10.0f;
    protected float vfMinBack = 1.0f;
    protected float vfMinFront = 1.0f;
    protected float vfPriority = 0.0f;
    protected boolean vfSpatialize = true;
    protected VRMLAudioClipNodeType vfSource;
    protected VRMLProtoInstance pSource;

    public BaseSound() {
        super("Sound");
        this.hasChanged = new boolean[11];
    }

    public void copy(VRMLNodeType vRMLNodeType) {
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("direction");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setDirection(vRMLFieldData.floatArrayValue);
            n = vRMLNodeType.getFieldIndex("intensity");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setIntensity(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("location");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setLocation(vRMLFieldData.floatArrayValue);
            n = vRMLNodeType.getFieldIndex("maxBack");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setMaxBack(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("maxFront");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setMaxFront(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("minBack");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setMinBack(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("minFront");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setMinFront(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("priority");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.setPriority(vRMLFieldData.floatValue);
            n = vRMLNodeType.getFieldIndex("spatialize");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfSpatialize = vRMLFieldData.booleanValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean setDirection(float[] fArray) {
        this.vfDirection = fArray;
        if (!this.inSetup) {
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
        return true;
    }

    public boolean setIntensity(float f) {
        boolean bl = false;
        if (f != this.vfIntensity && f >= 0.0f && f <= 1.0f) {
            this.vfIntensity = f;
            if (!this.inSetup) {
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
            }
            bl = true;
        }
        return bl;
    }

    public boolean setLocation(float[] fArray) {
        this.vfLocation[0] = fArray[0];
        this.vfLocation[1] = fArray[1];
        this.vfLocation[2] = fArray[2];
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
        return true;
    }

    public boolean setMaxBack(float f) {
        boolean bl = false;
        if (f != this.vfMaxBack && f >= 0.0f) {
            this.vfMaxBack = f;
            if (!this.inSetup) {
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
            }
            bl = true;
        }
        return bl;
    }

    public boolean setMaxFront(float f) {
        boolean bl = false;
        if (f != this.vfMaxFront && f >= 0.0f) {
            this.vfMaxFront = f;
            if (!this.inSetup) {
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
            }
            bl = true;
        }
        return bl;
    }

    public boolean setMinBack(float f) {
        boolean bl = false;
        if (f != this.vfMinBack && f >= 0.0f) {
            this.vfMinBack = f;
            if (!this.inSetup) {
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
            }
            bl = true;
        }
        return bl;
    }

    public boolean setMinFront(float f) {
        boolean bl = false;
        if (f != this.vfMinFront && f >= 0.0f) {
            this.vfMinFront = f;
            if (!this.inSetup) {
                this.hasChanged[7] = true;
                this.fireFieldChanged(7);
            }
            bl = true;
        }
        return bl;
    }

    public boolean setPriority(float f) {
        boolean bl = false;
        if (f != this.vfPriority && f >= 0.0f && f <= 1.0f) {
            this.vfPriority = f;
            if (!this.inSetup) {
                this.hasChanged[8] = true;
                this.fireFieldChanged(8);
            }
            bl = true;
        }
        return bl;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pSource != null) {
            this.pSource.setupFinished();
        } else if (this.vfSource != null) {
            this.vfSource.setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 45;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfDirection;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 3;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfIntensity;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfLocation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 3;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxBack;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMaxFront;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMinBack;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfMinFront;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfPriority;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.nodeValue = this.vfSource;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 10: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfSpatialize;
                this.fieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfDirection, 3);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfIntensity);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfLocation, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfMaxBack);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfMaxFront);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfMinBack);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfMinFront);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfPriority);
                    break;
                }
                case 9: {
                    if (this.pSource != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pSource);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfSource);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 10: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("spatialize is initializeOnly");
                }
                this.vfSpatialize = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                this.setIntensity(f);
                break;
            }
            case 4: {
                this.setMaxBack(f);
                break;
            }
            case 5: {
                this.setMaxFront(f);
                break;
            }
            case 6: {
                this.setMinBack(f);
                break;
            }
            case 7: {
                this.setMinFront(f);
                break;
            }
            case 8: {
                this.setPriority(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setDirection(fArray);
                break;
            }
            case 3: {
                this.setLocation(fArray);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 9: {
                this.setSource(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void contentStateChanged(VRMLNodeType vRMLNodeType, int n, int n2) {
    }

    public void soundStateChanged(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2, float f, double d) {
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.vrmlClock = vRMLClock;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public VRMLAudioClipNodeType getSource() {
        return this.vfSource;
    }

    public void setSource(VRMLNodeType vRMLNodeType) {
        this.deleteSource();
        Object object = this.pSource != null ? this.pSource : this.vfSource;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLAudioClipNodeType)) {
                throw new InvalidFieldValueException(SOURCE_PROTO_MSG);
            }
            this.pSource = (VRMLProtoInstance)vRMLNodeType;
            this.vfSource = (VRMLAudioClipNodeType)vRMLNodeType2;
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLAudioClipNodeType)) {
                throw new InvalidFieldValueException(SOURCE_NODE_MSG);
            }
            this.pSource = null;
            this.vfSource = (VRMLAudioClipNodeType)vRMLNodeType;
        }
        if (vRMLNodeType != null) {
            vRMLNodeType.updateRefCount(true);
            ((BaseAudioClip)this.vfSource).addContentStateListener(this);
            ((BaseAudioClip)this.vfSource).addSoundStateListener(this);
        }
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[9] = true;
            this.fireFieldChanged(9);
        }
    }

    public void deleteSource() {
        if (this.vfSource != null) {
            ((BaseAudioClip)this.vfSource).removeSoundStateListener(this);
            ((BaseAudioClip)this.vfSource).removeContentStateListener(this);
        }
        this.vfSource = null;
    }

    static {
        nodeFields = new int[]{9, 0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseSound.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseSound.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFVec3f", "direction");
        BaseSound.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFFloat", "intensity");
        BaseSound.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFVec3f", "location");
        BaseSound.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "maxBack");
        BaseSound.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFFloat", "minBack");
        BaseSound.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFFloat", "maxFront");
        BaseSound.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "minFront");
        BaseSound.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFFloat", "priority");
        BaseSound.fieldDecl[9] = new VRMLFieldDeclaration(3, "SFNode", "source");
        BaseSound.fieldDecl[10] = new VRMLFieldDeclaration(2, "SFBool", "spatialize");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("direction", n);
        fieldMap.put("set_direction", n);
        fieldMap.put("direction_changed", n);
        n = new Integer(3);
        fieldMap.put("location", n);
        fieldMap.put("set_location", n);
        fieldMap.put("location_changed", n);
        n = new Integer(2);
        fieldMap.put("intensity", n);
        fieldMap.put("set_intensity", n);
        fieldMap.put("intensity_changed", n);
        n = new Integer(4);
        fieldMap.put("maxBack", n);
        fieldMap.put("set_maxBack", n);
        fieldMap.put("maxBack_changed", n);
        n = new Integer(6);
        fieldMap.put("minBack", n);
        fieldMap.put("set_minBack", n);
        fieldMap.put("minBack_changed", n);
        n = new Integer(5);
        fieldMap.put("maxFront", n);
        fieldMap.put("set_maxFront", n);
        fieldMap.put("maxFront_changed", n);
        n = new Integer(7);
        fieldMap.put("minFront", n);
        fieldMap.put("set_minFront", n);
        fieldMap.put("minFront_changed", n);
        n = new Integer(8);
        fieldMap.put("priority", n);
        fieldMap.put("set_priority", n);
        fieldMap.put("priority_changed", n);
        n = new Integer(9);
        fieldMap.put("source", n);
        fieldMap.put("set_source", n);
        fieldMap.put("source_changed", n);
        fieldMap.put("spatialize", new Integer(10));
    }
}

