/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.awt.Rectangle;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceLayoutNode;

public abstract class BaseGridLayout
extends BaseSurfaceLayoutNode {
    protected static final int FIELD_GRID_SIZE = 4;
    protected static final int LAST_GRID_LAYOUT_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    protected static final String GRID_SIZE_MSG = "One of the grid size dimensions < 1";
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfGridSize;

    protected BaseGridLayout() {
        super("GridLayout");
        this.hasChanged = new boolean[5];
        this.vfGridSize = new float[]{1.0f, 1.0f};
    }

    protected BaseGridLayout(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceChildNodeType)((VRMLSurfaceLayoutNodeType)vRMLNodeType));
        try {
            int n = vRMLNodeType.getFieldIndex("gridSize");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGridSize[0] = vRMLFieldData.floatArrayValue[0];
            this.vfGridSize[1] = vRMLFieldData.floatArrayValue[1];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setLocation(int n, int n2) {
        int n3 = n - (int)this.screenLocation[0];
        int n4 = n2 - (int)this.screenLocation[1];
        super.setLocation(n, n2);
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            int n5 = rectangle.x + n3;
            int n6 = rectangle.y + n4;
            vRMLSurfaceChildNodeType.setLocation(n5, n6);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f) {
            return;
        }
        this.updateManagedNodes();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfGridSize;
                this.fieldData.numElements = 1;
                this.fieldData.dataType = (short)11;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfGridSize, 2);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                if (fArray[0] < 1.0f || fArray[1] < 1.0f) {
                    throw new InvalidFieldValueException(GRID_SIZE_MSG);
                }
                this.vfGridSize[0] = fArray[0];
                this.vfGridSize[1] = fArray[1];
                if (this.inSetup) break;
                this.updateManagedNodes();
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    protected void updateManagedNodes() {
        int n;
        int n2 = this.screenBounds.x;
        int n3 = this.screenBounds.y;
        float f = 0.0f;
        float f2 = 0.0f;
        for (n = 0; n < this.vfChildren.length; ++n) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[n];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            f = f > (float)rectangle.width ? f : (float)rectangle.width;
            f2 = f2 > (float)rectangle.height ? f2 : (float)rectangle.height;
        }
        int n4 = (int)f;
        int n5 = (int)f2;
        int n6 = 0;
        n = 0;
        while ((float)n < this.vfGridSize[0] && n6 < this.vfChildren.length) {
            int n7 = 0;
            while ((float)n7 < this.vfGridSize[1] && n6 < this.vfChildren.length) {
                VRMLNodeType vRMLNodeType = this.vfChildren[n6];
                VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = null;
                if (vRMLNodeType == null) {
                    n2 += n4;
                    ++n6;
                } else {
                    VRMLProtoInstance vRMLProtoInstance;
                    if (vRMLNodeType instanceof VRMLSurfaceChildNodeType) {
                        vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLNodeType;
                    } else {
                        vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                        vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLProtoInstance.getImplementationNode();
                    }
                    if (vRMLSurfaceChildNodeType instanceof VRMLSurfaceLayoutNodeType) {
                        vRMLProtoInstance = (VRMLSurfaceLayoutNodeType)vRMLSurfaceChildNodeType;
                        vRMLProtoInstance.windowChanged(n2, n3, n4, n5);
                    } else {
                        vRMLSurfaceChildNodeType.setLocation(n2, n3);
                    }
                    n2 += n4;
                    ++n6;
                }
                ++n7;
            }
            n3 += n5;
            n2 = this.screenBounds.x;
            ++n;
        }
        this.screenBounds.width = n4 * (int)this.vfGridSize[1];
        this.screenBounds.height = n5 * (int)this.vfGridSize[0];
        if (!this.inSetup) {
            this.fireSizeChange(this.screenBounds.width, this.screenBounds.height);
        }
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseGridLayout.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseGridLayout.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseGridLayout.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseGridLayout.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseGridLayout.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec2f", "gridSize");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(4);
        fieldMap.put("gridSize", n);
        fieldMap.put("set_gridSize", n);
        fieldMap.put("gridSize_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
    }
}

