/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFontStyleNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceChildNode;
import org.web3d.vrml.util.FieldValidator;

public abstract class BaseText2D
extends BaseSurfaceChildNode
implements VRMLSurfaceChildNodeType {
    private static final String ANTIALIAS_PROP = "org.web3d.vrml.nodes.fontstyle.font.antialiased";
    private static final String FONTSTYLE_PROTO_MSG = "Proto does not describe a Text object";
    private static final String FONTSTYLE_NODE_MSG = "Node does not describe a Text object";
    protected static final boolean ANTIALIAS;
    protected static final int FIELD_FIXED_SIZE = 3;
    protected static final int FIELD_STRING = 4;
    protected static final int FIELD_TEXTCOLOR = 5;
    protected static final int FIELD_BGCOLOR = 6;
    protected static final int FIELD_TRANSPARENCY = 7;
    protected static final int FIELD_FONTSTYLE = 8;
    protected static final int LAST_TEXT2D_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected boolean vfFixedSize;
    protected String vfString;
    protected float[] vfTextColor;
    protected float[] vfBackgroundColor;
    protected float vfTransparency;
    protected VRMLFontStyleNodeType vfFontStyle;
    protected VRMLProtoInstance pFontStyle;

    protected BaseText2D() {
        super("Text2D");
        this.hasChanged = new boolean[9];
        this.vfFixedSize = true;
        this.vfTextColor = new float[]{1.0f, 1.0f, 1.0f};
        this.vfBackgroundColor = new float[3];
        this.vfTransparency = 1.0f;
    }

    protected BaseText2D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceChildNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("fixedSize");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfFixedSize = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("string");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfString = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("textColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTextColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTextColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTextColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("backgroundColor");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBackgroundColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBackgroundColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBackgroundColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("transparency");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTransparency = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfFixedSize;
                this.fieldData.dataType = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfString;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfTextColor;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBackgroundColor;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfTransparency;
                this.fieldData.dataType = (short)4;
                break;
            }
            case 8: {
                this.fieldData.nodeValue = this.pFontStyle != null ? this.pFontStyle : this.vfFontStyle;
                this.fieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfFixedSize);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfString);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfTextColor, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBackgroundColor, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfTransparency);
                    break;
                }
                case 8: {
                    if (this.pFontStyle != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pFontStyle);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfFontStyle);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pFontStyle != null) {
            this.pFontStyle.setupFinished();
        } else if (this.vfFontStyle != null) {
            this.vfFontStyle.setupFinished();
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("fixedSize is initializeOnly");
                }
                this.vfFixedSize = bl;
                this.updateSurface(3);
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 7) {
            super.setValue(n, f);
            return;
        }
        this.vfTransparency = f;
        this.updateSurface(7);
        if (!this.inSetup) {
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                FieldValidator.checkColorVector((String)"Text2D.textColor", (float[])fArray);
                this.vfTextColor[0] = fArray[0];
                this.vfTextColor[1] = fArray[1];
                this.vfTextColor[2] = fArray[2];
                break;
            }
            case 6: {
                FieldValidator.checkColorVector((String)"Text2D.backgroundColor", (float[])fArray);
                this.vfBackgroundColor[0] = fArray[0];
                this.vfBackgroundColor[1] = fArray[1];
                this.vfBackgroundColor[2] = fArray[2];
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
        if (!this.inSetup) {
            this.updateSurface(n);
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        if (n != 4) {
            super.setValue(n, string);
            return;
        }
        this.vfString = string;
        this.updateSurface(4);
        if (!this.inSetup) {
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 8: {
                this.setFontStyle(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setFontStyle(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLFontStyleNodeType vRMLFontStyleNodeType;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLFontStyleNodeType = (VRMLFontStyleNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pFontStyle = (VRMLProtoInstance)vRMLNodeType;
            int[] nArray = vRMLNodeType.getSecondaryType();
            boolean bl = false;
            for (int i = 0; i < nArray.length && !bl; ++i) {
                if (nArray[i] != 19) continue;
                bl = true;
            }
            if (!bl) {
                throw new InvalidFieldValueException(FONTSTYLE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLFontStyleNodeType)) {
                throw new InvalidFieldValueException(FONTSTYLE_NODE_MSG);
            }
            this.pFontStyle = null;
            vRMLFontStyleNodeType = (VRMLFontStyleNodeType)vRMLNodeType;
        }
        this.vfFontStyle = vRMLFontStyleNodeType;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public VRMLNodeType getFontStyle() {
        if (this.pFontStyle != null) {
            return this.pFontStyle;
        }
        return this.vfFontStyle;
    }

    protected void updateSurface(int n) {
    }

    static {
        nodeFields = new int[]{0, 8};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BaseText2D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseText2D.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseText2D.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseText2D.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFBool", "fixedSize");
        BaseText2D.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFString", "string");
        BaseText2D.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFColor", "textColor");
        BaseText2D.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFColor", "backgroundColor");
        BaseText2D.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFFloat", "transparency");
        BaseText2D.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFNode", "fontStyle");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(6);
        fieldMap.put("backgroundColor", n);
        fieldMap.put("set_backgroundColor", n);
        fieldMap.put("backgroundColor_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(4);
        fieldMap.put("string", n);
        fieldMap.put("set_string", n);
        fieldMap.put("string_changed", n);
        n = new Integer(5);
        fieldMap.put("textColor", n);
        fieldMap.put("set_textColor", n);
        fieldMap.put("textColor_changed", n);
        n = new Integer(7);
        fieldMap.put("transparency", n);
        fieldMap.put("set_transparency", n);
        fieldMap.put("transparency_changed", n);
        n = new Integer(8);
        fieldMap.put("fontStyle", n);
        fieldMap.put("set_fontStyle", n);
        fieldMap.put("fontStyle_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
        fieldMap.put("fixedSize", new Integer(3));
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(Boolean.getBoolean(BaseText2D.ANTIALIAS_PROP));
            }
        });
        ANTIALIAS = bl;
    }
}

