/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.surface;

import java.awt.Rectangle;
import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLSurfaceChildNodeType;
import org.web3d.vrml.nodes.VRMLSurfaceLayoutNodeType;
import org.web3d.vrml.renderer.common.nodes.surface.BaseSurfaceLayoutNode;

public abstract class BaseXYLayout
extends BaseSurfaceLayoutNode {
    protected static final int FIELD_POSITIONS = 4;
    protected static final int LAST_XY_LAYOUT_INDEX = 4;
    protected static final int NUM_FIELDS = 5;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfPositions;
    protected int numPositions;

    protected BaseXYLayout() {
        super("XYLayout");
        this.hasChanged = new boolean[5];
        this.vfPositions = FieldConstants.EMPTY_MFVEC2F;
    }

    protected BaseXYLayout(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSurfaceChildNodeType)((VRMLSurfaceLayoutNodeType)vRMLNodeType));
        try {
            int n = vRMLNodeType.getFieldIndex("horizontalAlign");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfPositions = new float[vRMLFieldData.numElements * 2];
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.vfPositions, 0, vRMLFieldData.numElements * 2);
                this.numPositions = vRMLFieldData.numElements * 2;
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f) {
            return;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            f = f > (float)rectangle.width ? f : (float)rectangle.width;
            f2 = f2 > (float)rectangle.height ? f2 : (float)rectangle.height;
        }
        if (this.vfBboxSize[0] == -1.0f) {
            this.screenBounds.width = (int)f;
        }
        if (this.vfBboxSize[1] == -1.0f) {
            this.screenBounds.height = (int)f2;
        }
        this.updateManagedNodes();
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfPositions;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = this.numPositions / 2;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfPositions, this.numPositions);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 4: {
                if (this.vfPositions.length < n2) {
                    this.vfPositions = new float[n2];
                }
                System.arraycopy(fArray, 0, this.vfPositions, 0, n2);
                this.numPositions = n2;
                if (this.inSetup) break;
                this.updateManagedNodes();
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setLocation(int n, int n2) {
        int n3 = n - (int)this.screenLocation[0];
        int n4 = n2 - (int)this.screenLocation[1];
        super.setLocation(n, n2);
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)this.vfChildren[i];
            Rectangle rectangle = vRMLSurfaceChildNodeType.getRealBounds();
            int n5 = rectangle.x + n3;
            int n6 = rectangle.y + n4;
            vRMLSurfaceChildNodeType.setLocation(n5, n6);
        }
    }

    protected void updateManagedNodes() {
        int n = this.screenBounds.x;
        int n2 = this.screenBounds.y;
        int n3 = 0;
        for (int i = 0; i < this.vfChildren.length; ++i) {
            VRMLNodeType vRMLNodeType = this.vfChildren[i];
            VRMLSurfaceChildNodeType vRMLSurfaceChildNodeType = null;
            if (vRMLNodeType == null) continue;
            if (vRMLNodeType instanceof VRMLSurfaceChildNodeType) {
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLNodeType;
            } else {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
                vRMLSurfaceChildNodeType = (VRMLSurfaceChildNodeType)vRMLProtoInstance.getImplementationNode();
            }
            if (this.numPositions == 0) {
                vRMLSurfaceChildNodeType.setLocation(n, n2);
                continue;
            }
            if (n3 >= this.numPositions) {
                n3 = this.numPositions - 1;
            }
            vRMLSurfaceChildNodeType.setLocation(n + (int)this.vfPositions[n3++], n2 + (int)this.vfPositions[n3++]);
        }
    }

    static {
        nodeFields = new int[]{3, 0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseXYLayout.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseXYLayout.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "visible");
        BaseXYLayout.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFVec2f", "bboxSize");
        BaseXYLayout.fieldDecl[3] = new VRMLFieldDeclaration(3, "MFNode", "children");
        BaseXYLayout.fieldDecl[4] = new VRMLFieldDeclaration(3, "MFVec2f", "positions");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("children", n);
        fieldMap.put("set_children", n);
        fieldMap.put("children_changed", n);
        n = new Integer(1);
        fieldMap.put("visible", n);
        fieldMap.put("set_visible", n);
        fieldMap.put("visible_changed", n);
        n = new Integer(4);
        fieldMap.put("positions", n);
        fieldMap.put("set_positions", n);
        fieldMap.put("positions_changed", n);
        fieldMap.put("bboxSize", new Integer(2));
    }
}

