/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.awt.image.RenderedImage;
import java.nio.Buffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldFormatException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMultiTextureNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTextureNode;
import org.web3d.vrml.util.FieldValidator;

public class BaseMultiTexture
extends BaseTextureNode
implements VRMLMultiTextureNodeType,
VRMLTextureListener {
    protected static final int FIELD_MODE = 1;
    protected static final int FIELD_TEXTURE = 2;
    protected static final int FIELD_COLOR = 3;
    protected static final int FIELD_ALPHA = 4;
    protected static final int FIELD_FUNCTION = 5;
    protected static final int FIELD_SOURCE = 6;
    protected static final int LAST_MULTITEXTURE_INDEX = 6;
    protected static final int NUM_FIELDS = 7;
    private static final String TEXTURE_PROTO_MSG = "Proto does not describe a Texture object";
    private static final String TEXTURE_NODE_MSG = "Node does not describe a Texture object";
    protected static final VRMLFieldDeclaration[] fieldDecl;
    protected static final HashMap fieldMap;
    private static final int[] nodeFields;
    protected String[] vfMode = new String[0];
    protected String[] vfFunction = new String[0];
    protected String[] vfSource = new String[0];
    protected ArrayList vfTexture = new ArrayList();
    protected float[] vfColor = new float[]{1.0f, 1.0f, 1.0f};
    protected float vfAlpha = 1.0f;
    protected static HashMap modeMap;
    protected static HashMap functionMap;
    protected static HashMap sourceMap;
    protected boolean[] loaded;

    protected BaseMultiTexture() {
        super("MultiTexture");
        this.hasChanged = new boolean[7];
    }

    protected BaseMultiTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("mode");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfMode = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfMode, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("function");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfFunction = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfFunction, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("source");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (vRMLFieldData.numElements != 0) {
                this.vfSource = new String[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.stringArrayValue, 0, this.vfSource, 0, vRMLFieldData.numElements);
            }
            n = vRMLNodeType.getFieldIndex("color");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfColor[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("alpha");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAlpha = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getTextureType() {
        return 2;
    }

    public String getCacheString(int n) {
        VRMLTextureNodeType vRMLTextureNodeType = (VRMLTextureNodeType)this.vfTexture.get(n);
        if (vRMLTextureNodeType == null) {
            return null;
        }
        return vRMLTextureNodeType.getCacheString(0);
    }

    public boolean getYUp() {
        return false;
    }

    public int getNumberTextures() {
        return this.vfTexture.size();
    }

    public void getTextures(int n, VRMLTextureNodeType[] vRMLTextureNodeTypeArray) {
        int n2 = this.vfTexture.size();
        for (int i = 0; i < n2; ++i) {
            vRMLTextureNodeTypeArray[i + n] = (VRMLTextureNodeType)this.vfTexture.get(i);
        }
    }

    public void getTextureParams(int n, int[] nArray, int[] nArray2, int[] nArray3) {
        int n2 = this.vfTexture.size();
        for (int i = 0; i < n2; ++i) {
            nArray[i + n] = this.vfMode.length > i ? this.getModeConst(this.vfMode[i]) : 15;
            nArray3[i + n] = this.vfSource.length > i ? this.getSourceConst(this.vfSource[i]) : 0;
            nArray2[i + n] = this.vfFunction.length > i ? this.getFunctionConst(this.vfFunction[i]) : 0;
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, RenderedImage renderedImage, String string) {
        int n2 = this.vfTexture.size();
        for (int i = 0; i < n2; ++i) {
            VRMLTextureNodeType vRMLTextureNodeType = (VRMLTextureNodeType)this.vfTexture.get(i);
            if (vRMLTextureNodeType != vRMLNodeType) continue;
            this.loaded[i] = true;
            this.fireTextureImageChanged(i, vRMLNodeType, renderedImage, string);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, RenderedImage[] renderedImageArray, String[] stringArray) {
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, Buffer buffer, String string) {
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, Buffer[] bufferArray, String[] stringArray) {
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfTexture.size();
        this.loaded = new boolean[n];
        block3: for (int i = 0; i < n; ++i) {
            VRMLTextureNodeType vRMLTextureNodeType = (VRMLTextureNodeType)this.vfTexture.get(i);
            vRMLTextureNodeType.setupFinished();
            switch (vRMLTextureNodeType.getTextureType()) {
                case 0: {
                    if (((VRMLTexture2DNodeType)vRMLTextureNodeType).getImage() == null) continue block3;
                    this.loaded[i] = true;
                    continue block3;
                }
                default: {
                    System.out.println("Unhandled texture type in BaseMultiTexture");
                }
            }
        }
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 50;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfMode;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfMode.length;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfSource;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfSource.length;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.stringArrayValue = this.vfFunction;
                this.fieldData.dataType = (short)14;
                this.fieldData.numElements = this.vfFunction.length;
                break;
            }
            case 2: {
                VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTexture.size()];
                this.vfTexture.toArray(vRMLNodeTypeArray);
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = vRMLNodeTypeArray;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = vRMLNodeTypeArray.length;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfAlpha;
                this.fieldData.dataType = (short)4;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfMode, this.vfMode.length);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfFunction, this.vfFunction.length);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfSource, this.vfSource.length);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfColor, 3);
                    break;
                }
                case 2: {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTexture.size()];
                    this.vfTexture.toArray(vRMLNodeTypeArray);
                    vRMLNodeType.setValue(n2, vRMLNodeTypeArray, vRMLNodeTypeArray.length);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAlpha);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldFormatException, InvalidFieldValueException {
        switch (n) {
            case 4: {
                this.vfAlpha = f;
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldFormatException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                FieldValidator.checkColorVector((String)"BaseMultitexture", (float[])fArray);
                this.vfColor[0] = fArray[0];
                this.vfColor[1] = fArray[1];
                this.vfColor[2] = fArray[2];
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setMode(new String[]{string});
                break;
            }
            case 5: {
                this.setFunction(new String[]{string});
                break;
            }
            case 6: {
                this.setSource(new String[]{string});
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.setMode(stringArray);
                break;
            }
            case 5: {
                this.setFunction(stringArray);
                break;
            }
            case 6: {
                this.setSource(stringArray);
                break;
            }
            default: {
                super.setValue(n, stringArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                if (!this.inSetup) {
                    this.vfTexture.clear();
                }
                this.loaded = new boolean[1];
                if (vRMLNodeType != null) {
                    this.addTextureNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                if (!this.inSetup) {
                    this.vfTexture.clear();
                }
                this.loaded = new boolean[n2];
                for (int i = 0; i < n2; ++i) {
                    this.addTextureNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void addTextureNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_PROTO_MSG);
            }
            this.vfTexture.add(vRMLNodeType2);
            ((VRMLTextureNodeType)vRMLNodeType).addTextureListener((VRMLTextureListener)this);
        } else {
            if (!(vRMLNodeType instanceof VRMLTextureNodeType)) {
                throw new InvalidFieldValueException(TEXTURE_NODE_MSG);
            }
            this.vfTexture.add(vRMLNodeType);
            ((VRMLTextureNodeType)vRMLNodeType).addTextureListener((VRMLTextureListener)this);
        }
    }

    private void setMode(String[] stringArray) {
        this.vfMode = stringArray;
        if (!this.inSetup) {
            this.sendTexParams();
            this.hasChanged[1] = true;
            this.fireFieldChanged(1);
        }
    }

    private void setFunction(String[] stringArray) {
        this.vfFunction = stringArray;
        if (!this.inSetup) {
            this.sendTexParams();
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setSource(String[] stringArray) {
        this.vfFunction = stringArray;
        if (!this.inSetup) {
            this.sendTexParams();
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected int getModeConst(String string) {
        Integer n = (Integer)modeMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    protected int getFunctionConst(String string) {
        Integer n = (Integer)functionMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    protected int getSourceConst(String string) {
        Integer n = (Integer)sourceMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private void sendTexParams() {
        int n = Math.max(this.vfMode.length, this.vfFunction.length);
        n = Math.max(n, this.vfSource.length);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (this.vfMode.length > i) {
                nArray[i] = this.getModeConst(this.vfMode[i]);
            }
            if (this.vfFunction.length > i) {
                nArray3[i] = this.getFunctionConst(this.vfFunction[i]);
            }
            if (this.vfSource.length <= i) continue;
            nArray2[i] = this.getSourceConst(this.vfSource[i]);
        }
        this.fireTextureParamsChanged(this.vfMode.length, this, nArray, nArray2, nArray3, this.vfAlpha, this.vfColor);
    }

    static {
        nodeFields = new int[]{2, 0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BaseMultiTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMultiTexture.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFString", "mode");
        BaseMultiTexture.fieldDecl[5] = new VRMLFieldDeclaration(3, "MFString", "function");
        BaseMultiTexture.fieldDecl[6] = new VRMLFieldDeclaration(3, "MFString", "source");
        BaseMultiTexture.fieldDecl[2] = new VRMLFieldDeclaration(3, "MFNode", "texture");
        BaseMultiTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFColor", "color");
        BaseMultiTexture.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFFloat", "alpha");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("mode", n);
        fieldMap.put("set_mode", n);
        fieldMap.put("mode_changed", n);
        n = new Integer(6);
        fieldMap.put("source", n);
        fieldMap.put("set_source", n);
        fieldMap.put("source_changed", n);
        n = new Integer(5);
        fieldMap.put("function", n);
        fieldMap.put("set_function", n);
        fieldMap.put("function_changed", n);
        n = new Integer(2);
        fieldMap.put("texture", n);
        fieldMap.put("set_texture", n);
        fieldMap.put("texture_changed", n);
        n = new Integer(3);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(4);
        fieldMap.put("alpha", n);
        fieldMap.put("set_alpha", n);
        fieldMap.put("alpha_loaded", n);
        modeMap = new HashMap(19);
        modeMap.put("MODULATE", new Integer(0));
        modeMap.put("REPLACE", new Integer(1));
        modeMap.put("MODULATE2X", new Integer(2));
        modeMap.put("MODULATE4X", new Integer(3));
        modeMap.put("ADD", new Integer(4));
        modeMap.put("ADDSIGNED", new Integer(5));
        modeMap.put("ADDSIGNED2X", new Integer(6));
        modeMap.put("SUBTRACT", new Integer(7));
        modeMap.put("ADDSMOOTH", new Integer(8));
        modeMap.put("BLENDDIFFUSEALPHA", new Integer(9));
        modeMap.put("BLENDTEXTUREALPHA", new Integer(10));
        modeMap.put("BLENDFACTORALPHA", new Integer(11));
        modeMap.put("BLENDCURRENTALPHA", new Integer(12));
        modeMap.put("MODULATEALPHA_ADDCOLOR", new Integer(13));
        modeMap.put("MODULATEINVCOLOR_ADDALPHA", new Integer(14));
        modeMap.put("OFF", new Integer(15));
        modeMap.put("SELECTARG1", new Integer(16));
        modeMap.put("SELECTARG2", new Integer(17));
        modeMap.put("DOTPRODUCT3", new Integer(18));
        sourceMap = new HashMap(4);
        sourceMap.put("", new Integer(0));
        sourceMap.put("DIFFUSE", new Integer(1));
        sourceMap.put("SPECULAR", new Integer(2));
        sourceMap.put("FACTOR", new Integer(3));
        functionMap = new HashMap(3);
        functionMap.put("", new Integer(0));
        functionMap.put("COMPLEMENT", new Integer(1));
        functionMap.put("ALPHAREPLICATE", new Integer(2));
    }
}

