/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseGeometricPropertyNode;

public abstract class BaseMultiTextureCoordinate
extends BaseGeometricPropertyNode
implements VRMLTextureCoordinateNodeType {
    private static final String COORDINATE_PROTO_MSG = "Proto does not describe a TextureCoordinate object";
    private static final String COORDINATE_NODE_MSG = "Node does not describe a TextureCoordinate object";
    protected static final int FIELD_TEXCOORD = 1;
    protected static final int LAST_MULTITEXTURECOORDINATE_INDEX = 1;
    private static final int NUM_FIELDS = 2;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected VRMLNodeType[] vfTextureCoordinate = new VRMLNodeType[0];
    protected int lastTC = 0;
    private HashMap tcMap = new HashMap(2);
    private int lastTCSet = 0;

    protected BaseMultiTextureCoordinate() {
        super("MultiTextureCoordinate");
        this.hasChanged = new boolean[2];
    }

    protected BaseMultiTextureCoordinate(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        for (int i = 0; i < this.vfTextureCoordinate.length; ++i) {
            this.vfTextureCoordinate[i].setupFinished();
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 1) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 48;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        this.fieldData.clear();
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.nodeArrayValue = this.vfTextureCoordinate;
                this.fieldData.dataType = (short)13;
                this.fieldData.numElements = this.vfTextureCoordinate.length;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfTextureCoordinate, this.vfTextureCoordinate.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("TextureTransform sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("TextureTransform sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfTextureCoordinate = new VRMLNodeType[1];
                    this.lastTC = 0;
                    this.lastTCSet = 0;
                } else {
                    VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.vfTextureCoordinate.length + 1];
                    System.arraycopy(this.vfTextureCoordinate, 0, vRMLNodeTypeArray, 0, this.vfTextureCoordinate.length);
                    this.vfTextureCoordinate = vRMLNodeTypeArray;
                }
                if (vRMLNodeType != null) {
                    this.addTextureCoordinateNode(vRMLNodeType);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    this.vfTextureCoordinate = new VRMLNodeType[n2];
                    this.lastTC = 0;
                    this.lastTCSet = 0;
                } else {
                    VRMLNodeType[] vRMLNodeTypeArray2 = new VRMLNodeType[this.vfTextureCoordinate.length + n2];
                    System.arraycopy(this.vfTextureCoordinate, 0, vRMLNodeTypeArray2, 0, this.vfTextureCoordinate.length);
                    this.vfTextureCoordinate = vRMLNodeTypeArray2;
                }
                for (int i = 0; i < n2; ++i) {
                    this.addTextureCoordinateNode(vRMLNodeTypeArray[i]);
                }
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeTypeArray, n2);
            }
        }
    }

    protected void addTextureCoordinateNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLNodeType vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORDINATE_PROTO_MSG);
            }
            this.vfTextureCoordinate[this.lastTC++] = vRMLNodeType2;
            Integer n = (Integer)this.tcMap.get(vRMLNodeType2);
            if (n == null) {
                this.tcMap.put(vRMLNodeType2, new Integer(this.lastTCSet++));
            }
        } else {
            if (!(vRMLNodeType instanceof VRMLTextureCoordinateNodeType)) {
                throw new InvalidFieldValueException(COORDINATE_NODE_MSG);
            }
            this.vfTextureCoordinate[this.lastTC++] = vRMLNodeType;
            Integer n = (Integer)this.tcMap.get(vRMLNodeType);
            if (n == null) {
                this.tcMap.put(vRMLNodeType, new Integer(this.lastTCSet++));
            }
        }
    }

    public int getNumTextureComponents() {
        return 2;
    }

    public int getNumSets() {
        return this.vfTextureCoordinate.length;
    }

    public int getSize(int n) {
        return ((VRMLTextureCoordinateNodeType)this.vfTextureCoordinate[n]).getSize(0);
    }

    public void setPoint(int n, float[] fArray, int n2) {
        if (n > this.vfTextureCoordinate.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        VRMLNodeType vRMLNodeType = this.vfTextureCoordinate[n];
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            vRMLTextureCoordinateNodeType.setPoint(0, fArray, n2);
        } else {
            ((VRMLTextureCoordinateNodeType)vRMLNodeType).setPoint(0, fArray, n2);
        }
        this.fireComponentChanged(1);
        this.hasChanged[1] = true;
        this.fireFieldChanged(1);
    }

    public void getPoint(int n, float[] fArray) {
        if (n > this.vfTextureCoordinate.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        VRMLNodeType vRMLNodeType = this.vfTextureCoordinate[n];
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            vRMLTextureCoordinateNodeType.getPoint(0, fArray);
        } else {
            ((VRMLTextureCoordinateNodeType)vRMLNodeType).getPoint(0, fArray);
        }
    }

    public int isShared(int n) {
        Integer n2 = (Integer)this.tcMap.get(this.vfTextureCoordinate[n]);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public String getTexCoordGenMode(int n) {
        VRMLNodeType vRMLNodeType = this.vfTextureCoordinate[n];
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType = (VRMLTextureCoordinateNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            return vRMLTextureCoordinateNodeType.getTexCoordGenMode(0);
        }
        return ((VRMLTextureCoordinateNodeType)vRMLNodeType).getTexCoordGenMode(0);
    }

    static {
        nodeFields = new int[]{0, 1};
        fieldDecl = new VRMLFieldDeclaration[2];
        fieldMap = new HashMap(6);
        BaseMultiTextureCoordinate.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseMultiTextureCoordinate.fieldDecl[1] = new VRMLFieldDeclaration(3, "MFNode", "texCoord");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
    }
}

