/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLEnvironmentTextureNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTextureNode;

public abstract class BasePixelCubeMapTexture
extends BaseTextureNode
implements VRMLEnvironmentTextureNodeType {
    protected static final int FIELD_FRONT = 1;
    protected static final int FIELD_BACK = 2;
    protected static final int FIELD_LEFT = 3;
    protected static final int FIELD_RIGHT = 4;
    protected static final int FIELD_TOP = 5;
    protected static final int FIELD_BOTTOM = 6;
    private static final int LAST_PIXELTEXTURE_INDEX = 6;
    private static final int NUM_FIELDS = 7;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfFront;
    protected int vfFrontLen;
    protected int[] vfBack;
    protected int vfBackLen;
    protected int[] vfLeft;
    protected int vfLeftLen;
    protected int[] vfRight;
    protected int vfRightLen;
    protected int[] vfTop;
    protected int vfTopLen;
    protected int[] vfBottom;
    protected int vfBottomLen;

    public BasePixelCubeMapTexture() {
        super("PixelTexture");
        this.hasChanged = new boolean[7];
        this.vfFront = FieldConstants.EMPTY_SFIMAGE;
        this.vfBack = FieldConstants.EMPTY_SFIMAGE;
        this.vfLeft = FieldConstants.EMPTY_SFIMAGE;
        this.vfRight = FieldConstants.EMPTY_SFIMAGE;
        this.vfTop = FieldConstants.EMPTY_SFIMAGE;
        this.vfBottom = FieldConstants.EMPTY_SFIMAGE;
    }

    public BasePixelCubeMapTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("front");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            int n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfFront = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfFront, 0, n2);
            this.vfFrontLen = n2;
            n = vRMLNodeType.getFieldIndex("back");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfBack = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfBack, 0, n2);
            this.vfBackLen = n2;
            n = vRMLNodeType.getFieldIndex("left");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfLeft = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfLeft, 0, n2);
            this.vfLeftLen = n2;
            n = vRMLNodeType.getFieldIndex("right");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfRight = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfRight, 0, n2);
            this.vfRightLen = n2;
            n = vRMLNodeType.getFieldIndex("top");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfTop = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfTop, 0, n2);
            this.vfTopLen = n2;
            n = vRMLNodeType.getFieldIndex("bottom");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            n2 = vRMLFieldData.intArrayValue[1] * vRMLFieldData.intArrayValue[2];
            this.vfBottom = new int[n2];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfBottom, 0, n2);
            this.vfBottomLen = n2;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getTextureType() {
        return 2;
    }

    public boolean getYUp() {
        return false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 6) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 50;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfFront;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfFrontLen;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfBack;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfBackLen;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfLeft;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfLeftLen;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfRight;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfRightLen;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfTop;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfTopLen;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfBottom;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfBottomLen;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfFront, 1);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfBack, 1);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfLeft, 1);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfRight, 1);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfTop, 1);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfBottom, 1);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 1: {
                int n3 = nArray[1] * nArray[2];
                if (n3 > this.vfFront.length) {
                    this.vfFront = new int[n3];
                }
                System.arraycopy(nArray, 0, this.vfFront, 0, n3);
                this.vfFrontLen = n3;
                this.processImageData(1);
                if (this.inSetup) break;
                this.hasChanged[1] = true;
                this.fireFieldChanged(1);
                break;
            }
            case 2: {
                int n4 = nArray[1] * nArray[2];
                if (n4 > this.vfBack.length) {
                    this.vfBack = new int[n4];
                }
                System.arraycopy(nArray, 0, this.vfBack, 0, n4);
                this.vfBackLen = n4;
                this.processImageData(2);
                if (this.inSetup) break;
                this.hasChanged[2] = true;
                this.fireFieldChanged(2);
                break;
            }
            case 3: {
                int n5 = nArray[1] * nArray[2];
                if (n5 > this.vfLeft.length) {
                    this.vfLeft = new int[n5];
                }
                System.arraycopy(nArray, 0, this.vfLeft, 0, n5);
                this.vfLeftLen = n5;
                this.processImageData(3);
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            case 4: {
                int n6 = nArray[1] * nArray[2];
                if (n6 > this.vfRight.length) {
                    this.vfRight = new int[n6];
                }
                System.arraycopy(nArray, 0, this.vfRight, 0, n6);
                this.vfRightLen = n6;
                this.processImageData(4);
                if (this.inSetup) break;
                this.hasChanged[4] = true;
                this.fireFieldChanged(4);
                break;
            }
            case 5: {
                int n7 = nArray[1] * nArray[2];
                if (n7 > this.vfTop.length) {
                    this.vfTop = new int[n7];
                }
                System.arraycopy(nArray, 0, this.vfTop, 0, n7);
                this.vfTopLen = n7;
                this.processImageData(5);
                if (this.inSetup) break;
                this.hasChanged[5] = true;
                this.fireFieldChanged(5);
                break;
            }
            case 6: {
                int n8 = nArray[1] * nArray[2];
                if (n8 > this.vfBottom.length) {
                    this.vfBottom = new int[n8];
                }
                System.arraycopy(nArray, 0, this.vfBottom, 0, n8);
                this.vfBottomLen = n8;
                this.processImageData(6);
                if (this.inSetup) break;
                this.hasChanged[6] = true;
                this.fireFieldChanged(6);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    protected abstract void processImageData(int var1);

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[7];
        fieldMap = new HashMap(21);
        BasePixelCubeMapTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePixelCubeMapTexture.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFImage", "front");
        BasePixelCubeMapTexture.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFImage", "back");
        BasePixelCubeMapTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFImage", "left");
        BasePixelCubeMapTexture.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFImage", "right");
        BasePixelCubeMapTexture.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFImage", "top");
        BasePixelCubeMapTexture.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFImage", "bottom");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("front", n);
        fieldMap.put("set_front", n);
        fieldMap.put("front_changed", n);
        n = new Integer(2);
        fieldMap.put("back", n);
        fieldMap.put("set_back", n);
        fieldMap.put("back_changed", n);
        n = new Integer(3);
        fieldMap.put("left", n);
        fieldMap.put("set_left", n);
        fieldMap.put("left_changed", n);
        n = new Integer(6);
        fieldMap.put("bottom", n);
        fieldMap.put("set_bottom", n);
        fieldMap.put("bottom_changed", n);
        n = new Integer(4);
        fieldMap.put("right", n);
        fieldMap.put("set_right", n);
        fieldMap.put("right_changed", n);
        n = new Integer(5);
        fieldMap.put("top", n);
        fieldMap.put("set_top", n);
        fieldMap.put("top_changed", n);
    }
}

