/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTexture2DNode;

public abstract class BasePixelTexture
extends BaseTexture2DNode {
    protected static final int FIELD_IMAGE = 3;
    private static final int LAST_PIXELTEXTURE_INDEX = 3;
    private static final int NUM_FIELDS = 4;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected int[] vfImage;
    protected int vfImageLen;

    public BasePixelTexture() {
        super("PixelTexture");
        this.hasChanged = new boolean[4];
        this.vfImage = FieldConstants.EMPTY_SFIMAGE;
    }

    public BasePixelTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLTexture2DNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("image");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfImage = new int[vRMLFieldData.numElements];
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfImage, 0, vRMLFieldData.numElements);
            this.vfImageLen = vRMLFieldData.numElements;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public boolean getYUp() {
        return false;
    }

    public String getCacheString(int n) {
        return null;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 50;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfImage;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfImageLen;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfImage, this.vfImageLen);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException {
        switch (n) {
            case 3: {
                if (n2 > this.vfImage.length) {
                    this.vfImage = new int[n2];
                }
                System.arraycopy(nArray, 0, this.vfImage, 0, n2);
                this.vfImageLen = n2;
                this.processImageData();
                if (this.inSetup) break;
                this.hasChanged[3] = true;
                this.fireFieldChanged(3);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    protected abstract void processImageData();

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[4];
        fieldMap = new HashMap(12);
        BasePixelTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BasePixelTexture.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BasePixelTexture.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BasePixelTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFImage", "image");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("image", n);
        fieldMap.put("set_image", n);
        fieldMap.put("image_changed", n);
        fieldMap.put("repeatS", new Integer(1));
        fieldMap.put("repeatT", new Integer(2));
    }
}

