/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseTexture2DNode;

public abstract class BaseRenderedTexture
extends BaseTexture2DNode
implements VRMLTexture2DNodeType {
    protected static final int FIELD_UPDATE = 3;
    protected static final int FIELD_DIMENSIONS = 4;
    protected static final int FIELD_BACKGROUND = 5;
    protected static final int FIELD_FOG = 6;
    protected static final int FIELD_VIEWPOINT = 7;
    protected static final int FIELD_SCENE = 8;
    protected static final int LAST_RENDERED_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    protected static final String BACKGROUND_PROTO_MSG = "Proto does not describe a Background object";
    protected static final String BACKGROUND_NODE_MSG = "Node does not describe a Background object";
    protected static final String FOG_PROTO_MSG = "Proto does not describe a Fog object";
    protected static final String FOG_NODE_MSG = "Node does not describe a Fog object";
    protected static final String VIEWPOINT_PROTO_MSG = "Proto does not describe a Viewpoint object";
    protected static final String VIEWPOINT_NODE_MSG = "Node does not describe a Viewpoint object";
    protected static final String SCENE_PROTO_MSG = "Proto does not describe a Scene object";
    protected static final String SCENE_NODE_MSG = "Node does not describe a Scene object";
    protected static final int UPDATE_NONE = 1;
    protected static final int UPDATE_NEXT = 2;
    protected static final int UPDATE_ALWAYS = 3;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected static HashMap updateMap;
    protected String vfUpdate;
    protected int updateFlag;
    protected int[] vfDimensions;
    protected VRMLBackgroundNodeType vfBackground;
    protected VRMLProtoInstance pBackground;
    protected VRMLViewpointNodeType vfViewpoint;
    protected VRMLProtoInstance pViewpoint;
    protected VRMLFogNodeType vfFog;
    protected VRMLProtoInstance pFog;
    protected VRMLGroupingNodeType vfScene;
    protected VRMLProtoInstance pScene;

    public BaseRenderedTexture() {
        super("RenderedTexture");
        this.hasChanged = new boolean[9];
        this.vfUpdate = "NONE";
        this.vfRepeatS = true;
        this.vfRepeatT = true;
        this.vfDimensions = new int[]{128, 128, 3};
        this.updateFlag = 1;
    }

    public BaseRenderedTexture(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLTexture2DNodeType)vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("update");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfUpdate = vRMLFieldData.stringValue;
            Integer n2 = (Integer)updateMap.get(this.vfUpdate);
            this.updateFlag = n2;
            n = vRMLNodeType.getFieldIndex("dimensions");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            if (this.vfDimensions.length < vRMLFieldData.numElements) {
                this.vfDimensions = new int[vRMLFieldData.numElements];
                System.arraycopy(vRMLFieldData.intArrayValue, 0, this.vfDimensions, 0, vRMLFieldData.numElements);
            }
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getTextureType() {
        return 4;
    }

    public boolean getYUp() {
        return false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int getPrimaryType() {
        return 50;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.pBackground != null) {
            this.pBackground.setupFinished();
        } else if (this.vfBackground != null) {
            this.vfBackground.setupFinished();
        }
        if (this.pFog != null) {
            this.pFog.setupFinished();
        } else if (this.vfFog != null) {
            this.vfFog.setupFinished();
        }
        if (this.pViewpoint != null) {
            this.pViewpoint.setupFinished();
        } else if (this.vfViewpoint != null) {
            this.vfViewpoint.setupFinished();
        }
        if (this.pScene != null) {
            this.pScene.setupFinished();
        } else if (this.vfScene != null) {
            this.vfScene.setupFinished();
        }
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 3: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfUpdate;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.intArrayValue = this.vfDimensions;
                this.fieldData.dataType = (short)9;
                this.fieldData.numElements = this.vfDimensions.length;
                break;
            }
            case 5: {
                this.fieldData.nodeValue = this.pBackground != null ? this.pBackground : this.vfBackground;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 6: {
                this.fieldData.nodeValue = this.pFog != null ? this.pFog : this.vfFog;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 7: {
                this.fieldData.nodeValue = this.pViewpoint != null ? this.pViewpoint : this.vfViewpoint;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 8: {
                this.fieldData.nodeValue = this.pScene != null ? this.pScene : this.vfScene;
                this.fieldData.dataType = (short)7;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 5: {
                    if (this.pBackground != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pBackground);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfBackground);
                    break;
                }
                case 6: {
                    if (this.pFog != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pFog);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfFog);
                    break;
                }
                case 7: {
                    if (this.pViewpoint != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pViewpoint);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfViewpoint);
                    break;
                }
                case 8: {
                    if (this.pScene != null) {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)this.pScene);
                        break;
                    }
                    vRMLNodeType.setValue(n2, (VRMLNodeType)this.vfScene);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfUpdate);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Text sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Text sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                this.setUpdate(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        switch (n) {
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("The dimension field is initializeOnly");
                }
                if (n2 > this.vfDimensions.length) {
                    this.vfDimensions = new int[n2];
                }
                System.arraycopy(nArray, 0, this.vfDimensions, 0, n2);
                break;
            }
            default: {
                super.setValue(n, nArray, n2);
            }
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 5: {
                this.setBackground(vRMLNodeType);
                break;
            }
            case 6: {
                this.setFog(vRMLNodeType);
                break;
            }
            case 7: {
                this.setViewpoint(vRMLNodeType);
                break;
            }
            case 8: {
                this.setScene(vRMLNodeType);
                break;
            }
            default: {
                super.setValue(n, vRMLNodeType);
            }
        }
    }

    protected void setUpdate(String string) {
        Integer n = (Integer)updateMap.get(string);
        if (n == null) {
            throw new InvalidFieldValueException("Bogus update flag " + string);
        }
        this.vfUpdate = string;
        this.updateFlag = n;
        if (!this.inSetup) {
            this.hasChanged[3] = true;
            this.fireFieldChanged(3);
        }
    }

    protected void setBackground(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLBackgroundNodeType vRMLBackgroundNodeType;
        Object object = this.pBackground != null ? this.pBackground : this.vfBackground;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLBackgroundNodeType = (VRMLBackgroundNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pBackground = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLBackgroundNodeType != null && !(vRMLBackgroundNodeType instanceof VRMLBackgroundNodeType)) {
                throw new InvalidFieldValueException(BACKGROUND_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLBackgroundNodeType)) {
                throw new InvalidFieldValueException(BACKGROUND_NODE_MSG);
            }
            this.pBackground = null;
            vRMLBackgroundNodeType = (VRMLBackgroundNodeType)vRMLNodeType;
        }
        this.vfBackground = vRMLBackgroundNodeType;
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                vRMLNodeType.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    protected void setFog(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLFogNodeType vRMLFogNodeType;
        Object object = this.pFog != null ? this.pFog : this.vfFog;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLFogNodeType = (VRMLFogNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pFog = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLFogNodeType != null && !(vRMLFogNodeType instanceof VRMLFogNodeType)) {
                throw new InvalidFieldValueException(FOG_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLFogNodeType)) {
                throw new InvalidFieldValueException(FOG_NODE_MSG);
            }
            this.pFog = null;
            vRMLFogNodeType = (VRMLFogNodeType)vRMLNodeType;
        }
        this.vfFog = vRMLFogNodeType;
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                vRMLNodeType.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    protected void setViewpoint(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLViewpointNodeType vRMLViewpointNodeType;
        Object object = this.pViewpoint != null ? this.pViewpoint : this.vfViewpoint;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLViewpointNodeType = (VRMLViewpointNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pViewpoint = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLViewpointNodeType != null && !(vRMLViewpointNodeType instanceof VRMLViewpointNodeType)) {
                throw new InvalidFieldValueException(VIEWPOINT_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLViewpointNodeType)) {
                throw new InvalidFieldValueException(VIEWPOINT_NODE_MSG);
            }
            this.pViewpoint = null;
            vRMLViewpointNodeType = (VRMLViewpointNodeType)vRMLNodeType;
        }
        this.vfViewpoint = vRMLViewpointNodeType;
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                vRMLNodeType.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    protected void setScene(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLGroupingNodeType vRMLGroupingNodeType;
        Object object = this.pScene != null ? this.pScene : this.vfScene;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLGroupingNodeType = (VRMLGroupingNodeType)((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            this.pScene = (VRMLProtoInstance)vRMLNodeType;
            if (vRMLGroupingNodeType != null && !(vRMLGroupingNodeType instanceof VRMLGroupingNodeType)) {
                throw new InvalidFieldValueException(SCENE_PROTO_MSG);
            }
        } else {
            if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLGroupingNodeType)) {
                throw new InvalidFieldValueException(SCENE_NODE_MSG);
            }
            this.pScene = null;
            vRMLGroupingNodeType = (VRMLGroupingNodeType)vRMLNodeType;
        }
        this.vfScene = vRMLGroupingNodeType;
        if (!this.inSetup) {
            if (object != null) {
                object.updateRefCount(false);
                this.stateManager.registerRemovedNode((VRMLNode)object);
            }
            if (vRMLNodeType != null) {
                vRMLNodeType.updateRefCount(true);
                this.stateManager.registerAddedNode((VRMLNode)vRMLNodeType);
            }
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    static {
        nodeFields = new int[]{0, 5, 6, 7, 8};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BaseRenderedTexture.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseRenderedTexture.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFBool", "repeatS");
        BaseRenderedTexture.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFBool", "repeatT");
        BaseRenderedTexture.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFNode", "background");
        BaseRenderedTexture.fieldDecl[7] = new VRMLFieldDeclaration(3, "SFNode", "viewpoint");
        BaseRenderedTexture.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFNode", "fog");
        BaseRenderedTexture.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFNode", "scene");
        BaseRenderedTexture.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFString", "update");
        BaseRenderedTexture.fieldDecl[4] = new VRMLFieldDeclaration(2, "MFInt32", "dimensions");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(8);
        fieldMap.put("scene", n);
        fieldMap.put("set_scene", n);
        fieldMap.put("scene_changed", n);
        n = new Integer(5);
        fieldMap.put("background", n);
        fieldMap.put("set_background", n);
        fieldMap.put("background_changed", n);
        n = new Integer(6);
        fieldMap.put("fog", n);
        fieldMap.put("set_fog", n);
        fieldMap.put("fog_changed", n);
        n = new Integer(7);
        fieldMap.put("viewpoint", n);
        fieldMap.put("set_viewpoint", n);
        fieldMap.put("viewpoint_changed", n);
        n = new Integer(3);
        fieldMap.put("update", n);
        fieldMap.put("set_update", n);
        fieldMap.put("update_changed", n);
        fieldMap.put("dimensions", new Integer(4));
        fieldMap.put("repeatS", new Integer(1));
        fieldMap.put("repeatT", new Integer(2));
        updateMap = new HashMap();
        updateMap.put("NONE", new Integer(1));
        updateMap.put("NEXT_FRAME_ONLY", new Integer(2));
        updateMap.put("ALWAYS", new Integer(3));
    }
}

