/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseTextureProperties
extends AbstractNode {
    protected static final int FIELD_BOUNDARY_COLOR = 1;
    protected static final int FIELD_BOUNDARY_WIDTH = 2;
    protected static final int FIELD_BOUNDARY_MODE_S = 3;
    protected static final int FIELD_BOUNDARY_MODE_T = 4;
    protected static final int FIELD_MAGNIFICATION_FILTER = 5;
    protected static final int FIELD_MINIFICATION_FILTER = 6;
    protected static final int FIELD_GENERATE_MIPMAPS = 7;
    protected static final int FIELD_ANISOTROPIC_MODE = 8;
    protected static final int FIELD_ANISOTROPIC_FILTER_DEGREE = 9;
    protected static final int LAST_TEXTUREPROPS_INDEX = 9;
    protected static final int NUM_FIELDS = 10;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfBoundaryColor;
    protected int vfBoundaryWidth;
    protected String vfBoundaryModeS;
    protected String vfBoundaryModeT;
    protected String vfMagnificationFilter;
    protected String vfMinificationFilter;
    protected boolean vfGenerateMipMaps;
    protected String vfAnisotropicMode;
    protected float vfAnisotropicFilterDegree;

    protected BaseTextureProperties() {
        super("TextureProperties");
        this.hasChanged = new boolean[10];
        this.vfBoundaryColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        this.vfBoundaryWidth = 0;
        this.vfBoundaryModeS = "WRAP";
        this.vfBoundaryModeT = "WRAP";
        this.vfMagnificationFilter = "FASTEST";
        this.vfMinificationFilter = "FASTEST";
        this.vfGenerateMipMaps = false;
        this.vfAnisotropicMode = "NONE";
        this.vfAnisotropicFilterDegree = 1.0f;
    }

    protected BaseTextureProperties(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("boundaryColor");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBoundaryColor[0] = vRMLFieldData.floatArrayValue[0];
            this.vfBoundaryColor[1] = vRMLFieldData.floatArrayValue[1];
            this.vfBoundaryColor[2] = vRMLFieldData.floatArrayValue[2];
            this.vfBoundaryColor[3] = vRMLFieldData.floatArrayValue[3];
            n = vRMLNodeType.getFieldIndex("boundaryWidth");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBoundaryWidth = vRMLFieldData.intValue;
            n = vRMLNodeType.getFieldIndex("boundaryModeS");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBoundaryModeS = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("boundaryModeT");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfBoundaryModeT = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("minificationFilter");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinificationFilter = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("maxificationFilter");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfMinificationFilter = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("generateMipMaps");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfGenerateMipMaps = vRMLFieldData.booleanValue;
            n = vRMLNodeType.getFieldIndex("anisotropicMode");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnisotropicMode = vRMLFieldData.stringValue;
            n = vRMLNodeType.getFieldIndex("anisotropicFilterDegree");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnisotropicFilterDegree = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void setupFinished() {
        super.setupFinished();
        if (!this.inSetup) {
            return;
        }
        this.inSetup = false;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 9) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public int getPrimaryType() {
        return 1;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfBoundaryColor;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.intValue = this.vfBoundaryWidth;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 5: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfMagnificationFilter;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 6: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfMinificationFilter;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 7: {
                this.fieldData.clear();
                this.fieldData.booleanValue = this.vfGenerateMipMaps;
                this.fieldData.dataType = 1;
                break;
            }
            case 8: {
                this.fieldData.clear();
                this.fieldData.stringValue = this.vfAnisotropicMode;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 9: {
                this.fieldData.clear();
                this.fieldData.floatValue = this.vfAnisotropicFilterDegree;
                this.fieldData.dataType = (short)4;
                break;
            }
            default: {
                return super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfBoundaryColor, 4);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfBoundaryWidth);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfBoundaryModeS);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfBoundaryModeT);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfMagnificationFilter);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfMinificationFilter);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfGenerateMipMaps);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfAnisotropicMode);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfAnisotropicFilterDegree);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 7: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set generateMipMaps field.");
                }
                this.vfGenerateMipMaps = bl;
                break;
            }
            default: {
                super.setValue(n, bl);
            }
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 9: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set anistropicFilterDegree field.");
                }
                this.vfAnisotropicFilterDegree = f;
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 2: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set boundaryWidth field.");
                }
                this.vfBoundaryWidth = n2;
                break;
            }
            default: {
                super.setValue(n, n2);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set boundaryColor field.");
                }
                this.vfBoundaryColor[0] = fArray[0];
                this.vfBoundaryColor[1] = fArray[1];
                this.vfBoundaryColor[2] = fArray[2];
                this.vfBoundaryColor[3] = fArray[3];
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 3: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set boundaryModeS field.");
                }
                this.vfBoundaryModeS = string;
                break;
            }
            case 4: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set boundaryModeT field.");
                }
                this.vfBoundaryModeT = string;
                break;
            }
            case 5: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set magnificationFilter field.");
                }
                this.vfMagnificationFilter = string;
                break;
            }
            case 6: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set minificationFilter field.");
                }
                this.vfMinificationFilter = string;
                break;
            }
            case 8: {
                if (!this.inSetup) {
                    throw new InvalidFieldAccessException("Cannot set anistropicMode field.");
                }
                this.vfAnisotropicMode = string;
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[10];
        fieldMap = new HashMap(30);
        BaseTextureProperties.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTextureProperties.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFColorRGBA", "boundaryColor");
        BaseTextureProperties.fieldDecl[2] = new VRMLFieldDeclaration(2, "SFInt32", "boundaryWidth");
        BaseTextureProperties.fieldDecl[3] = new VRMLFieldDeclaration(2, "SFString", "boundaryModeS");
        BaseTextureProperties.fieldDecl[4] = new VRMLFieldDeclaration(2, "SFString", "boundaryModeT");
        BaseTextureProperties.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFString", "magnificationFilter");
        BaseTextureProperties.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFString", "minificationFilter");
        BaseTextureProperties.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "generateMipMaps");
        BaseTextureProperties.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFString", "anisotropicMode");
        BaseTextureProperties.fieldDecl[9] = new VRMLFieldDeclaration(2, "SFFloat", "anisotropicFilterDegree");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("boundaryColor", n);
        n = new Integer(2);
        fieldMap.put("boundaryWidth", n);
        n = new Integer(3);
        fieldMap.put("boundaryModeS", n);
        n = new Integer(4);
        fieldMap.put("boundaryModeT", n);
        n = new Integer(5);
        fieldMap.put("magnificationFilter", n);
        n = new Integer(6);
        fieldMap.put("minificationFilter", n);
        n = new Integer(7);
        fieldMap.put("generateMipMaps", n);
        n = new Integer(8);
        fieldMap.put("anisotropicMode", n);
        n = new Integer(9);
        fieldMap.put("anisotropicFilterDegree", n);
    }
}

