/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.texture;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTextureTransformNodeType;
import org.web3d.vrml.renderer.common.nodes.AbstractNode;

public abstract class BaseTextureTransform3D
extends AbstractNode
implements VRMLTextureTransformNodeType {
    protected static final int FIELD_CENTER = 1;
    protected static final int FIELD_ORIENTATION = 2;
    protected static final int FIELD_SCALE = 3;
    protected static final int FIELD_TRANSLATION = 4;
    protected static final int LAST_TEXTURETRANSFORM_INDEX = 4;
    private static final int NUM_FIELDS = 5;
    protected static VRMLFieldDeclaration[] fieldDecl;
    protected static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfCenter = new float[]{0.0f, 0.0f, 0.0f};
    protected float[] vfOrientation = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
    protected float[] vfScale = new float[]{1.0f, 1.0f, 1.0f};
    protected float[] vfTranslation = new float[]{0.0f, 0.0f, 0.0f};

    protected BaseTextureTransform3D() {
        super("TextureTransform3D");
        this.hasChanged = new boolean[5];
    }

    protected BaseTextureTransform3D(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("center");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfCenter[0] = vRMLFieldData.floatArrayValue[0];
            this.vfCenter[1] = vRMLFieldData.floatArrayValue[1];
            this.vfCenter[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("scale");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfScale[0] = vRMLFieldData.floatArrayValue[0];
            this.vfScale[1] = vRMLFieldData.floatArrayValue[1];
            this.vfScale[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("translation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfTranslation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfTranslation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfTranslation[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("rotation");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfOrientation[0] = vRMLFieldData.floatArrayValue[0];
            this.vfOrientation[1] = vRMLFieldData.floatArrayValue[1];
            this.vfOrientation[2] = vRMLFieldData.floatArrayValue[2];
            this.vfOrientation[3] = vRMLFieldData.floatArrayValue[3];
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 4) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 51;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        switch (n) {
            case 1: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfCenter;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 2: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfOrientation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 3: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfScale;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            case 4: {
                this.fieldData.clear();
                this.fieldData.floatArrayValue = this.vfTranslation;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return this.fieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 1: {
                    vRMLNodeType.setValue(n2, this.vfCenter, 3);
                    break;
                }
                case 2: {
                    vRMLNodeType.setValue(n2, this.vfOrientation, 4);
                    break;
                }
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfScale, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfTranslation, 3);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("TextureTransform sendRoute: No field!" + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("TextureTransform sendRoute: Invalid field Value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        switch (n) {
            case 1: {
                this.vfCenter[0] = fArray[0];
                this.vfCenter[1] = fArray[1];
                this.vfCenter[2] = fArray[2];
                break;
            }
            case 3: {
                this.vfScale[0] = fArray[0];
                this.vfScale[1] = fArray[1];
                this.vfScale[2] = fArray[2];
                break;
            }
            case 4: {
                this.vfTranslation[0] = fArray[0];
                this.vfTranslation[1] = fArray[1];
                this.vfTranslation[2] = fArray[2];
                break;
            }
            case 2: {
                this.vfOrientation[0] = fArray[0];
                this.vfOrientation[1] = fArray[1];
                this.vfOrientation[2] = fArray[2];
                this.vfOrientation[3] = fArray[3];
                break;
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
        if (!this.inSetup) {
            this.hasChanged[n] = true;
            this.fireFieldChanged(n);
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[5];
        fieldMap = new HashMap(15);
        BaseTextureTransform3D.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTextureTransform3D.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFVec3f", "center");
        BaseTextureTransform3D.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFRotation", "orientation");
        BaseTextureTransform3D.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFVec3f", "scale");
        BaseTextureTransform3D.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "translation");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(3);
        fieldMap.put("scale", n);
        fieldMap.put("set_scale", n);
        fieldMap.put("scale_changed", n);
        n = new Integer(1);
        fieldMap.put("center", n);
        fieldMap.put("set_center", n);
        fieldMap.put("center_changed", n);
        n = new Integer(2);
        fieldMap.put("orientation", n);
        fieldMap.put("set_orientation", n);
        fieldMap.put("orientation_changed", n);
        n = new Integer(4);
        fieldMap.put("translation", n);
        fieldMap.put("set_translation", n);
        fieldMap.put("translation_changed", n);
    }
}

