/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish;

import com.google.common.eventbus.Subscribe;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.commons.codec.binary.Hex;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IridiumMsgRx;
import pt.lsts.imc.IridiumMsgTx;
import pt.lsts.imc.IridiumTxStatus;
import pt.lsts.imc.LogBookEntry;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.RemoteSensorInfo;
import pt.lsts.imc.TextMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.iridium.ActivateSubscription;
import pt.lsts.neptus.comm.iridium.DeactivateSubscription;
import pt.lsts.neptus.comm.iridium.DesiredAssetPosition;
import pt.lsts.neptus.comm.iridium.ExtendedDeviceUpdate;
import pt.lsts.neptus.comm.iridium.ImcIridiumMessage;
import pt.lsts.neptus.comm.iridium.IridiumCommand;
import pt.lsts.neptus.comm.iridium.IridiumManager;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.comm.iridium.Position;
import pt.lsts.neptus.comm.iridium.TargetAssetPosition;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.sunfish.VirtualDrifter;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Iridium Communications Plug-in", icon="pt/lsts/neptus/plugins/sunfish/iridium.png")
public class IridiumComms
extends SimpleRendererInteraction
implements IPeriodicUpdates {
    private static final long serialVersionUID = -8535642303286049869L;
    protected long lastMessageReceivedTime = System.currentTimeMillis() - 3600000L;
    protected LinkedHashMap<String, RemoteSensorInfo> sensorData = new LinkedHashMap();
    private static final String[] iridiumDestinations = new String[]{"broadcast", "manta-1", "manta-11", "lauv-xplore-1", "lauv-seacon-2", "lauv-seacon-3"};
    protected final int HERMES_ID = 2241;
    protected Vector<VirtualDrifter> drifters = new Vector();
    protected LinkedHashMap<String, Image> systemImages = new LinkedHashMap();
    @NeptusProperty(name="Wave Glider", description="Imc id of neptus console of wave glider operator", category="IMC id", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int wgOpImcId = 0;
    @NeptusProperty(name="Remote Neptus", description="Imc id of neptus console operating remotely", category="IMC id", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int neptusOpImcId = 0;

    public long millisBetweenUpdates() {
        return 60000L;
    }

    @Subscribe
    public void on(IridiumMsgRx msg) {
        try {
            byte[] data = msg.getData();
            NeptusLog.pub().info((Object)(msg.getSourceName() + " received iridium message with data " + new String(Hex.encodeHex((byte[])data))));
            IridiumMessage m = IridiumMessage.deserialize((byte[])data);
            if (m instanceof ExtendedDeviceUpdate) {
                ExtendedDeviceUpdate upd = (ExtendedDeviceUpdate)m;
                for (Position p : upd.getPositions().values()) {
                    RemoteSensorInfo rsi = new RemoteSensorInfo();
                    rsi.setTimestamp(p.timestamp);
                    rsi.setLat(p.latRads);
                    rsi.setLon(p.lonRads);
                    String name = IMCDefinition.getInstance().getResolver().resolve(p.id);
                    if (name != null) {
                        rsi.setId(IMCDefinition.getInstance().getResolver().resolve(p.id));
                    } else {
                        rsi.setId(String.format("Unknown (%X)", p.id));
                    }
                    rsi.setSensorClass(IMCUtils.getSystemType((int)p.id));
                    ImcMsgManager.getManager().postInternalMessage("IridiumComms", (IMCMessage)rsi);
                }
            }
            NeptusLog.pub().info((Object)("Resulting message: " + m));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    @Subscribe
    public void on(IridiumMsgTx msg) {
        try {
            byte[] data = msg.getData();
            NeptusLog.pub().info((Object)(msg.getSourceName() + " request sending of iridium message with data " + new String(Hex.encodeHex((byte[])data))));
            IridiumMessage m = IridiumMessage.deserialize((byte[])data);
            NeptusLog.pub().info((Object)("Encoded message: " + m));
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public boolean update() {
        for (VirtualDrifter d : this.drifters) {
            RemoteSensorInfo rsi = new RemoteSensorInfo();
            rsi.setId(d.id);
            LocationType loc = d.getLocation();
            rsi.setLat(loc.getLatitudeRads());
            rsi.setLon(loc.getLongitudeRads());
            rsi.setTimestampMillis(System.currentTimeMillis());
            rsi.setSensorClass("drifter");
            ImcMsgManager.getManager().postInternalMessage("IridiumComms", (IMCMessage)rsi);
            this.post(rsi);
        }
        return true;
    }

    public boolean isExclusive() {
        return true;
    }

    private void commandPlanExecution() {
        Object selection;
        Set planNames = this.getConsole().getMission().getIndividualPlansList().keySet();
        if (planNames.isEmpty()) {
            return;
        }
        String selectedPlan = (String)planNames.iterator().next();
        if (this.getConsole().getPlan() != null) {
            selectedPlan = this.getConsole().getPlan().getId();
        }
        if ((selection = JOptionPane.showInputDialog((Component)this.getConsole(), "Select plan to be commanded via Iridium", "Start plan", 3, null, planNames.toArray(), selectedPlan)) == null) {
            return;
        }
        Thread send = new Thread("Send plan via iridium"){

            @Override
            public void run() {
                String selectedPlan = selection.toString();
                PlanType toSend = (PlanType)IridiumComms.this.getConsole().getMission().getIndividualPlansList().get(selectedPlan);
                IMCMessage msg = toSend.asIMCPlan();
                PlanControl pc = new PlanControl();
                pc.setArg(msg);
                pc.setOp(PlanControl.OP.START);
                pc.setType(PlanControl.TYPE.REQUEST);
                pc.setPlanId(selectedPlan);
                IridiumComms.this.sendViaIridium(IridiumComms.this.getMainVehicleId(), (IMCMessage)pc);
            }
        };
        send.setDaemon(true);
        send.start();
    }

    private void sendTextNote() {
        String note = JOptionPane.showInputDialog((Component)this.getConsole(), (Object)I18n.text((String)"Enter note to be published"));
        if (note == null || note.isEmpty()) {
            return;
        }
        LogBookEntry entry = new LogBookEntry();
        entry.setText(note);
        entry.setTimestampMillis(System.currentTimeMillis());
        entry.setSrc(ImcMsgManager.getManager().getLocalId().intValue());
        Object selection = JOptionPane.showInputDialog((Component)this.getConsole(), "Please enter destination of this message", "Send Text Note", 3, null, iridiumDestinations, "manta-1");
        if (selection == null) {
            return;
        }
        if (selection.equals("broadcast")) {
            entry.setDst(65535);
        } else {
            entry.setDst(IMCDefinition.getInstance().getResolver().resolve("" + selection));
        }
        entry.setContext("Iridium logbook");
        ImcIridiumMessage msg = new ImcIridiumMessage();
        msg.setSource(ImcMsgManager.getManager().getLocalId().intValue());
        msg.setDestination(65535);
        msg.setMsg((IMCMessage)entry);
        try {
            IridiumManager.getManager().send((IridiumMessage)msg);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
        this.getConsole().post((Object)Notification.success((String)"Iridium message sent", (String)("1 Iridium messages were sent using " + IridiumManager.getManager().getCurrentMessenger().getName())));
    }

    private void sendIridiumCommand() {
        String cmd = JOptionPane.showInputDialog((Component)this.getConsole(), (Object)I18n.textf((String)"Enter command to be sent to %vehicle", (Object[])new Object[]{this.getMainVehicleId()}));
        if (cmd == null || cmd.isEmpty()) {
            return;
        }
        IridiumCommand command = new IridiumCommand();
        command.setCommand(cmd);
        VehicleType vt = VehiclesHolder.getVehicleById((String)this.getMainVehicleId());
        if (vt == null) {
            GuiUtils.errorMessage((Component)this.getConsole(), (String)"Send Iridium Command", (String)"Could not calculate destination's IMC identifier");
            return;
        }
        command.setDestination(vt.getImcId().intValue());
        command.setSource(ImcMsgManager.getManager().getLocalId().intValue());
        try {
            IridiumManager.getManager().send((IridiumMessage)command);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
        this.getConsole().post((Object)Notification.success((String)"Iridium message sent", (String)("1 Iridium messages were sent using " + IridiumManager.getManager().getCurrentMessenger().getName())));
    }

    private void setWaveGliderTargetPosition(LocationType loc) {
        TargetAssetPosition pos = new TargetAssetPosition();
        pos.setLocation(loc);
        pos.setDestination(this.neptusOpImcId);
        pos.setAssetImcId(2241);
        pos.setSource(ImcMsgManager.getManager().getLocalId().intValue());
        try {
            IridiumManager.getManager().send((IridiumMessage)pos);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    private void setWaveGliderDesiredPosition(LocationType loc) {
        DesiredAssetPosition pos = new DesiredAssetPosition();
        pos.setAssetImcId(2241);
        pos.setLocation(loc);
        pos.setDestination(this.wgOpImcId);
        pos.setSource(ImcMsgManager.getManager().getLocalId().intValue());
        try {
            IridiumManager.getManager().send((IridiumMessage)pos);
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() != 3) {
            super.mouseClicked(event, source);
            return;
        }
        final LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
        loc.convertToAbsoluteLatLonDepth();
        JPopupMenu popup = new JPopupMenu();
        if (IridiumManager.getManager().isActive()) {
            popup.add(I18n.text((String)"Deactivate Polling")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IridiumManager.getManager().stop();
                }
            });
        } else {
            popup.add(I18n.text((String)"Activate Polling")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IridiumManager.getManager().start();
                }
            });
        }
        popup.add(I18n.text((String)"Select Iridium gateway")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumManager.getManager().selectMessenger((Component)IridiumComms.this.getConsole());
            }
        });
        popup.addSeparator();
        popup.add(I18n.textf((String)"Send %vehicle a command via Iridium", (Object[])new Object[]{this.getMainVehicleId()})).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumComms.this.sendIridiumCommand();
            }
        });
        popup.add(I18n.textf((String)"Command %vehicle a plan via Iridium", (Object[])new Object[]{this.getMainVehicleId()})).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumComms.this.commandPlanExecution();
            }
        });
        popup.add(I18n.textf((String)"Subscribe to iridium device updates", (Object[])new Object[]{this.getMainVehicleId()})).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActivateSubscription activate = new ActivateSubscription();
                activate.setDestination(255);
                activate.setSource(ImcMsgManager.getManager().getLocalId().intValue());
                try {
                    IridiumManager.getManager().send((IridiumMessage)activate);
                    IridiumComms.this.getConsole().post((Object)Notification.success((String)"Iridium message sent", (String)("1 Iridium messages were sent using " + IridiumManager.getManager().getCurrentMessenger().getName())));
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)IridiumComms.this.getConsole(), (Exception)ex);
                }
            }
        });
        popup.add(I18n.textf((String)"Unsubscribe to iridium device updates", (Object[])new Object[]{this.getMainVehicleId()})).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeactivateSubscription deactivate = new DeactivateSubscription();
                deactivate.setDestination(255);
                deactivate.setSource(ImcMsgManager.getManager().getLocalId().intValue());
                try {
                    IridiumManager.getManager().send((IridiumMessage)deactivate);
                }
                catch (Exception ex) {
                    GuiUtils.errorMessage((Component)IridiumComms.this.getConsole(), (Exception)ex);
                }
            }
        });
        popup.add("Set this as actual wave glider target").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumComms.this.setWaveGliderTargetPosition(loc);
            }
        });
        popup.add("Set this as desired wave glider target").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumComms.this.setWaveGliderDesiredPosition(loc);
            }
        });
        popup.addSeparator();
        popup.add(I18n.text((String)"Send a text note")).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumComms.this.sendTextNote();
            }
        });
        popup.add("Add virtual drifter").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualDrifter d = new VirtualDrifter(loc, 0.0, 0.1);
                PropertiesEditor.editProperties((PropertiesProvider)d, (boolean)true);
                IridiumComms.this.drifters.add(d);
                IridiumComms.this.update();
            }
        });
        popup.show((Component)source, event.getX(), event.getY());
    }

    @Subscribe
    public void on(IridiumTxStatus status) {
        switch (status.getStatus()) {
            case ERROR: {
                this.post(Notification.warning((String)I18n.text((String)"Iridium communications"), (String)I18n.text((String)"Error sending iridium message")).src(status.getSourceName()));
                break;
            }
            case EXPIRED: {
                this.post(Notification.warning((String)I18n.text((String)"Iridium communications"), (String)I18n.text((String)"Iridium message transmission time has expired")).src(status.getSourceName()));
                break;
            }
            case OK: {
                this.post(Notification.success((String)I18n.text((String)"Iridium communications"), (String)I18n.text((String)"Iridium message sent successfully")).src(status.getSourceName()));
                break;
            }
            case QUEUED: {
                this.post(Notification.warning((String)I18n.text((String)"Iridium communications"), (String)I18n.text((String)"Iridium message was queued for later transmission")).src(status.getSourceName()));
                break;
            }
            case TRANSMIT: {
                this.post(Notification.warning((String)I18n.text((String)"Iridium communications"), (String)I18n.text((String)"Iridium message is being transmited")).src(status.getSourceName()));
            }
        }
    }

    public IridiumComms(ConsoleLayout console) {
        super(console);
    }

    @Subscribe
    public void on(TextMessage msg) {
        NeptusLog.pub().info((Object)"Received text message");
        this.post(Notification.info((String)"Text message", (String)(msg.getSourceName() + ": " + msg.getText())));
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

