/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.sunfish;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCUtil;
import pt.lsts.neptus.comm.iridium.IridiumMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.gui.tablelayout.TableLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.ByteUtil;
import pt.lsts.neptus.util.GuiUtils;

public class IridiumMessageDebugger
extends ConsolePanel {
    private static final long serialVersionUID = -1397409355043125958L;
    JTextField raw = new JTextField();
    JButton parse = new JButton(I18n.text((String)"Parse"));
    JTabbedPane msgs = new JTabbedPane();

    public IridiumMessageDebugger(ConsoleLayout console) {
        super(console);
        this.setLayout((LayoutManager)new TableLayout(new double[]{0.8, 0.2}, new double[]{24.0, -1.0}));
        this.add(this.raw, "0,0");
        this.add(this.parse, "1,0");
        this.add(this.msgs, "0,1 1,1");
        this.parse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IridiumMessageDebugger.this.parse(IridiumMessageDebugger.this.raw.getText());
            }
        });
    }

    public void parse(String text) {
        this.msgs.removeAll();
        try {
            byte[] data = ByteUtil.decodeHexString((String)text);
            IridiumMessage msg = IridiumMessage.deserialize((byte[])data);
            System.out.println(msg.getMessageType());
            for (IMCMessage m : msg.asImc()) {
                String html = IMCUtil.getAsHtml((IMCMessage)m);
                JLabel lbl = new JLabel(html);
                JScrollPane scroll = new JScrollPane(lbl);
                this.msgs.addTab(m.getAbbrev(), scroll);
            }
            this.msgs.invalidate();
            this.msgs.revalidate();
        }
        catch (Exception e) {
            GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
        }
    }

    public void cleanSubPanel() {
    }

    public void initSubPanel() {
    }

    public static void main(String[] args) {
        GuiUtils.testFrame((JComponent)((Object)new IridiumMessageDebugger(null)));
    }
}

